/*
 * MU lpd / opr / opctl / opq
 *
 *	This file includes those parameters likely to change from
 *	installation to installation, in general they may be set to
 *	anything sensible.
 *
 *	You will also probably want to alter the layout of the banner
 *	page. This is coded into banner.c, but is not difficult to change.
 */

/*
 *		Conditional compilation options
 */
#define	TTY		/* define if any output through tty driver */
#define	LPR		/* define if any output through pr / la driver */
#define	LOCK		/* lock device driver exists */


/*
 *		Known path names
 */

#define	SPOOLDIR	"/usr/spool/lpd"
#define	LOCKFILE	"/usr/spool/lpd/lock"
#define	LPDLOCK		"/usr/spool/lpd/lk.lpd"
#define	KILLFILE	"/usr/spool/lpd/kill"
#define	JOBFILE		"/usr/spool/lpd/jobs"
#define	ACFILE		"/usr/adm/lpdacct"
#define	IFILE		"/etc/printers"
#define	UTMP		"/etc/utmp"
#define	DAEMON		"/etc/lpd"


/*
 *		Parameters
 *
 *	MAXPAUSE is the length of time that lpd will hold a job in the
 *	paused state (blocking a printer) before aborting it. The period
 *	may be extended by another pause within time
 *
 *	DBIAS is a penalty factor applied to jobs where the job class has
 *	not been fully specified (in the expectation that any of several
 *	printers could print it, so a job which can only be printed on
 *	the printer in question should be given a slight priority boost)
 *	NB: THIS IS EXPERIMENTAL, AND NOT WELL IMPLEMENTED, it may be better
 *	to set DBIAS to 0 and forget it.
 *
 *	NOFILE is the max number of files any process may have open at once,
 *	it should be copied from param.h (which is too big to include in full)
 *	(This is actually only used to ensure that all files are closed in
 *	lpd, if you are confident that a smaller number will do, it won't
 *	hurt to make this smaller than usual)
 *
 *	TABSIZE is the maximum number of printers that lpd can handle
 *	(enabled or disabled, everything in /etc/printers counts)
 *
 *	CLSIZE is the maximum length of a printer class name, plus 1
 *	It is restricted to 5 maximum by DIRSIZ
 *		(printer class name must fit in a path segment as:
 *			dfXXX.aannnnn
 *		the maximum number of X's that will fit is 4)
 *
 *	MAXCPY limits the maximum size of a copy file ('cf' file)
 *	that can be generated by 'opr' (specified in blocks)
 */

#define	MAXPAUSE	(60 * 60 * 1)	/* max pause - 3rd num is minutes */
#define	DBIAS		500		/* weighting factor against jobs that
					   might go to one of many printers */
#define	NOFILE		20		/* max open files / process (from param.h) */
#define	TABSIZE		10		/* max # printers */
#define	CLSIZE		5		/* max strlen printer class name +1 */
#define	MAXCPY		1000		/* max size for opr copy file (blks) */
