#include	"../mac/mac.h"
#include	"mactab.h"
#include	"mactab.x"

extern int cmp();
extern struct od *getod();
extern struct os *getos();

pops()
{
	register struct od *od_start, *od_new;
	register struct os *os_new;
	int format, selector, opval; /* the three opcode attributes */
	int n_od, n_os;

	od_start = NUL;
	n_od = n_os = 0;

	while(getlin()) {

		getsym();
		if(sym != LBL) {
			error("bad opcode");
			continue;
		}

		od_new = getod();

		copy(clabel, od_new->od_name);
		od_new->od_list = NUL;
		od_new->od_next = od_start;
		od_start = od_new;
		n_od++;

		for(;;) {
			getsym();
			if(sym == EOL)
				break;

			if(sym != CHR || mem != '(') {
				error("expected '('");
				break;
			}

			getsym();

			if(sym != CON) {
				error("opcode selector missing");
				break;
			}

			selector = mem;

			getsym();

			if(sym != CON) {
				error("opcode format no. missing");
				break;
			}

			format = mem;

			getsym();

			if(sym != CON) {
				error("opcode value missing");
				break;
			}

			opval = mem;

			getsym();

			if(sym != CHR || mem != ')') {
				error("expected ')'");
				break;
			}

			os_new = getos();

			os_new->os_sel = selector;
			os_new->os_fmt = format;
			os_new->os_opc = opval;
			os_new->os_next = od_start->od_list;
			od_start->od_list = os_new;

			n_os++;
		}
	}

	/* reformat the table into a single space for
	 * writing onto disk
	 */

	head.h_o_len = n_od*sizeof(struct oc) + n_os*sizeof(struct os);
	refmtop(n_od, od_start, head.h_o_len);
	qsort(opcode, n_od, sizeof(struct oc), cmp);
	head.h_ops = nops = n_od;
	head.h_opstart = opcode;
}

refmtop(n_oc, od_start, space)
struct od *od_start;
{
	register struct od *q, *r;
	register struct oc *p;
	struct oc *oc_start;

	opcode = p = (struct oc *)malloc(space);

	if(p == NUL) {
		fprintf(stderr, "No space for opcode table\n");
		exit(1);
	}

	q = od_start;
	oc_start = p;
	while(q != NUL) {
		*p++ = *((struct oc *) q );
		r = q->od_next;
		free(q);
		q = r;
	}

	refmtos(n_oc, oc_start, (struct os *)p);
}

refmtos(n_oc, oc_start, os_start)
struct oc *oc_start;
struct os *os_start;
{
	register struct oc *p;
	register struct os *q, *r;

	p = oc_start;
	q = os_start;

	while(n_oc-- > 0) {
		r = p->oc_list;
		p->oc_list = q;
		while(r != NUL) {
			*q = *r;
			r = r->os_next;
			if(r != NUL) {
				q->os_next = q+1;
				free(r);
			}
			++q;
		}

		p++;
	}
}

struct od *
getod() {
	register struct od *od;

	od = (struct od *)malloc(sizeof (struct od));

	if(od == NUL) {
		fprintf(stderr, "No space for opcode table\n");
		exit(1);
	}

	return(od);
}

struct os *
getos() {
	register struct os *os;

	os = (struct os *)malloc(sizeof (struct os));

	if(os == NUL) {
		fprintf(stderr, "No space for opcode table\n");
		exit(1);
	}

	return(os);
}
