#include	"mac.h"
#include	"m.out.h"
#include	"mac.x"


/*
 *   Evaluate the expression pointed to by 'p'.
 *
 *   Set the relocatability of the expression
 *   into global variable 'reloc'.  Lvalue()
 *   returns the relocatability of each lvalue
 *   in global variable 'mreloc'. REL has precedence
 *   over ABS.
 */

expr()
{
	register struct	st *q;
	register int l, r;		/* left & right of expr */
	register char op;		/* operator */

	reloc = NUL;
	class = -1;

	/*
	 *   Get left side of expression.
	 */
	if (*p == '=')  {		/* literal */
		reloc |= LITR;
		p++;
		}

	if (!*p)  {
		synerr("missing argument");
		return(0);
		}

	l = lvalue();
	reloc |= mreloc;


	/*
	 *   Process remainder of expression.
	 *
	 *	if end-of-expr instead of operator,
	 *	terminate legally.
	 */

	for (;;)  {

		/*
		 *   Get operator.
		 */
		op = *p;
		if (op == ',' || op == '\0') {
			if (reloc & LITR) {
				/* if expr was literal
				   store value in symbol table */
				linkl(DEF,l);
				return(0);
				}

			return(l);
			}

		p++;			/* bump past operator */
		/*
		 *   Get right hand side of expr.
		 */
		r = lvalue();
		/* determine relocatability of expression */

		if(reloc == RLBL && mreloc == RLBL) {
			synerr("Expression relative to 2 undefined globals");
			return(0);
		}

		reloc = combine(reloc, op, mreloc);

		/*
		 *	Process   <left> := <left> <op> <right>.
		 */
		switch (op)  {

			case '+':
				l += r;
				break;

			case '-':
				l -= r;
				break;

			case '*':
				l *= r;
				break;

			case '/':
				if (!r)  {
					synerr("div by zero");
					return(l);
					}
				l /= r;
				break;

			case '%':
				if (!r)  {
					synerr("mod by zero");
					return(l);
					}
				l %= r;
				break;

			case '>':
				l >>= r;
				break;

			case '<':
				l <<= r;
				break;

			case '~':
				l ^= r;
				break;

			case '&':
				l &= r;
				break;

			case '|':
				l |= r;
				break;

			}

		/*
		 *   Consider next op/field
		 */
		}

	/*
	 *   End of expr
	 */
}


/*
 *   Lvalue:  decode a term and return it's value.
 */
lvalue()
{
	register struct st *q;
	register int v;
	register int cl;


	switch (*p++)  {
		case '{':
			cl = argnum();
			if(*p++ != '$') {
				synerr("class with no label - aborting");
				abort();
			}

			q = (struct st *)argnum();

			printf("%s: Expected class: %08x label class: %08x\n",
				q, cl, q->s_class);
			if((q->s_class & cl) == 0) {
				synerr("illegal label class");
				return(0);
			}

			goto chklabel;


		case '#':
			class = 0;
			v = argnum();		/* constant */
			mreloc = RABS;
			break;


		case '$':
			q = (struct st *)argnum();		/* label */
		chklabel:
			if (!(q->s_mode & DEFN) && !(q->s_mode & GLOB))  {
				synerr("label undefined");
				return(0);
				}
			v = q->s_value;
			if (q->s_mode & REL)
				mreloc = RREL;
			else
				mreloc = RABS;

			if (q->s_mode & GLOB  &&  !(q->s_mode & DEFN)) {
				globptr = q;
				v = 0;
				mreloc |= RLBL;
			}
			if(class == -1)
				class = q->s_class;
			break;


		case '!':
			class = 0;
			v = locn[lcntr].l_value;
			mreloc = (locn[lcntr].l_currorg)->ol_reloc;
			break;


		case '+':
			class = 0;
			if(mreloc != RABS) {
				synerr("Bad expression relocatability");
				return(0);
			}
			v = lvalue();
			break;


		case '-':
			class = 0;
			if(mreloc != RABS) {
				synerr("Bad expression relocatability");
				return(0);
			}
			v = -lvalue();
			break;


		case '~':
			class = 0;
			if(mreloc != RABS) {
				synerr("Bad expression relocatability");
				return(0);
			}
			v = ~lvalue();
			break;


		case ',':
			synerr("delimiter unexpected");
			v = 0;
			mreloc = NUL;
			break;


		default:
			synerr("bad argument");
			v = 0;
			mreloc = NUL;
			break;

		}

	return(v);
}

/*
 *
 *	combine() modified from as6.c  (AS(I))
 *		Copyright (C) Richard Miller, University of W'gong
 *
 *
 * Determine relocatability of result of operation op performed on
 *	operands with relocatability rel1 and rel2
 *
 * Permitted combinations are:
 *	undefined with anything		->	undefined
 *	absolute with absolute		->	absolute
 *	relocatable + absolute		->	relocatable
 *	relocatable - absolute		->	relocatable
 *	absolute + relocatable		->	relocatable
 *	relocatable - relocatable	->	absolute (provided both are in
 *					same segment or in same common block)
 *
 * Note that external references are permitted to take part in expressions
 */
combine(rel1, op, rel2)
register rel1, rel2;
{
	register ret;

	if (rel1 == RLBL || rel2 == RLBL)
		ret = RLBL;

	else if (rel2 == RABS)
		if (rel1 == RABS)
			ret = RABS;
		else if (op == '-' || op == '+')
			ret = rel1;
		else
			synerr("Bad expression relocatability");

	else if (rel1 == RABS)
		if (op == '+')
			ret = rel2;
		else
			synerr("Bad expression relocatability");

	else if (rel1 == rel2 && op == '-')
		ret = RABS;

	else
		synerr("Bad expression relocatability");

	return(ret);
}
