# include "mfile2"

# define SMEM	SNAME|SOREG|STARNM|STIREG|STJREG
struct optab  table[] = {

ASSIGN,		FOREFF|FORCC,
		SMEM,				TPOINT|TINT|TUNSIGNED,
		SZERO,				TANY,
		0,				RESCC,
		"	tzm	AL\n",

ASSIGN,		FOREFF|FORCC,
		SMEM,				TPOINT|TINT|TUNSIGNED,
		SMONE,				TANY,
		0,				RESCC,
		"	tfm	AL\n",

ASSIGN,		INAREG|FOREFF,
		SNAME|SOREG,			TCHAR|TUCHAR,
		SACREG|SDREG,			TANY,
		0,				RRIGHT|RESCC,
		"	tbm	AL\n",

ASSIGN,		FOREFF|INAREG,
		STIREG,				TCHAR|TUCHAR,
		SACREG|SDREG,			TANY,
		0,				RRIGHT|RESCC,
		"	rbm	!0\n",

ASSIGN,		INAREG|FOREFF|FORCC,
		STJREG,				TCHAR|TUCHAR,
		SACREG|SDREG,			TANY,
		NIREG,				RRIGHT|RESCC,
		"	tji\n	rbm	!0\n",

ASSIGN,		INDREG|FOREFF|FORCC,
		SMEM,				TLONG|TULONG,
		SZERO,				TANY,
		NDREG,				RESC1|RESCC,
		"	tzd\n	tdm	AL\n",

ASSIGN,		FOREFF|FORCC,
		SNAME|SOREG,			TLONG|TULONG,
		SZERO,				TANY,
		0,				RESCC,
		"	tzm	AL\n	tzm	UL\n",

ASSIGN,		INAREG|FOREFF,
		SMEM,				TPOINT|TINT|TUNSIGNED,
		SAREG,				TPOINT|TINT|TUNSIGNED,
		0,				RRIGHT,
		"	tIRm	AL\n",

ASSIGN,		INAREG|FOREFF,
		SMEM,				TPOINT|TINT|TUNSIGNED,
		SDREG,				TLONG|TULONG,
		NACREG|NASR,			RESC1,
		"	tam	AL\n",

ASSIGN,		INDREG|FOREFF,
		SMEM,				TLONG|TULONG,
		SACREG,				TCHAR|TUCHAR|TINT|TUNSIGNED|TPOINT,
		NDREG|NASR,			RESC1,
		"IW	tdm	AL\n",

ASSIGN,		INXREG|INDREG|FOREFF,
		SMEM,				TLONG|TULONG|TFLOAT|TDOUBLE,
		SDREG|SXREG,			TLONG|TULONG|TFLOAT|TDOUBLE,
		0,				RRIGHT,
		"	tIRm	AL\n",

ASSIGN,		INAREG|FOREFF,
		SFLD,				TANY,
		SZERO,				TANY,
		NACREG,				RESC1,
		"	tma	AL\n	dma	$N\n	tam	AL\n",

ASSIGN,		INAREG|FOREFF,
		SFLD,				TANY,
		SACREG,				TANY,
		NAREG,				RRIGHT,
		"\tlla\tH\n\tdma\t$M\n\ttaI1\n\ttma\tAL\n\tdma\t$N\n\toI1a\n\ttam\tAL\n",

UNARY MUL,	INAREG|FORCC,
		SJREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TANY,
		NACREG,				RESC1|RESCC,
		"	emb	0\nIE",

	/* PANIC, must have two chars in registers */
UNARY MUL,	INAREG|FORCC,
		SJREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TANY,
		NAREG,				RESC1|RESCC,
		"	taI1\n	emb	0\nIE	iI1a\n",

UNARY MUL,	INAREG|FORCC,
		SIREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TANY,
		NACREG|NINREG,			RESC1|RESCC,
		"	tij\n	emb	0\nIE",

UNARY MUL,	INAREG,
		SIREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TANY,
		NINREG|NAREG,			RESC2,
		"	taI2\n	tij\n	emb	0\nIE	iI2a\n",

UNARY MUL,	INAREG,
		SIREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TANY,
		NACREG,				RESC1,
		"	iij\n	emb	0\nIE	iij\n",

UNARY MUL,	INAREG,
		SIREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TANY,
		NAREG,				RESC1,
		"	iij\n	taI1\n	emb	0\nIE	iij\n	iI1a\n",

REG,		FORCC,
		SANY,				TANY,
		SAREG|SDREG|SXREG,		TANY,
		0,				RESCC,
		"	czIR\n",

OPLTYPE,	FORCC,
		SANY,				TANY,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		0,				RESCC,
		"	czm	AR\n",

REG,		FORARG,
		SANY,				TANY,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		0,				RNULL,
		"I-	tIRm	*!stack\n",

REG,		FORARG,
		SANY,				TANY,
		SDREG|SXREG,			TLONG|TULONG|TFLOAT|TDOUBLE,
		0,				RNULL,
		"I4	tIRm	*!stack\n",

OPLTYPE,	FORARG,
		SANY,				TANY,
		SZERO,				TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,				RNULL,
		"I-	tzm	*!stack\n",

OPLTYPE,	FORARG,
		SANY,				TANY,
		SMONE,				TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		0,				RNULL,
		"I-	tfm	*!stack\n",

OPLTYPE,	FOREFF,
		SANY,				TANY,
		SNAME|SOREG|SCON|SAREG|SXREG|SDREG, TANY,
		0,				RRIGHT,
		"",				/* throw away noops */

OPLTYPE,	INAREG|FORCC,
		SANY,				TANY,
		SNCON,				TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NAREG,				RESC1|RESCC,
		"	tnI1	ZUCR\n",

OPLTYPE,	INAREG|FORCC,
		SANY,				TANY,
		SCON,				TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NAREG,				RESC1|RESCC,
		"	tIRI1	BR\n",

OPLTYPE,	INAREG|FORCC,
		SANY,				TANY,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		NAREG|NASR,			RESC1|RESCC,
		"	tIRI1	BR\n",

OPLTYPE,	INAREG|FORCC,
		SANY,				TANY,
		SNAME|SOREG,			TCHAR|TUCHAR,
		NACREG,				RESC1|RESCC,
		"	tmb	AR\nIY",

	/* PANIC: must have two chars in registers */
OPLTYPE,	INAREG,
		SANY,				TANY,
		SNAME|SOREG,			TCHAR|TUCHAR,
		NAREG,				RESC1,
		"	taI1\n	tmb	AR\nIY	iaI1\n",

OPLTYPE,	INDREG|FORCC,
		SANY,				TANY,
		SMEM|SCON,			TLONG|TULONG,
		NDREG,				RESC1|RESCC,
		"	tmd	AR\n",

OPLTYPE,	INXREG|FORCC,
		SANY,				TANY,
		SMEM,				TFLOAT|TDOUBLE,
		NXREG,				RESC1|RESCC,
		"	tmx	AR\n",

OPLTYPE,	INDREG,
		SANY,				TANY,
		SMEM,				TFLOAT|TDOUBLE,
		NDREG,				RESC1,
		"	tmd	AR\n",

OPLTYPE,	INTEMP,
		SANY,				TANY,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		NTEMP,				RESC1,
		"	tIRm	A1\n",

OPLTYPE,	INTEMP,
		SANY,				TANY,
		SDREG|SXREG,			TULONG|TLONG|TFLOAT|TDOUBLE,
		2*NTEMP,			RESC1,
		"	tIRm	A1\n",

INCR,		INAREG|FOREFF|FORCC,
		SMEM,				TPTRTO|TCHAR|TUCHAR,
		SONE,				TANY,
		NINREG,				RESC1|RESCC,
		"	tmI1	AL\n	bbI1	.+1\n	imI1	AL\n",

	/* Let the other addressing forms of chars be handled as a rewrite */

INCR,		FOREFF|INAREG,
		SOREG|SNAME,			TCHAR|TUCHAR,
		SONE,				TANY,
		NACREG|NAREG,			RESC1,
		"	tma	AL\n	aob	1\n	ima	AL\n",

INCR,		INAREG|FOREFF,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SONE,				TANY,
		NAREG,				RESC1|RESCC,
		"F	tmI1	AL\n	aum	AL\n",

INCR,		INAREG|FOREFF,
		SMEM,				TPOINT|TINT|TUNSIGNED,
		SCCON,				TANY,
		NAREG,				RESC1,
		"F	tmI1	AL\n	aom	CR\n	.dac	CL\n",

INCR,		INDREG,
		SOREG|SNAME,			TLONG|TULONG,
		SONE,				TANY,
		NDREG,				RESC1,
		"\ttoa\t1\n\tesa\n\tamd\tAL\n\time\tAL\n\tima\tUL\n",

INCR,		FOREFF,
		SMEM,				TLONG|TULONG,
		SONE,				TANY,
		NDREG,				RESC1,
		"	toa	1\n	esa\n	amd	AL\n	tdm	AL\n",

DECR,		INAREG|FOREFF|FORCC,
		SMEM,				TPTRTO|TCHAR|TUCHAR,
		SONE,				TANY,
		NINREG,				RESC1|FORCC,
		"\ttmI1\tAL\n\tbbI1\t.+1\n\tbbI1\t.+1\n\tsoI1\t1\n\timI1\tAL\n",

DECR,		INAREG|FOREFF,
		SOREG|SNAME,			TCHAR|TUCHAR,
		SONE,				TANY,
		NACREG|NAREG,			RESC1|RESCC,
		"	tma	AL\n	sob	1\n	ima	AL\n",

DECR,		INAREG|FOREFF,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SCCON,				TANY,
		NAREG,				RESC1,
		"F	tmI1	AL\n	aom	-CR\n	.dac	CL\n",

DECR,		INDREG,
		SNAME|SOREG,			TLONG|TULONG,
		SONE,				TANY,
		NDREG,				RESC1,
		"\ttna\t1\n\tesa\n\tamd\tAL\n\time\tAL\n\tima\tUL\n",

DECR,		FOREFF,
		SMEM,				TLONG|TULONG,
		SONE,				TANY,
		NDREG,				RESC1,
		"	tna	1\n	esa\n	amd	AL\n	tdm	AL\n",

UNARY MINUS,	INAREG|INDREG|FORCC,
		SAREG|SDREG,			TINT|TUNSIGNED|TLONG|TULONG|TPOINT,
		SANY,				TANY,
		0,				RLEFT|RESCC,
		"	nILIL\n",

UNARY MINUS,	INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SANY,				TANY,
		0,				RLEFT|RESCC,
		"	nxx\n",

COMPL,		INAREG|FORCC,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SANY,				TANY,
		0,				RLEFT|RESCC,
		"	xma	$077777777\n",

COMPL,		INAREG|FORCC,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		SANY,				TANY,
		NAREG,				RLEFT|RESCC,
		"	tnI1	1\n	xI1IL\n",

COMPL,		INDREG,
		SDREG,				TLONG|TULONG,
		SANY,				TANY,
		0,				RLEFT,
		"	ndd\n	smd	$1L\n",

ASG PLUS,	FOREFF|INAREG|FORCC,
		SMEM,				TPTRTO|TCHAR|TUCHAR,
		SICON,				TANY,
		NINREG,				RESC1|RESCC,
		"ZL",

ASG PLUS,	FOREFF|INAREG|FORCC,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SONE,				TANY,
		NAREG|NASL,			RESC1|RESCC,
		"	aum	AL\nF	tmI1	AL\n",

ASG PLUS,	FOREFF|INAREG|FORCC,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SCCON,				TANY,
		NAREG|NASL,			RESC1|RESCC,
		"	aom	CR\n	.dac	CL\nF	tmI1	AL\n",

ASG PLUS,	INAREG|FOREFF|FORCC,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		0,				RRIGHT|RESCC,
		"	aIRm	AL\nF	tmIR	AL\n",

ASG PLUS,	INDREG|FOREFF|FORCC,
		SMEM,				TLONG|TULONG,
		SDREG,				TLONG|TULONG,
		0,				RRIGHT|RESCC,
		"	amd	AL\n	tdm	AL\n",

ASG MINUS,	INAREG|FOREFF|FORCC,
		SMEM,				TPTRTO|TCHAR|TUCHAR,
		SICON,				TANY,
		NINREG,				RESC1|RESCC,
		"ZJ",

ASG MINUS,	INAREG|FOREFF|FORCC,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SCCON,				TANY,
		NAREG|NASL,			RESC1|RESCC,
		"	aom	ZMCR\n	.dac	CL\nF	tmI1	AL\n",

ASG MINUS,	INAREG|FOREFF|FORCC,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		0,				RRIGHT|RESCC,
		"	nIRIR\n	aIRm	AL\nF	tmIR	AL\n",

ASG MINUS,	INDREG|FOREFF|FORCC,
		SMEM,				TLONG|TULONG,
		SMEM,				TLONG|TULONG,
		NDREG,				RESC1|RESCC,
		"	tmd	AL\n	smd	AR\n	tdm	AL\n",

ASG MINUS,	INDREG|FOREFF|FORCC,
		SMEM,				TLONG|TULONG,
		SDREG,				TLONG|TULONG,
		0,				RESC1|RESCC,
		"	smd	AL\n	ndd\n	tdm	AL\n",

MINUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TPTRTO|TCHAR|TUCHAR,
		NDREG,				RLEFT|RESCC,
		"\ttze\n\ttILa\n\tlld\t2\n\trla\t2\n\tteIL\n\tmyo\t3\n\taILa\n\ttaIL\n\ttma\tAR\n\ttze\n\tlld\t2\n\trla\t2\n\tseIL\n\tmyo\t3\n\tsaIL\n",

MINUS,		INAREG|FORCC,
		SMEM|SCON,			TPTRTO|TCHAR|TUCHAR,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		NDREG,				RRIGHT|RESCC,
		"\ttze\n\ttIRa\n\tlld\t2\n\trla\t2\n\tteIR\n\tmyo\t3\n\taIRa\n\tnaIR\n\ttma\tAL\n\ttze\n\tlld\t2\n\trla\t2\n\taeIR\n\tmyo\t3\n\taaIR\n",

MINUS,		INAREG|FORCC,
		SMEM|SCON,			TPTRTO|TCHAR|TUCHAR,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		NDREG|NINREG|NASR,		RRIGHT|RESCC,
		"\ttze\n\tlld\t2\n\trla\t2\n\tteI2\n\tmyo\t3\n\taaI2\n\ttma\tAL\n\tlld\t2\n\trla\t2\n\tseI2\n\tmyo\t3\n\tsaI2\n\tnI2a\n",

MINUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TPTRTO|TCHAR|TUCHAR,
		NDREG|NINREG|NASL,		RESC2|RESCC,
		"\ttze\n\tlld\t2\n\trla\t2\n\tteI2\n\tmyo\t3\n\taaI2\n\ttma\tAR\n\tlld\t2\n\trla\t2\n\tseI2\n\tmyo\t3\n\tsaI2\n",

MINUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		NDREG|NASL|NTEMP,		RRIGHT|RESCC,
		"\ttIRm\tA2\n\ttze\n\tlld\t2\n\trla\t2\n\tteIR\n\tmyo\t3\n\taaIR\n\ttma\tA2\n\tlld\t2\n\trla\t2\n\tseIR\n\tmyo\t3\n\tsaIR\n",

MINUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		NIREG|NTEMP,			RESC1|RESCC,
		"\ttIRm\tA2\n\ttze\n\tlld\t2\n\trla\t2\n\tteI1\n\tmyo\t3\n\taaI1\n\ttma\tA2\n\tlld\t2\n\trla\t2\n\tseI1\n\tmyo\t3\n\tsaI1\n",

MINUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		NDREG|NASR|NTEMP,		RLEFT|RESCC,
		"\ttIRm\tA2\n\ttILa\n\ttze\n\tlld\t2\n\trla\t2\n\tteIL\n\tmyo\t3\n\taaIL\n\ttma\tA2\n\tlld\t2\n\trla\t2\n\tseIL\n\tmyo\t3\nsaIL\n",

MINUS,		INAREG|FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		NDREG|NINREG|NASL|NTEMP,	RESC2|RESCC,
		"\ttam\tA3\n\ttILa\n\ttze\n\tlld\t2\n\trla\t2\n\tteI2\n\tmyo\t3\n\taaI2\n\ttma\tA3\n\tlld\t2\n\trla\t2\n\tseI2\n\tmyo\t3\n\tsaI2\n",

	/* Handle *(p - xxx), where xxx is constant or memory */

MINUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SICON,				TANY,
		0,				RLEFT|RESCC,
		"ZP",

MINUS,		INAREG|FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SICON,				TANY,
		NINREG,				RESC1|RESCC,
		"	tILI1\nZQ",

MINUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TINT|TUNSIGNED,
		NDREG|NASL|NTEMP,		RLEFT|RESCC,
		"\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\ttem\tA2\n\tmyo\t3\n\tama\tA2\n\tsIRa\tBR\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TINT|TUNSIGNED,
		NDREG,				RLEFT|RESCC,
		"\ttILa\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tteIL\n\tmyo\t3\n\taILa\n\tsIRa\tBR\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n\ttaIL\n",

MINUS,		INAREG|FORCC,
		SMEM|SCON,			TPTRTO|TCHAR|TUCHAR,
		SACREG,				TINT|TUNSIGNED,
		NDREG|NINREG|NASR,		RRIGHT|RESCC,
		"\tnaI2\n\ttma\tAL\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeI2\n\tmyo\t3\n\taI2a\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TINT|TUNSIGNED,
		NDREG|NINREG|NASL,		RLEFT|RESCC,
		"\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tteI2\n\tmyo\t3\n\taI2a\n\tsIRa\tAR\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TINT|TUNSIGNED,
		NDREG,				RLEFT|RESCC,
		"\ttze\n\ttILa\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tteIL\n\tmyo\t3\n\taILa\n\tsIRa\tAR\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TINT|TUNSIGNED,
		NACREG|NINREG,			RESC1|RESCC,
		"\ttea\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tteI2\n\tmyo\t3\n\taI2a\n\tsIRa\tBR\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SMEM|SCON,			TPTRTO|TCHAR|TUCHAR,
		SINREG,				TINT|TUNSIGNED,
		NACREG|NAREG,			RESC1|RESCC,
		"\ttma\tAL\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tseIR\n\tmyo\t3\n\tsaIR\n\tnIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SMEM|SCON,			TPTRTO|TCHAR|TUCHAR,
		SAREG,				TINT|TUNSIGNED,
		NACREG|NINREG,			RESC1|RESCC,
		"\ttIRI2\n\ttma\tAL\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tseI2\n\tmyo\t3\n\tsaI2\n\tnI2a\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SINREG,				TINT|TUNSIGNED,
		NDREG|NASL,			RLEFT|RESCC,
		"\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tseIR\n\tmyo\t3\n\tsaIR\n\tnIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SAREG,				TINT|TUNSIGNED,
		NINREG,				RLEFT|RESCC,
		"\tnIRI1\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeI1\n\tmyo\t3\n\taI1a\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SACREG,				TINT|TUNSIGNED,
		NDREG|NASR,			RRIGHT|RESCC,
		"\tiaIL\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tseIL\n\tmyo\t3\n\tsaIL\n\tnILa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SACREG,				TINT|TUNSIGNED,
		NINREG,				RRIGHT|RESCC,
		"\tnaI1\n\ttILa\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeI1\n\tmyo\t3\n\taI1a\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

MINUS,		INAREG|FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SINREG,				TINT|TUNSIGNED,
		NINREG,				RESC1|RESCC,
		"\ttaI1\n\ttILa\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tseIR\n\tmyo\t3\n\tsaIR\n\tnIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n\tiI1a\n",

MINUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SAREG,				TINT|TUNSIGNED,
		NINREG,				RESC1|RESCC,
		"\ttaI1\n\ttILa\n\tnIRIL\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeIL\n\tmyo\t3\n\taILa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n\tiI1a\n",

MINUS,		INAREG|FORCC,
		SKREG,				TANY,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		NAREG,				RESC1|RESCC,
		"	tkI1\n	sIRI1	BR\n",

MINUS,		INAREG|FORCC,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		0,				RLEFT|RESCC,
		"	sIRIL	BR\n",

MINUS,		INAREG|FORCC,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		0,				RRIGHT|RESCC,
		"	nIRIR\n	amIR	AL\n",

MINUS,		INAREG|FORCC,
		SOREG|SNAME,			TCHAR,
		SOREG|SNAME,			TCHAR,
		NACREG,				RESC1|RESCC,
		"	tmb	AL\n	smb	AR\n	esb\n",

MINUS,		INAREG|FORCC,
		SOREG|SNAME,			TCHAR,
		STJREG,				TCHAR,
		NACREG,				RESC1|RESCC,
		"	emb	0\n	nbb\n	amb	AL\n	esb\n",

MINUS,		INAREG|FORCC,
		STJREG,				TCHAR,
		SOREG|SNAME,			TCHAR,
		NACREG,				RESC1|RESCC,
		"	emb	0\n	smb	AR\n	esb\n",

MINUS,		INDREG|FORCC,
		SDREG,				TLONG|TULONG,
		SMEM|SCON,			TLONG|TULONG,
		0,				RLEFT|RESCC,
		"	smd	AR\n",

MINUS,		INDREG|FORCC,
		SMEM|SCON,			TLONG|TULONG,
		SDREG,				TLONG|TULONG,
		0,				RRIGHT|RESCC,
		"	ndd\n	amd	AL\n",

MINUS,		INAREG|FORCC,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		0,				RLEFT|RESCC,
		"	sIRIL\n",

MINUS,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SACREG|SDREG,			TINT|TFLOAT|TDOUBLE,
		0,				RLEFT|RESCC,
		"	sIRx\n",

MINUS,		INXREG|FORCC,
		SDREG,				TFLOAT|TDOUBLE,
		SXREG,				TFLOAT|TDOUBLE,
		0,				RRIGHT|RESCC,
		"	idx\n	sdx\n",

MINUS,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SMEM,				TFLOAT|TDOUBLE,
		0,				RLEFT|RESCC,
		"	smx	AR\n",

MINUS,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SCCON,				TANY,
		0,				RLEFT|RESCC,
		"	sox	CR\n",

DIV,		INAREG|FOREFF|FORCC,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		NAREG,				RLEFT|RESCC,
		"IV	dvIR	BR\n",

DIV,		INAREG|FORCC,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SOREG|SNAME,			TCHAR|TUCHAR,
		NAREG|NAREG|NASR,		RLEFT|RESCC,
		"\ttaI2\n\ttmb\tAR\nIY\tiaI2\nIV\tdvI2\n",

DIV,		INAREG|FORCC,
		SOREG|SNAME,			TCHAR|TUCHAR,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		NAREG|NAREG|NASL,		RRIGHT|RESCC,
		"	taI2\n	tmb	AL\nIHIV	dvI3\n",

DIV,		INAREG|FORCC,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SINREG,				TINT|TUNSIGNED|TPOINT,
		0,				RLEFT|RESCC,
		"IV	OIIR\n",

DIV,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SACREG|SDREG,			TINT|TFLOAT|TDOUBLE,
		0,				RLEFT|RESCC,
		"	dIRx\n",

DIV,		INXREG|FORCC,
		SDREG,				TFLOAT|TDOUBLE,
		SXREG,				TFLOAT|TDOUBLE,
		0,				RRIGHT|RESCC,
		"	idx\n	ddx\n",

DIV,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SMEM,				TFLOAT|TDOUBLE,
		0,				RLEFT|RESCC,
		"	dmx	AR\n",

DIV,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SCCON,				TANY,
		0,				RLEFT|RESCC,
		"	dox	CR\n",

DIV,		INXREG|FORCC,
		SONE,				TANY,
		SMEM,				TFLOAT|TDOUBLE,
		NXREG,				RESC1|RESCC,
		"	tmx	AR\n	inx\n",

MOD,		INAREG,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		NDREG|NASL,			RLEFT,
		"IV	dvIR	BR\nZX",

MOD,		INAREG,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SINREG,				TINT|TUNSIGNED|TPOINT,
		NDREG|NASL,			RLEFT,
		"IV	dvIR\nZX",

MOD,		INAREG,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		NINREG,				RRIGHT,
		"	teI1\nIV	dvI1\n",

MOD,		INAREG,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SOREG|SNAME,			TCHAR|TUCHAR,
		NDREG|NINREG|NASL,		RLEFT,
		"\ttaI2\n\ttmb\tAR\nIY\tiaI2\nIV\tdvI2\nZX",

MOD,		INAREG,
		SOREG|SNAME,			TCHAR|TUCHAR,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		NDREG|NINREG|NASR,		RRIGHT,
		"\ttaI2\n\ttmb\tAL\nIHIV\tdvI2\nZY",

MUL,		INAREG|FORCC,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		NAREG,				RLEFT|RESCC,
		"	myIR	BR\n	bnn	.+2\n	nsa\n",

MUL,		INAREG|FORCC,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		NAREG,				RLEFT|RESCC,
		"	myIL	BL\n	bnn	.+2\n	nsa\n",

MUL,		INAREG|FORCC,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SOREG|SNAME,			TCHAR|TUCHAR,
		NAREG,				RLEFT|RESCC,
		"	taI1\n	tmb	AR\nIY	myI1\n	bnn	.+2\n	nsa\n",

MUL,		INAREG|FORCC,
		SOREG|SNAME,			TCHAR|TUCHAR,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		NAREG,				RRIGHT|RESCC,
		"	taI1\n	tmb	AL\nIH	myI1\n	bnn	.+2\n	nsa\n",

MUL,		INAREG|FORCC,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		0,				RLEFT|RESCC,
		"	myIR\n	bnn	.+2\n	nsa\n",

MUL,		INAREG|FORCC,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		0,				RRIGHT|RESCC,
		"	myIL\n	bnn	.+2\n	nsa\n",

MUL,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SACREG|SDREG,			TINT|TFLOAT|TDOUBLE,
		0,				RLEFT|RESCC,
		"	mIRx\n",

MUL,		INXREG|FORCC,
		SDREG,				TFLOAT|TDOUBLE,
		SXREG,				TFLOAT|TDOUBLE,
		0,				RRIGHT|RESCC,
		"	mdx\n",

MUL,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SMEM,				TFLOAT|TDOUBLE,
		0,				RLEFT|RESCC,
		"	mmx	AR\n",

MUL,		INXREG|FORCC,
		SMEM,				TFLOAT|TDOUBLE,
		SXREG,				TFLOAT|TDOUBLE,
		0,				RRIGHT|RESCC,
		"	mmx	AL\n",

MUL,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SCCON,				TANY,
		0,				RLEFT|RESCC,
		"	mox	CR\n",

PLUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SICON,				TANY,
		0,				RLEFT|RESCC,
		"ZO",

PLUS,		INAREG|FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SICON,				TANY,
		NINREG,				RESC1|RESCC,
		"	tILI1\nZG",

PLUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TINT|TUNSIGNED,
		NDREG|NINREG|NASL,		RLEFT|RESCC,
		"\ttIRI2\tBR\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeI2\n\tmyo\t3\n\taI2a\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PLUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TINT|TUNSIGNED,
		NACREG|NAREG,			RESC1|RESCC,
		"\ttILa\n\ttIRIL\tBR\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeIL\n\tmyo\t3\n\taILa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PLUS,		INAREG|FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SMEM|SCON,			TINT|TUNSIGNED,
		NACREG|NINREG,			RESC1|RESCC,
		"\ttea\n\ttIRI2\tBR\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeI2\n\tmyo\t3\n\taI2a\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PLUS,		INAREG|FORCC,
		SMEM|SCON,			TPTRTO|TCHAR|TUCHAR,
		SINREG,				TINT|TUNSIGNED,
		NACREG|NAREG,			RESC1|RESCC,
		"\ttILa\tBL\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeIR\n\tmyo\t3\n\taIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PLUS,		INAREG|FORCC,
		SMEM|SCON,			TPTRTO|TCHAR|TUCHAR,
		SAREG,				TINT|TUNSIGNED,
		NACREG|NINREG|NAREG|NASR,	RESC1|RESCC,
		"\ttIRI2\n\ttILa\tBL\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeI2\n\tmyo\t3\n\taI2a\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PLUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SINREG,				TINT|TUNSIGNED,
		NDREG|NASL,			RLEFT|RESCC,
		"\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeIR\n\tmyo\t3\n\taIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PLUS,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SAREG,				TINT|TUNSIGNED,
		NINREG,				RLEFT|RESCC,
		"\ttIRI1\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeI1\n\tmyo\t3\n\taI1a\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PLUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SACREG,				TINT|TUNSIGNED,
		NDREG|NASR,			RRIGHT|RESCC,
		"\tiaIL\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeIL\n\tmyo\t3\n\taILa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PLUS,		INAREG|FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SINREG,				TINT|TUNSIGNED,
		NINREG,				RESC1|RESCC,
		"\ttaI1\n\ttILa\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeIR\n\tmyo\t3\n\taIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n\tiaI1\n"
,

PLUS,		INAREG|FORCC,
		SINREG,				TPTRTO|TCHAR|TUCHAR,
		SAREG,				TINT|TUNSIGNED,
		NINREG,				RESC1|RESCC,
		"\ttaI1\n\ttILa\n\ttIRIL\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\taeIL\n\tmyo\t3\n\taILa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n\tiaI1\n",

	/* Because we have PACONV and PSCONV nodes this is always straight + */

PLUS,		INAREG|FORCC,
		SKREG,				TANY,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		NAREG|NASR,			RESC1|FORCC,
		"	tIRI1	BR\n	akI1\n",

PLUS,		INAREG|FORCC,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		0,				RLEFT|RESCC,
		"	aIRIL	BR\n",

PLUS,		INAREG|FORCC,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		0,				RRIGHT|RESCC,
		"	aILIR	BL\n",

PLUS,		INAREG|FORCC,
		SOREG|SNAME,			TCHAR,
		SOREG|SNAME,			TCHAR,
		NACREG,				RESC1|RESCC,
		"	tmb	AL\n	amb	AR\n	esb\n",

PLUS,		INAREG|FORCC,
		SOREG|SNAME,			TCHAR,
		STJREG,				TCHAR,
		NACREG,				RESC1|RESCC,
		"	emb	0\n	amb	AL\n	esb\n",

PLUS,		INAREG|FORCC,
		STJREG,				TCHAR,
		SOREG|SNAME,			TCHAR,
		NACREG,				RESC1|RESCC,
		"	emb	0\n	amb	AR\n	esb\n",

PLUS,		INDREG|FORCC,
		SDREG,				TLONG|TULONG,
		SMEM|SCON,			TLONG|TULONG,
		0,				RLEFT|RESCC,
		"	amd	AR\n",

PLUS,		INDREG|FORCC,
		SMEM|SCON,			TLONG|TULONG,
		SDREG,				TLONG|TULONG,
		0,				RRIGHT|RESCC,
		"	amd	AL\n",

PLUS,		INXREG|FORCC,
		SACREG|SDREG,			TINT|TFLOAT|TDOUBLE,
		SXREG,				TFLOAT|TDOUBLE,
		0,				RRIGHT|RESCC,
		"	aILx\n",

PLUS,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SACREG|SDREG,			TINT|TFLOAT|TDOUBLE,
		0,				RLEFT|RESCC,
		"	aIRx\n",

PLUS,		INXREG|FORCC,
		SMEM,				TFLOAT|TDOUBLE,
		SXREG,				TFLOAT|TDOUBLE,
		0,				RRIGHT|RESCC,
		"	amx	AL\n",

PLUS,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SMEM,				TFLOAT|TDOUBLE,
		0,				RLEFT|RESCC,
		"	amx	AR\n",

PLUS,		INXREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SCCON,				TANY,
		0,				RLEFT|RESCC,
		"	aox	CR\n",


AND,		INDREG,
		SDREG,				TLONG|TULONG,
		SNAME|SOREG|SCON,		TLONG|TULONG,
		0,				RLEFT,
		"	dma	UR\n	iea\n	dma	ZZ\n	iea\n",

OR,		INDREG,
		SDREG,				TLONG|TULONG,
		SNAME|SOREG|SCON,		TLONG|TULONG,
		0,				RLEFT,
		"	oma	UR\n	iea\n	oma	ZZ\n	iea\n",

ER,		INDREG,
		SDREG,				TLONG|TULONG,
		SNAME|SOREG|SCON,		TLONG|TULONG,
		0,				RLEFT,
		"	xma	UR\n	iea\n	xma	ZZ\n	iea\n",

OPSHFT,		INAREG|FOREFF|FORCC,
		SACREG,				TINT|TPOINT|TUNSIGNED,
		SCON,				TANY,
		0,				RLEFT|RESCC,
		"	OIIXa	CR\n",

OPSHFT,		INDREG|FOREFF|FORCC,
		SDREG,				TLONG|TULONG,
		SCON,				TANY,
		0,				RLEFT|RESCC,
		"	OIIXd	CR\n",

OPSHFT,		INDREG|INAREG|FOREFF|FORCC,
		SACREG|SDREG,			TINT|TUNSIGNED|TPOINT|TLONG|TULONG,
		SINREG,				TANY,
		0,				RLEFT|RESCC,
		"	exm	!I%OIshift,AR\n",


	/* Should be only |, ^, and & that match these templates */

OPCOMM,		INAREG|FORCC,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		0,				RLEFT|RESCC,
		"	OIIRIL	BR\n",

OPCOMM,		INAREG|FOREFF|FORCC,
		SMEM|SCON,			TINT|TUNSIGNED|TPOINT,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		0,				RRIGHT|RESCC,
		"	OIILIR	BL\n",

OPCOMM,		INAREG|FORCC,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		SAREG,				TINT|TUNSIGNED|TPOINT,
		0,				RLEFT|RESCC,
		"	OIIRIL\n",

OPCOMM,		INDREG,
		SOREG|SNAME,			TLONG|TULONG,
		SDREG,				TLONG|TULONG,
		0,				RRIGHT,
		"	OIma	UL\n	iea\n	OIma	AL\n	iea\n",

SCONV,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TINT|TUNSIGNED,
		NDREG|NINREG|NASL,		RLEFT|RESCC,
		"\tcza\n\tboz\t0f\n\ttze\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tteI2\n\tmyo\t3\n\taI2a\n0:\n",

SCONV,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TLONG|TULONG,
		NDREG|NINREG|NASL,		RESC1|RESCC,
		"\ttze\n\tcza\n\tboz\t0f\n\tlld\t2\n\trla\t2\n\tsoe\t1\n\tteI2\n\tmyo\t3\n\taI2a\n\tlld\t1\n\trla\t1\n0:\n",

SCONV,		INAREG,
		SDREG|SACREG,			TLONG|TULONG,
		SANY,				TINT|TUNSIGNED|TPOINT,
		0,				RLEFT,
		"	lla	1\n	rld	1\nZT",

SCONV,		INAREG|FORCC,
		SDREG,				TLONG|TULONG|TINT|TUNSIGNED|TPOINT,
		SANY,				TCHAR|TUCHAR,
		0,				RLEFT|RESCC,
		"IYZT",

SCONV,		INDREG|FORCC,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		SANY,				TLONG|TULONG,
		NDREG|NASL,			RESC1|RESCC,
		"IV",

SCONV,		INXREG|FORCC,
		SACREG,				TINT,
		SANY,				TFLOAT|TDOUBLE,
		NXREG,				RESC1|RESCC,
		"	fax\n",

SCONV,		INDREG|FORCC,
		SDREG,				TLONG|TULONG,
		SANY,				TFLOAT|TDOUBLE,
		NIREG,				RLEFT|RESCC,
		"\ttoc\t0\n\tfno\n\ttib\n\tboz\t.+2\n\taob\t46\n",

SCONV,		INDREG|FORCC,
		SACREG,				TUNSIGNED,
		SANY,				TFLOAT|TDOUBLE,
		NDREG|NASL,			RESC1|RESCC,
		"IV\ttoc\t0\n\tfno\n\ttib\n\tboz\t.+2\n\taob\t46\n",

SCONV,		INXREG|FORCC,
		SDREG,				TLONG|TULONG,
		SANY,				TFLOAT|TDOUBLE,
		NXREG|NIREG,			RESC1|RESCC,
		"\ttoc\t0\n\tfno\n\ttib\n\tboz\t.+2\n\taob\t46\n\ttdx\n",

SCONV,		INAREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SANY,				TINT|TUNSIGNED|TPOINT|TCHAR|TUCHAR,
		NACREG,				RESC1|RESCC,
		"	fxa\n",

SCONV,		INDREG|FORCC,
		SXREG,				TFLOAT|TDOUBLE,
		SANY,				TLONG|TULONG,
		NDREG,				RESC1|RESCC,
		"	fxa\nIV",

	/* Special calculations for character pointers */

PACONV,		INAREG,
		SINREG,				TPOINT|TINT|TUNSIGNED,
		SCON,				TANY,
		0,				RLEFT,
		"ZK",

PACONV,		INAREG,
		SACREG,				TPOINT|TINT|TUNSIGNED,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		NDREG|NASL,			RLEFT,
		"\tmyo\t3\n\tama\tAR\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PACONV,		INAREG,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SACREG,				TINT|TUNSIGNED|TPOINT,
		NDREG|NINREG|NASR,		RRIGHT,
		"\ttaI2\n\ttma\tAL\n\tmyo\t3\n\taI2a\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PACONV,		INAREG,
		SKREG|SAREG,			TPOINT|TINT|TUNSIGNED,
		SMEM,				TINT|TUNSIGNED,
		NDREG,				RESC1,
		"\ttILa\n\tmyo\t3\n\tama\tAR\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\nZ]",

PACONV,		INAREG,
		SKREG|SAREG,			TPOINT|TINT|TUNSIGNED,
		SCON,				TANY,
		NINREG,				RESC1,
		"	tILI1\nZE",

PACONV,		INAREG,
		SACREG,				TPOINT|TINT|TUNSIGNED,
		SINREG,				TINT|TUNSIGNED,
		NDREG|NASL,			RLEFT,
		"\tmyo\t3\n\taIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PACONV,		INAREG,
		SKREG,				TPOINT|TINT|TUNSIGNED,
		SINREG,				TINT|TUNSIGNED,
		NDREG,				RESC1,
		"\ttka\n\tmyo\t3\n\taIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\nZ]",

	/* Special calculations for character pointers */

PSCONV,		INAREG,
		SINREG,				TPOINT|TINT|TUNSIGNED,
		SCON,				TANY,
		0,				RLEFT,
		"ZD",

PSCONV,		INAREG,
		SKREG|SAREG,			TPOINT|TINT|TUNSIGNED,
		SCON,				TANY,
		NINREG,				RESC1,
		"	tILI1\nZH",

PSCONV,		INAREG,
		SACREG,				TPOINT|TINT|TUNSIGNED,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		NDREG|NASR,			RLEFT,
		"\tmyo\t3\n\tsma\tAR\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PSCONV,		INAREG,
		SKREG|SINREG,			TPOINT|TINT|TUNSIGNED,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		NDREG,				RESC1,
		"\ttILa\n\tmyo\t3\n\tsma\tAR\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\nZ]",

PSCONV,		INAREG,
		SACREG,				TPOINT|TINT|TUNSIGNED,
		SINREG,				TINT|TUNSIGNED|TPOINT,
		NDREG|NASL,			RLEFT,
		"\tmyo\t3\n\tsIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\n",

PSCONV,		INAREG,
		SKREG|SINREG,			TPOINT|TINT|TUNSIGNED,
		SINREG,				TINT|TUNSIGNED|TPOINT,
		NDREG,				RESC1,
		"\ttILa\n\tmyo\t3\n\tsIRa\n\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\nZ]",

PCONV,		INAREG|FORCC,
		SACREG|SDREG,			TINT|TUNSIGNED|TLONG|TULONG,
		SANY,				TPTRTO|TCHAR|TUCHAR,
		NDREG|NASL,			RLEFT|RESCC,
		"IV\tdvo\t3\n\taoe\t1\n\tlla\t2\n\trld\t2\nZT",

PCONV,		INAREG|FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TPOINT,
		0,				RLEFT|RESCC,
		"	dma	$017777777\n",

PCONV,		INAREG|FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SANY,				TPOINT,
		NAREG,				RLEFT|RESCC,
		"	tmI1	$017777777\n	dI1IL\n",

PCONV,		INAREG|FORCC,
		SACREG,				TPOINT,
		SANY,				TPTRTO|TCHAR|TUCHAR,
		0,				RLEFT|RESCC,
		"	oma	$020000000\n",

PCONV,		INAREG|FORCC,
		SINREG,				TPOINT,
		SANY,				TPTRTO|TCHAR|TUCHAR,
		0,				RLEFT|RESCC,
		"	bbIL	.+1\n",

PCONV,		INAREG|FORCC,
		SAREG,				TPOINT,
		SANY,				TPTRTO|TCHAR|TUCHAR,
		NAREG,				RLEFT|RESCC,
		"	tmI1	$020000000\n	oI1IL\n",

PCONV,		FOREFF,
		SANY,				TINT|TUNSIGNED,
		SANY,				TPTRTO|TINT|TUNSIGNED|TLONG|TULONG|TFLOAT|TDOUBLE|TSTRUCT,
		0,				RLEFT,
		"",				/* NOOP */

PCONV,		INAREG,
		SDREG,				TLONG|TULONG,
		SANY,				TPOINT,
		0,				RLEFT,
		"	lla	1\n	rld	1\nZT",

STASG,		FOREFF|INAREG,
		SCON,				TANY,
		SCON,				TANY,
		NINREG,				RESC1,
		"ZWF	tmI1	AR\n",

STASG,		FOREFF|INAREG,
		SCON,				TANY,
		SINREG,				TANY,
		NINREG,				RRIGHT,
		"ZWFZ@",

STASG,		FOREFF|INAREG,
		SINREG,				TANY,
		SCON,				TANY,
		NINREG,				RLEFT,
		"ZWFZ?",

STASG,		FOREFF|INAREG,
		SINREG,				TANY,
		SINREG,				TANY,
		0,				RRIGHT,
		"ZWFZ@",

STARG,		FORARG,
		SCON|SINREG,			TANY,
		SANY,				TANY,
		NINREG,				RNULL,
		"ZV",

OPLOG,		FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		0,				RESCC,
		"\tlra\t2\n\tiaIR\n\tlra\t2\n\tkaIR\nZI",

OPLOG,		FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		0,				RESCC,
		"\tlra\t2\n\tiaIL\n\tlra\t2\n\tkILa\nZI",

OPLOG,		FORCC,
		SACREG,				TPTRTO|TCHAR|TUCHAR,
		SKREG,				TPOINT,
		NAREG,				RESCC,
		"\tlra\t2\n\ttaI1\n\ttka\n\tlra\t2\n\taoa\t1\n\tkaI1\nZI",

OPLOG,		FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SKREG,				RESCC,
		NACREG,				RESCC,
		"\ttka\n\tlra\n\taoa\t1\n\tiaIL\n\tlra\t2\n\tkILa\nZI",

OPLOG,		FORCC,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		SAREG,				TPTRTO|TCHAR|TUCHAR,
		NACREG,				RESCC,
		"\ttIRa\n\tlra\t2\n\tiILa\n\tlra\t2\n\tkILa\nZI",

OPLOG,		FORCC,
		SAREG|SKREG,			TPOINT|TUNSIGNED,
		SAREG|SKREG,			TPOINT|TUNSIGNED,
		0,				RESCC,
		"	kIRIL\nZI",

OPLOG,		FORCC,
		SAREG|SKREG,			TPOINT|TUNSIGNED,
		SAREG,				TINT,
		0,				RESCC,
		"	kIRIL\nZI",

OPLOG,		FORCC,
		SAREG,				TINT,
		SAREG|SKREG,			TPOINT|TUNSIGNED,
		0,				RESCC,
		"	kIRIL\nZI",

OPLOG,		FORCC,
		SAREG,				TINT,
		SAREG,				TINT,
		0,				RESCC,
		"	cIRIL\nZI",

OPLOG,		FORCC,
		SDREG,				TFLOAT|TDOUBLE,
		SXREG,				TFLOAT|TDOUBLE,
		0,				RESCC,
		"	cdx\nZF",

OPLOG,		FORCC,
		SAREG,				TINT,
		SMEM|SCON,			TINT,
		0,				RESCC,
		"	cmIL	AR\nZI",

OPLOG,		FORCC,
		SMEM|SCON,			TINT,
		SAREG,				TINT,
		0,				RESCC,
		"	cmIR	AL\nZR",

OPLOG,		FORCC,
		SMEM,				TINT|TUNSIGNED|TPOINT,
		SZERO,				TINT,
		0,				RESCC,
		"	czm	AR\nZI",

OPLOG,		FORCC,
		SAREG|SDREG|SKREG,		TINT|TUNSIGNED|TPOINT|TULONG|TLONG,
		SZERO,				TANY,
		0,				RESCC,
		"	czIR\nZI",

OPLOG,		FORCC,
		SDREG,				TLONG|TULONG,
		SMEM|SCON,			TLONG|TULONG,
		0,				RESCC,
		"	smd	AR\nZI",

OPLOG,		FORCC,
		SMEM|SCON,			TLONG|TULONG,
		SDREG,				TLONG|TULONG,
		0,				RESCC,
		"	smd	AL\nZS",

CCODES,		INAREG,
		SANY,				TANY,
		SANY,				TINT|TUNSIGNED|TPOINT,
		NAREG,				RESC1,
		"	toI1	1\nZN",

CCODES,		INAREG,
		SANY,				TANY,
		SANY,				TLONG|TULONG,
		NDREG,				RESC1,
		"	tzd\n	toa	1\nZN",

UNARY CALL,	INAREG,
		SANY,				TANY,
		SANY,				TCHAR|TUCHAR|TINT|TUNSIGNED|TPOINT,
		NACREG,				RESC1,
		"	bll	ZB\n",

UNARY CALL,	INDREG,
		SANY,				TANY,
		SANY,				TLONG|TULONG,
		NDREG,				RESC1,
		"	bll	ZB\n",

UNARY CALL,	INXREG,
		SANY,				TANY,
		SANY,				TDOUBLE|TFLOAT,
		NXREG,				RESC1,
		"	bll	ZB\n",

INIT,		FOREFF,
		SCON,				TANY,
		SANY,				TPTRTO|TCHAR|TUCHAR,
		0,				RNOP,
		"ZA",

INIT,		FOREFF,
		SCON,				TANY,
		SANY,				TANY,
		0,				RNOP,
		"	.word	CL\n",

	/* Default actions for hard trees ... */

UNARY MUL,	FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	UNARY MUL,
		"",

INCR, 		FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	INCR,
		"",

DECR, 		FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	INCR,
		"",

ASSIGN, 	FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	ASSIGN,
		"",

STASG, 		FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	STASG,
		"",

OPLEAF, 	FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	NAME,
		"",

OPLOG,		FORCC,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	BITYPE,
		"",

OPLOG,		FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	NOT,
		"",

COMOP, 		FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	COMOP,
		"",

INIT, 		FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	INIT,
		"",

OPUNARY, 	FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	UNARY MINUS,
		"",

ASG OPANY,	FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	ASG PLUS,
		"",

OPANY, 		FORREW,
		SANY,		TANY,
		SANY,		TANY,
		REWRITE,	BITYPE,
		"",

FREE,		FREE,
		FREE,		FREE,
		FREE,		FREE,
		FREE,		FREE,
		"help; I'm in trouble\n"
};
