.hd ddlc "interface to Prime DBMS schema compiler" 08/11/81
ddlc <input file>
         [-l [<listing file>]]
         [-z <SCHEMA option>]
.ds
'Ddlc' serves as the Subsystem interface to the Prime DBMS
schema compiler (SCHEMA).
It examines its option specifications and checks them for consistency,
provides Subsystem-compatible default file names for the listing
and output files as needed, and then produces a
Primos SCHEMA command and causes it to be executed.
.sp
The "-l" option is used to select the name of the file to receive the
listing generated by the compiler.
If a file name follows the option, then that file receives the listing.
If the "-l" option is specified without a file name following it
or is not specified,
a default filename is constructed from the input filename by changing
its suffix to ".l".
For example, if the input filename is "gonzo.ddl", the listing file will
be "gonzo.l";
if the input filename is "bar", the listing file will be "bar.l".
.sp
The input filename must be a disk file name (conventionally
ending in ".ddl").
.sp
In summary, then, the default command line for compiling a file named
"file.ddl" is
.sp
.nf
     ddlc  file.ddl  -l file.l
.sp
which corresponds to the SCHEMA command
.sp
     schema -i *>file.ddl -l *>file.l
.sp
.fi
.es
ddlc file.ddl
ddlc payroll.ddl -l l_payroll
ddlc funnyschema.ddl -z"-newopt"
.me
.in +5
.ti -5
"Usage: ddlc ..." for invalid option syntax.
.ti -5
"missing input file name" if no input filename could be found.
.ti -5
"<name>: unreasonable input file name" if an attempt was made to read
from the null device or the line printer spooler.
.ti -5
"Sorry, the listing file must be a disk file" if the listing
file was directed to a device file.
.in -5
.bu
'Ddlc' pays no attention to standard ports.

There is no way to avoid getting a listing file.
.sa
cdmlc (1), csubc (1), fdmlc (1), fsubc (1)
