#-h- cdiff           1093 local 08/09/81 12:00:00
   sym_pointer _
      Old_count (MAX_FILE_SIZE),
      New_count (MAX_FILE_SIZE),
      Old_xref (MAX_FILE_SIZE),
      New_xref (MAX_FILE_SIZE),
      Old_lno (MAX_UNIQUE_LINES),
      Bucket (HASH_TABLE_SIZE),
      Sym_store (MAX_UNIQUE_LINES2)
   file_mark _
      Text_loc (2, MAX_UNIQUE_LINES)
   common /c1/ Old_count      # separate common because of size limitations
   common /c2/ New_count      # on some machines...
   common /c3/ Old_xref
   common /c4/ New_xref
   common /c5/ Old_lno
   common /c6/ Bucket
   common /c7/ Sym_store
   common /c8/ Text_loc
   sym_pointer _
      Next_sym,
      Next_inx,
      New_size,
      Old_size
   filedes _
      Old_file,
      New_file,
      Text_file,
      Old_copy,
      New_copy
   integer _
      Option,
      Verbos
   character _
      Text_file_name (FILENAMESIZE),
      Old_copy_name (FILENAMESIZE),
      New_copy_name (FILENAMESIZE)
   common /difcom/ Next_sym, Next_inx, Old_file, New_file, Text_file,
      New_size, Old_size, Old_copy, New_copy, Option, Verbos,
      Text_file_name, Old_copy_name, New_copy_name
#-t- cdiff           1093 local 08/09/81 12:00:00
#-h- tdiff.r         22089 local 08/09/81 12:00:00
#-h- defns           1676 local 08/09/81 12:00:00
# diff --- isolate differences between two files
define (MAX_UNIQUE_LINES,1000)   # no. of unique lines in all files
define (MAX_UNIQUE_LINES2,arith(MAX_UNIQUE_LINES,*,2))
define (NULL_POINTER,0)
#define (HASH_TABLE_SIZE,6073)    # must be prime, as large as possible
 define(HASH_TABLE_SIZE,101)
define (MAX_FILE_SIZE,1000)      # no. of lines in largest input file
define (sym_pointer,integer)     # large enough to index MAX_UNIQUE_LINES2
define (hash_index,integer)      # large enough to index HASH_TABLE_SIZE
define (file_mark,integer)       # large enough to hold a file position
define (DIFFERENCES,1)           # -d => list differences
define (REVISION,2)              # -r => revision bar requests for 'fmt'
define (SCRIPT,3)                # -s => update script for 'ed'
define (COMPARISON,4)            # -c => simple line-by-line compare
define (ON,)
define (OFF,#)
define (DEBUG,OFF)               # turn debugging output on/off
define (TUNING,OFF)              # turn algorithm tuning output on/off
 # definitions for long variable names
define(Old_count,ocount)
define(New_count,ncount)
define(Old_xref,oxref)
define(New_xref,nxref)
define(Old_lno,oldlno)
define(Sym_store,sstore)
define(Text_loc,tloc)
define(Next_sym,nsym)
define(Next_inx,ninx)
define(New_size,nsize)
define(Old_size,osize)
define(Old_file,ofile)
define(New_file,nfile)
define(Text_file,tfile)
define(Old_copy,ocopy)
define(New_copy,ncopy)
define(Text_file_name,tfname)
define(Old_copy_name,ocname)
define(New_copy_name,ncname)
define(cleanup,clean)
define(gen_listing,glist)
define(gen_revision,grevis)
define(gen_script,gscrip)
define(initialize,init)
define(simple_compare,scompr)
#-t- defns           1676 local 08/09/81 12:00:00
#-h- diff             245 local 08/09/81 12:00:00
DRIVER(diff)
   include cdiff
   call initialize
   if (Option == COMPARISON)
      call simple_compare
   else {
      call load
      call pair
      call grow
      call label
      call report
      call cleanup
      }
   DRETURN
   end
#-t- diff             245 local 08/09/81 12:00:00
#-h- clean            422 local 08/09/81 12:00:00
# cleanup --- close input files, remove temporaries, and shut down
   subroutine cleanup
   include cdiff
   call close (Old_file)
   if (New_file ~= STDIN)
      call close (New_file)
   ifnotdef(CPM,call close (Old_copy))
   call remove (Old_copy_name)
   ifnotdef(CPM,call close (New_copy))
   call remove (New_copy_name)
   ifnotdef(CPM,call close (Text_file))
   call remove (Text_file_name)
   return
   end
#-t- clean            422 local 08/09/81 12:00:00
#-h- enter           1355 local 08/09/81 12:00:00
# enter --- enter a line in the symbol table, return its index
   sym_pointer function enter (line)
   character line (ARB)
   include cdiff
   hash_index h
   hash_index hash
   sym_pointer i, p
   character text (MAXLINE)
   integer junk
   integer equal, getlin
   h = hash (line)
   p = Bucket (h)
   while (p ~= NULL_POINTER) {
      i = Sym_store (p + 1)      # grab index field of entry structure
      call seek (Text_loc (1, i), Text_file)
      junk = getlin (text, Text_file)
      if (equal (line, text) == YES)
         return (i)              # we got it; return its useful index
      p = Sym_store (p)          # try next item in the chain
      DEBUG call remark ("probing in lookup:.")
      DEBUG call remark ("ptr =.")
      DEBUG call putint (p, 0, ERROUT)
      DEBUG call putch (NEWLINE, ERROUT)
      DEBUG call remark ("line =.")
      DEBUG call putlin (line, ERROUT)
      }
   if (Next_inx >= MAX_UNIQUE_LINES)
      call error ("too many unique lines; symbol table overflow.")
   i = Next_inx
   Next_inx = Next_inx + 1
   h = hash (line)
   Sym_store (Next_sym) = Bucket (h)   # link in new entry
   Sym_store (Next_sym + 1) = i
   Bucket (h) = Next_sym
   Next_sym = Next_sym + 2
   call seek (END_OF_FILE, Text_file)
   call note (Text_loc (1, i), Text_file)
   call putlin (line, Text_file)
   return (i)
   end
#-t- enter           1355 local 08/09/81 12:00:00
#-h- glist           3390 local 08/09/81 12:00:00
# gen_listing --- generate a full listing of changes to a file
   subroutine gen_listing
   include cdiff
   sym_pointer oi, ni
   integer junk
   integer getlin
   character line (MAXLINE)
   string nbar "n|"
   string ci1 "ci "
   string ci5 "ci     "
   string obar "o|"
   string cd "cd"
   string b5bar "     |"
   string blankd " d"
   string bib " i "
   string bi5 " i     "
   oi = 2
   ni = 2
   repeat
      if (Old_count (oi) == 0 & New_count (ni) == 0) {
         if (Verbos == YES)
            call putch (NEWLINE, STDOUT)
         while (Old_count (oi) == 0 & New_count (ni) == 0) {
            junk = getlin (line, Old_copy)
            if (Verbos == YES) {
               call putint (oi - 1, 7, STDOUT)
               call putint (ni - 1, 5, STDOUT)
               call putlin (line, STDOUT)
               }
            junk = getlin (line, New_copy)
            oi = oi + 1
            ni = ni + 1
            }
         }
      else if (Old_count (oi) ~= 1 & New_count (ni) == 1) {
         call putch (NEWLINE, STDOUT)
         for (; New_count (ni) == 1; ni = ni + 1) {
            junk = getlin (line, New_copy)
            if (Verbos == YES) {
               call putlin (bi5, STDOUT)
               call putint (ni - 1, 5, STDOUT)
               call putch (BAR, STDOUT)
               }
            else {
               call putlin (bib, STDOUT)
               call putint (ni - 1, 4, STDOUT)
               call putlin (nbar, STDOUT)
               }
            call putlin (line, STDOUT)
            }
         }
      else if (Old_count (oi) == 1 & New_count (ni) ~= 1) {
         call putch (NEWLINE, STDOUT)
         for (; Old_count (oi) == 1; oi = oi + 1) {
            junk = getlin (line, Old_copy)
            if (Verbos == YES) {
               call putlin (blankd, STDOUT)
               call putint (oi - 1, 5, STDOUT)
               call putlin (b5bar, STDOUT)
               }
            else {
               call putlin (blankd, STDOUT)
               call putint (oi - 1, 5, STDOUT)
               call putlin (obar, STDOUT)
               }
            call putlin (line, STDOUT)
            }
         }
      else if (Old_count (oi) == 1 & New_count (ni) == 1) {
         call putch (NEWLINE, STDOUT)
         for (; Old_count (oi) == 1; oi = oi + 1) {
            junk = getlin (line, Old_copy)
            if (Verbos == YES) {
               call putlin (cd, STDOUT)
               call putint (oi - 1, 5, STDOUT)
               call putlin (b5bar, STDOUT)
               }
            else {
               call putlin (cd, STDOUT)
               call putint (oi - 1, 5, STDOUT)
               call putlin (obar, STDOUT)
               }
            call putlin (line, STDOUT)
            }
         call putch (NEWLINE, STDOUT)
         for (; New_count (ni) == 1; ni = ni + 1) {
            junk = getlin (line, New_copy)
            if (Verbos == YES) {
               call putlin (ci5, STDOUT)
               call putint (ni - 1, 5, STDOUT)
               call putch (BAR, STDOUT)
               }
            else {
               call putlin (ci1, STDOUT)
               call putint (ni - 1, 4, STDOUT)
               call putlin (nbar, STDOUT)
               }
            call putlin (line, STDOUT)
            }
         }
      else if (Old_count (oi) == 2 & New_count (ni) == 2)
         break
   return
   end
#-t- glist           3390 local 08/09/81 12:00:00
#-h- grevis          1812 local 08/09/81 12:00:00
# gen_revision --- generate 'fmt' input text with revision bar requests
   subroutine gen_revision
   include cdiff
   sym_pointer oi, ni
   integer junk
   integer getlin
   character line (MAXLINE)
                        # start_revision_bar
   string srbar  "[cc]mc |"
                        # stop_revision_bar
   string stbar   "[cc]mc"
                        #start_deletion_star
   string sdstar "[cc]mc *"
                        # stop_deletion_star
   string ststar  "[cc]mc"
   oi = 2
   ni = 2
   repeat
      if (Old_count (oi) == 0 & New_count (ni) == 0) {
         oi = oi + 1
         ni = ni + 1
         junk = getlin (line, New_copy)
         call putlin (line, STDOUT)
         }
      else if (Old_count (oi) ~= 1 & New_count (ni) == 1) {
         call putlin (srbar, STDOUT)
         call putch (NEWLINE, STDOUT)
         for (; New_count (ni) == 1; ni = ni + 1) {
            junk = getlin (line, New_copy)
            call putlin (line, STDOUT)
            }
         call putlin (stbar, STDOUT)
         call putch (NEWLINE, STDOUT)
         }
      else if (Old_count (oi) == 1 & New_count (ni) ~= 1) {
         call putlin (sdstar, STDOUT)
         call putch (NEWLINE, STDOUT)
         call putlin (ststar, STDOUT)
         call putch (NEWLINE, STDOUT)
         for (; Old_count (oi) == 1; oi = oi + 1)
            ;
         }
      else if (Old_count (oi) == 1 & New_count (ni) == 1) {
         for (; Old_count (oi) == 1; oi = oi + 1)
            ;
         call putlin (srbar, STDOUT)
         call putch (NEWLINE, STDOUT)
         for (; New_count (ni) == 1; ni = ni + 1) {
            junk = getlin (line, New_copy)
            call putlin (line, STDOUT)
            }
         call putlin (stbar, STDOUT)
         call putch (NEWLINE, STDOUT)
         }
      else if (Old_count (oi) == 2 & New_count (ni) == 2)
         break
   return
   end
#-t- grevis          1812 local 08/09/81 12:00:00
#-h- gscrip          2298 local 08/09/81 12:00:00
# gen_script --- produce editor script to convert old file into new
   subroutine gen_script
   include cdiff
   sym_pointer oi, ni, offset, length
   integer junk
   integer getlin
   character line (MAXLINE)
   oi = 2
   ni = 2
   offset = 0
   repeat
      if (Old_count (oi) == 0 & New_count (ni) == 0) {
         oi = oi + 1
         ni = ni + 1
         junk = getlin (line, New_copy)
         }
      else if (Old_count (oi) ~= 1 & New_count (ni) == 1) {
         call putint (oi - 2 + offset, 0, STDOUT)
         call putch (LETA, STDOUT)
         call putch (NEWLINE, STDOUT)
         length = 0
         for (; New_count (ni) == 1; ni = ni + 1) {
            length = length + 1
            junk = getlin (line, New_copy)
            call putlin (line, STDOUT)
            }
         call putch (PERIOD, STDOUT)
         call putch (NEWLINE, STDOUT)
         offset = offset + length
         }
      else if (Old_count (oi) == 1 & New_count (ni) ~= 1) {
         length = 0
         for (; Old_count (oi) == 1; oi = oi + 1)
            length = length + 1
         call putint (oi - 1 - length + offset, 0, STDOUT)
         call putch (COMMA, STDOUT)
         call putint (oi - 2 + offset, 0, STDOUT)
         call putch (LETD, STDOUT)
         call putch (NEWLINE, STDOUT)
         offset = offset - length
         }
      else if (Old_count (oi) == 1 & New_count (ni) == 1) {
         length = 0
         for (; Old_count (oi) == 1; oi = oi + 1)
            length = length + 1
         call putint (oi - 1 - length + offset, 0, STDOUT)
         call putch (COMMA, STDOUT)
         call putint (oi - 2 + offset, 0, STDOUT)
         call putch (LETC, STDOUT)
         call putch (NEWLINE, STDOUT)
         offset = offset - length
         length = 0
         for (; New_count (ni) == 1; ni = ni + 1) {
            length = length + 1
            junk = getlin (line, New_copy)
            call putlin (line, STDOUT)
            }
         call putch (PERIOD, STDOUT)
         call putch (NEWLINE, STDOUT)
         offset = offset + length
         }
      else if (Old_count (oi) == 2 & New_count (ni) == 2)
         break
   call putch (LETW, STDOUT)
   call putch (NEWLINE, STDOUT)
   # DON'T output a 'q' command -- prevents concatentation of scripts
   return
   end
#-t- gscrip          2298 local 08/09/81 12:00:00
#-h- grow             751 local 08/09/81 12:00:00
# grow --- grow unchanged blocks around unique line pairs
   subroutine grow
   include cdiff
   sym_pointer i, nx
   for (i = 1; i < New_size; i = i + 1) {
      nx = New_xref (i)
      if (nx > 0)       # is this line paired with an old line?
         if (New_xref (i + 1) < 0
          & New_xref (i + 1) == Old_xref (nx + 1)) {
            Old_xref (nx + 1) = i + 1
            New_xref (i + 1) = nx + 1
            }
      }
   for (i = New_size; i > 1; i = i - 1) {
      nx = New_xref (i)
      if (nx > 0)       # is this line paired?
         if (New_xref (i - 1) < 0
          & New_xref (i - 1) == Old_xref (nx - 1)) {
            Old_xref (nx - 1) = i - 1
            New_xref (i - 1) = nx - 1
            }
      }
   return
   end
#-t- grow             751 local 08/09/81 12:00:00
#-h- hash             267 local 08/09/81 12:00:00
# hash --- hash a line into a hash_index
   hash_index function hash (line)
   character line (ARB)
   integer i
   hash = 0
   for (i = 1; line (i) ~= EOS; i = i + 1)
      hash = hash + line (i)
   hash = mod (iabs (hash), HASH_TABLE_SIZE) + 1
   return
   end
#-t- hash             267 local 08/09/81 12:00:00
#-h- init            2234 local 08/09/81 12:00:00
# initialize --- set up everything needed for a file comparison
   subroutine initialize
   include cdiff
   filedes open, create
   integer argno, i
   integer equal, getarg
   character arg (FILENAMESIZE)
   string tf1 "df1"      # text of unique lines
   string tf2 "df2"      # copy of "old" file
   string tf3 "df3"      # copy of "new" file
 
   call query ("usage:  diff [-{c|d|r|s|v}] old_file [new_file].")
   Option = DIFFERENCES    # the default
   Verbos = NO
   argno = 1      # where we expect to find file names
   if (getarg (1, arg, FILENAMESIZE) ~= EOF)
   if (arg (1) == MINUS) {
      call lower (arg)
      for (i = 2; arg (i) ~= EOS; i = i + 1)
         if (arg (i) == LETC)
            Option = COMPARISON
         else if (arg (i) == LETD)
            Option = DIFFERENCES
         else if (arg (i) == LETR)
            Option = REVISION
         else if (arg (i) == LETS)
            Option = SCRIPT
         else if (arg (i) == LETV)
            Verbos = YES
         else
            call usage
      argno = 2
      }
   if (getarg (argno, arg, FILENAMESIZE) == EOF) {   # no files, use STDIN
      # Old_file = STDIN1
      # New_file = STDIN2
      call usage     # GT implementation has multiple standard ports...
      }
   else {
      Old_file = open (arg, READ)
      if (Old_file == ERR)
         call cant (arg)
      argno = argno + 1
      if (getarg (argno, arg, FILENAMESIZE) == EOF)
         New_file = STDIN     # STDIN1, to be precise
      else {
         New_file = open (arg, READ)
         if (New_file == ERR)
            call cant (arg)
         argno = argno + 1
         }
      }
   if (getarg (argno, arg, FILENAMESIZE) ~= EOF)
      call usage
   Next_inx = 1
   Next_sym = 1
   call mkuniq (tf1, Text_file_name)
   Text_file = create (Text_file_name, READWRITE)
   if (Text_file == ERR)
      call error ("can't open temporary file.")
   call mkuniq (tf2, Old_copy_name)
   Old_copy = create (Old_copy_name, READWRITE)
   if (Old_copy == ERR)
      call error ("can't open temporary file.")
   call mkuniq (tf3, New_copy_name)
   New_copy = create (New_copy_name, READWRITE)
   if (New_copy == ERR)
      call error ("can't open temporary file.")
   return
   end
#-t- init            2234 local 08/09/81 12:00:00
#-h- label           1884 local 08/09/81 12:00:00
# label --- label lines as "inserted," "deleted," or "unchanged"
   subroutine label
   include cdiff
   sym_pointer oi, ni, ox, nx
DEBUG call remark ("input new xref:.")
DEBUG do ni = 1, New_size; {
DEBUG    call putch (BLANK, ERROUT)
DEBUG    call putint (New_xref (ni), 0, ERROUT)
DEBUG    }
DEBUG call putch (NEWLINE, ERROUT)
DEBUG call remark ("input old xref:.")
DEBUG do oi = 1, Old_size; {
DEBUG    call putch (BLANK, ERROUT)
DEBUG    call putint (Old_xref (oi), 0, ERROUT)
DEBUG    }
DEBUG call putch (NEWLINE, ERROUT)
   oi = 2
   ni = 2
   repeat {
      ox = Old_xref (oi)
      nx = New_xref (ni)
      if (oi >= Old_size & ni >= New_size)
         break
      else if (oi < Old_size & ox < 0) { # deletion from old file
         Old_count (oi) = 1
         oi = oi + 1
         }
      else if (ni < New_size & nx < 0) { # insertion in new file
         New_count (ni) = 1
         ni = ni + 1
         }
      else if (ox == ni & nx == oi) {    # unchanged line
         Old_count (oi) = 0
         oi = oi + 1
         New_count (ni) = 0
         ni = ni + 1
         }
      else if (oi <= Old_size & ni <= New_size) {  # out-of-order block
         New_count (ni) = 1
         ni = ni + 1
         Old_count (nx) = 1
         Old_count (oi) = 1
         oi = oi + 1
         New_count (ox) = 1
         }
      else {
         call remark ("oi, ox, ni, nx:.")
         call putint (oi, 10, ERROUT)
         call putint (ox, 10, ERROUT)
         call putint (ni, 10, ERROUT)
         call putint (nx, 10, ERROUT)
         call putch (NEWLINE, ERROUT)
         call error ("in label:  can't happen.")
         }
      }
   Old_count (1) = 2             # mark the null lines specially,
   Old_count (Old_size) = 2      #    so people won't have to deal
   New_count (1) = 2             #    with file sizes
   New_count (New_size) = 2
   return
   end
#-t- label           1884 local 08/09/81 12:00:00
#-h- load            2085 local 08/09/81 12:00:00
# load --- load symbol table, set up cross-reference structures
   subroutine load
   include cdiff
   sym_pointer lno, i
   sym_pointer enter
   hash_index h
   character line (MAXLINE)
   integer getlin, length
TUNING sym_pointer p
TUNING integer used, chain_len, max_chain_len, min_chain_len
   do h = 1, HASH_TABLE_SIZE
      Bucket (h) = NULL_POINTER
   do lno = 1, MAX_UNIQUE_LINES; {
      Old_count (lno) = 0
      New_count (lno) = 0
      }
  # Load the "old" file:
   for (lno = 2; getlin (line, Old_file) ~= EOF; lno = lno + 1) {
      if (lno > MAX_FILE_SIZE)
         call error ("old file too large to handle.")
      call putlin (line, Old_copy)
      i = enter (line)
      Old_count (i) = Old_count (i) + 1
      Old_lno (i) = lno
      Old_xref (lno) = -i
      }
   Old_size = lno    # includes null line at end
  # Load the "new" file:
   for (lno = 2; getlin (line, New_file) ~= EOF; lno = lno + 1) {
      if (lno > MAX_FILE_SIZE)
         call error ("new file too large to handle.")
      call putlin (line, New_copy)
      i = enter (line)
      New_count (i) = New_count (i) + 1
      New_xref (lno) = -i
      }
   New_size = lno    # also allows for null line at end
TUNING call print (STDOUT2, "Old_size = *i, New_size = *i*n"s,
TUNING    Old_size, New_size)
TUNING call print (STDOUT2, "*i unique lines*n"s, Next_inx - 1)
TUNING used = 0
TUNING max_chain_len = 0
TUNING min_chain_len = MAX_UNIQUE_LINES
TUNING do h = 1, HASH_TABLE_SIZE; {
TUNING    p = Bucket (h)
TUNING    if (p ~= NULL_POINTER)
TUNING       used += 1
TUNING    chain_len = 0
TUNING    while (p ~= NULL_POINTER) {
TUNING       chain_len += 1
TUNING       p = Sym_store (p)
TUNING       }
TUNING    max_chain_len = max0 (chain_len, max_chain_len)
TUNING    min_chain_len = min0 (chain_len, min_chain_len)
TUNING    }
TUNING call print (STDOUT2, "chain lengths:  min = *i, avg = *i, max = *i*n"s,
TUNING    min_chain_len, (Next_inx - 1) / used, max_chain_len)
TUNING call print (STDOUT2, "hash buckets *i% full*n"s,
TUNING    (100 * used) / HASH_TABLE_SIZE)
   return
   end
#-t- load            2085 local 08/09/81 12:00:00
#-h- pair             536 local 08/09/81 12:00:00
# pair --- pair up unique lines in both files
   subroutine pair
   include cdiff
   sym_pointer i, j, k
   for (i = 2; i < New_size; i = i + 1) {
      j = -New_xref (i)
      if (Old_count (j) == 1 & New_count (j) == 1) { # unique pair
         New_xref (i) = Old_lno (j)
         k = Old_lno (j)
         Old_xref (k) = i
         }
      }
   New_xref (1) = 1                 # match null lines at BOF
   Old_xref (1) = 1
   New_xref (New_size) = Old_size   # ... and at EOF
   Old_xref (Old_size) = New_size
   return
   end
#-t- pair             536 local 08/09/81 12:00:00
#-h- report           723 local 08/09/81 12:00:00
# report --- report differences between files in desired format
   subroutine report
   include cdiff
DEBUG sym_pointer i
DEBUG call print (ERROUT, "New mark: "s)
DEBUG do i = 1, New_size
DEBUG    call print (ERROUT, "  *i"s, New_count (i))
DEBUG call print (ERROUT, "*nOld mark: "s)
DEBUG do i = 1, Old_size
DEBUG    call print (ERROUT, "  *i"s, Old_count (i))
DEBUG call putch (NEWLINE, ERROUT)
   call seek (BEGINNING_OF_FILE, Old_copy)
   call seek (BEGINNING_OF_FILE, New_copy)
   if (Option == DIFFERENCES)
      call gen_listing
   else if (Option == REVISION)
      call gen_revision
   else if (Option == SCRIPT)
      call gen_script
   else
      call error ("in report:  can't happen.")
   return
   end
#-t- report           723 local 08/09/81 12:00:00
#-h- scompr          1472 local 08/09/81 12:00:00
# simple_compare --- do a line-by-line comparison of the input files
   subroutine simple_compare
   include cdiff
   character line1 (MAXLINE), line2 (MAXLINE)
   integer lineno, m1, m2
   integer equal, getlin
                        # different
   string diff "different"
                        # eof_on_old_file
   string oldeof "eof on old file"
                        # eof_on_new_file
   string neweof "eof on new file"
   lineno = 0
   repeat {
      m1 = getlin (line1, Old_file)
      m2 = getlin (line2, New_file)
      if (m1 == EOF | m2 == EOF)
         break
      lineno = lineno + 1
      if (equal (line1, line2) == NO)
         if (Verbos == YES) {
            call putch (NEWLINE, STDOUT)
            call putint (lineno, 5, STDOUT)
            call putch (NEWLINE, STDOUT)
            call putlin (line1, STDOUT)
            call putlin (line2, STDOUT)
            }
         else {
            call putlin (diff, STDOUT)
            call putch (NEWLINE, STDOUT)
            return
            }
      }
   if (m1 == EOF & m2 ~= EOF)
      if (Verbos == YES) {
         call putlin (oldeof, STDOUT)
         call putch (NEWLINE, STDOUT)
         }
      else {
         call putlin (diff, STDOUT)
         call putch (NEWLINE, STDOUT)
         }
   if (m1 ~= EOF & m2 == EOF)
      if (Verbos == YES) {
         call putlin (neweof, STDOUT)
         call putch (NEWLINE, STDOUT)
         }
      else {
         call putlin (diff, STDOUT)
         call putch (NEWLINE, STDOUT)
         }
   return
   end
#-t- scompr          1472 local 08/09/81 12:00:00
#-h- usage            139 local 08/09/81 12:00:00
# usage --- print usage message, then die
   subroutine usage
   call error ("usage:  diff [-{c|d|r|s|v}] old_file [new_file].")
   end
#-t- usage            139 local 08/09/81 12:00:00
#-t- tdiff.r         22089 local 08/09/81 12:00:00
