#-h-  defns                      1189  ascii   04/02/82  15:18:58
define(DATESIZE, 10)
define(MAXMEM, 50000)
define(HIGHEND, MAXMEM+1)       # used when counting backwards from top
define(MAXINTEGER, 32687)
define(COMPLEMENT, 1)
define(MAXCHARS, 20)

# TCS data file keys
define(STATS,"%%s ")                    # statistics
define(VERKEY,"%%d ")                   # key field on history-info lines
define(COMMENT,"%%c ")
define(ENDKEY,"%%T")                    # end of header
define(INSERT,"%%I ")                   # begin "inserted in this version"
define(DELETE,"%%D ")                   # begin "deleted in this version"
define(ENDSEG,"%%E ")                   # end of segment
define(KEYSIZ,5)                        # pts AFTER blank at end of key

define(WEWANT,2)                        # positional info from PARSE
define(THISVER,6)
define(PREVVER,7)
define(MAXVER,100)                      # max number of (direct) ancestors

define(OFF,0)
define(ON,1)

# flow control during DIFF processing
# values for "flag"
define(INHIST, 1)
define(INRVSN, 2)
define(MATCHING, 3)

# simulated "structure" during DIFF tree generation
define(PREV, 0)
define(ALINE, 1)
define(BLINE, 2)
define(CANDSIZ, 3)                      # size of a candidate "struct"

#-t-  defns                      1189  ascii   04/02/82  15:18:58
#-h-  decls                       534  ascii   04/02/82  15:18:58
common /tcs/    ancestry(MAXVER),       # family lineage
        fdhis, fdrev, fdscr,    # file descriptors
        flag,                   # flag during history-file generation
        insert,                 # flag during lineget, init'd by rstget
        myances,                # closest ancestor's "absolute" version number
        maxver,                 # last "absolute" version number
        seekptr(2)              # markl/seek pointer
integer ancestry, fdhis, fdrev, fdscr, flag,
        insert, myances, maxver, seekptr

#-t-  decls                       534  ascii   04/02/82  15:18:58
#-h-  delta.r                   40153  ascii   05/26/82  14:31:48
#-h- main             948  asc  22-oct-81 12:07:24  npg
#       program DELTA


DRIVER(delta)

include "defns"
include "decls"

# For now, DELTAs may only be performed on the "latest"
# version in the tcs file.  Branches work, but no tool exists for
# (auto-)insertion of branch points.
# To turn this feature on, pass the branch's ancestor in 'wanted'.
# It is expected that GET will stow the version number "gotten"
# and that DELTA will stem from that info.

define(GET,)

integer getarg

character histry(FILENAMESIZE)
character rvisn(FILENAMESIZE)
character nwhsty(FILENAMESIZE)

character wanted(40)                            # the desired version number


if (getarg(1, rvisn, FILENAMESIZE) == EOF  
        |  getarg(2, histry, FILENAMESIZE) == EOF)
        call error('Usage: DELTA revision history [newhistory].')
if (getarg(3, nwhsty, FILENAMESIZE) == EOF)
        call scopy(histry, 1, nwhsty, 1)


wanted(1) = EOS                         # zap NEWLINE

call makdelta(histry, rvisn, nwhsty, wanted)
return
end

#-t- main             948  asc  22-oct-81 12:07:24  npg
#-h- makdelta       11235  asc  22-oct-81 12:07:25  npg
# The DIFF algorithm from BTL Computing Science Technical Report #41,
#  "An Algorithm for Differential File Comparison",
#  by J.W. Hunt and M.D. McIlroy.

# Comments on the use of the "tab" array:
#
#       The V[] vector grows from both ends of TAB towards the middle.
#       The "serial" (line number) entries are at the bottom and the
#       corresponding "hash" entries at the top.
#       These are sorted...
#       ...and "last" members of equivalence classes have their sign
#       toggled to mark the end of a class.
#               Magic positions in the TAB array:
#                       nnn = # of lines read from file 2
#                       nnn+3 -> start of data learned from file 1
# makdelta - back up revised file in history file.


subroutine makdelta(hisfile, revfile, newfile, wanted)
                                        # McI: file1=hisfile and file2=revfile

include "decls"
common /memory/ tab(MAXMEM)


character hisfile(FILENAMESIZE)         # name of history file
character revfile(FILENAMESIZE)         # name of revision file
character newfile(FILENAMESIZE)         # name of new history file
                                        # (may be hisfile)
character scrfile(FILENAMESIZE)         # name of scratch file
character wanted(40)


character hisbuf(MAXLINE)               # file input buffers
character revbuf(MAXLINE)

integer create
integer equal, getlin, iabs, hash, lineget, open, prompt

integer c, cand, count
character date(DATESIZE)
integer gap, high
integer ipg, irec1, irec2, itemp
integer i, j, k
integer ki, kipg, kmid, ks, ks1
integer len1, len2, low, midpt
integer key                             # computed hash value
integer*2 tab                           # array for ptr & code storage
integer nil
integer p, r, s
integer mmm, nnn                        # length of file1 & file2

string sct 'SCT'
string gthan "> "
string newv "New Version is # "
string tferr "Temp file error: "
string dee "D "
string sstats STATS
string sverkey VERKEY
string scomment COMMENT
string sinsert INSERT
string sdelete DELETE
string sendseg ENDSEG


fdrev = open(revfile, READ)
if (fdrev == ERR)
        call cant(revfile)

call mkuniq(sct, scrfile)
fdscr = create(scrfile, WRITE)
if (fdscr == ERR)
        call cant(scrfile)

# Stick in the user's comment before all else
call remark ("History?.")
repeat {                                # append the reason for change
        i = prompt(gthan, hisbuf, STDIN)
        if (i == EOF)
                break
        if ((i == 2) & (hisbuf(1) == PERIOD))
                break
        call putlin(scomment, fdscr)
        call putlin(hisbuf, fdscr)
}


# STEP 0.  Increment the version number.

call setget(hisfile, wanted)            # sets up ancestry of "wanted" version

call incvnum(wanted)
call putlin(newv, ERROUT)
call putlin(wanted, ERROUT)
call putch(NEWLINE, ERROUT)

maxver = maxver + 1                     # next "absolute" version number

# can write some stuff to scratch file here ??

# STEP 1.  Input new (revision) file.

                                        # McI: V[] vector, 
                                        #  "serial" grows UP and
                                        #  "hash" grows DOWN from the top
for(j = 1; j< HIGHEND-j; j = j+1) {
        if (getlin(revbuf, fdrev) == EOF)
                break
        tab(j) = j                      # save line number
                                        # McI: H(j) function
        key = hash(revbuf)              # store the hash values
        tab(HIGHEND-j) = key            #  sequentially from the
                                        #  END of the array
}
call close(fdrev)

nnn = j - 1                             # line count of revfile
if (nnn == 0)
        call error('Revision file is empty.')

# STEP 2.  Sort.
#       Ascending order, hash as primary key and serial as secondary.

for (gap = 1; gap <= nnn; gap = gap+gap)
        ;                               # next power of 2 after nnn

for (gap = (gap-1)/2; gap > 0; gap = gap/2)
        for (j = 1; j <= nnn-gap; j = j + 1)
                for (i = j; i > 0; i = i-gap) {
                        ki = HIGHEND - i
                        ipg = i + gap

                        kipg = HIGHEND  - ipg
                        if (tab(ki) < tab(kipg)  
                                | (tab(ki) == tab(kipg) & tab(i) <= tab(ipg)))
                                break
                        itemp = tab(ki); tab(ki) = tab(kipg); tab(kipg) = itemp
                        itemp = tab( i); tab( i) = tab( ipg); tab( ipg) = itemp
                }

# STEP 3.  Mark equivalence classes.

                                        # McI: E[] vector
                                        #  "sign" of serial used as
                                        #  the "last" flag
for (j = 1; j < nnn; j = j + 1)
                                        # McI: f(j)
        if (tab(HIGHEND-j) != tab(HIGHEND-j-1))
                tab(j) = -tab(j)        # toggle to true

tab(nnn) = -tab(nnn)                    # final entry is (of course) true

# STEP 4.  Input hisfile and match with revfile

                                        # McI: P[] vector
for (i = nnn+3; i < HIGHEND-nnn; i = i + 1) {
        if (lineget(hisbuf, NO) == EOF)
                break
        key = hash(hisbuf)              # hash value for this line
        j = 0                           # initialize
        low = 0
        high = nnn+1
        while (low+1 < high) {          # binary search for matching hash
                midpt = (low+high) / 2  # search midpoint
                kmid = HIGHEND-midpt    # kmid points to corr. hash entry
                if (tab(kmid) < key)    # compare, too high or too low
                        low = midpt     # move endpoint up
                else {
                        high = midpt    # move endpoint down
                        if (tab(kmid) == key)
                                        # match found, save its position
                                        # continued searching finds the
                                        #  highest (position) matching entry
                                j = midpt
                }
        }
        tab(i) = j                      # saves zero or (highest) matching
                                        #  entry number
}
totsiz = i-1                            # hisfile + revfile + 2

mmm = totsiz - nnn - 2                  # number of lines in file1 (hisfile)
if (mmm == 0)
        call error('History file is empty.')

# STEP 5.  Setup for longest common subsequence.

cand = totsiz+1                         # candidate
nil = totsiz+1
k = nnn+1
                                        # McI: K[0]
tab(cand+ALINE) = nnn+2
tab(cand+BLINE) = 0
tab(cand+PREV) = nil
tab(k) = cand
cand = cand+CANDSIZ
                                        # McI: K[1]
tab(cand+ALINE) = totsiz+1
tab(cand+BLINE) = nnn+1
tab(cand+PREV) = nil
tab(k+1) = cand
cand = cand+CANDSIZ

# STEP 6.  Find longest common sequence.

for (i = nnn+3; i <= totsiz; i = i + 1) {
                                        # This loop traverses the P[] vector
                                        #  (step4) from 1 to mmm.

        p = tab(i)                      # P[] points to start of the class of
                                        #  lines in file2 == line "i" in file1.
        if (p != 0) {                   # has 0 or line# of match in file2

                                        # McI: procedure MERGE(K,k,i,E,p)
                                        # K[] {tab(totsiz+1:k} from step5
                                        # "k" is the last filled index in K[]
                                        # "i" is the current index in file1
                                        # E[] {tab(1:nnn)} from step3
                                        # "p" is index in E of 1st element of
                                        #  class of lines in file2 equivalent
                                        #  to line "i" of file1.

                                        # McI: (merge.1)
                                        # Initially:  r <- 0;  c <- K[r]
                r = nnn+1               # ptr into K[]
                c = tab(r)              # will always refer to LAST cand found
                repeat {                # McI: (merge.2)
                        j = iabs(tab(p))
                                        # McI: (merge.3)  j <- E[p].serial
                                        # Search K[r:k] for an element K[s]
                                        #  such that K[s]->BLINE < j and
                                        #  K[s+1]->BLINE >= j.  Binary search.
                        low = r
                        high = k
                        while (low <= high) {
                                s = (low+high) / 2
                                ks = tab(s)
                                if (tab(ks+BLINE) >= j)
                                        high = s - 1
                                else {
                                        ks1 = tab(s+1)
                                        if (tab(ks1+BLINE) >= j)
                                                break
                                        low = s+1
                                }
                        }
                        if (low <= high) {
                                if (tab(ks1+BLINE) > j) {       # McI: (merge.4)
                                        tab(r) = c              # K[r] <- c
                                        r = s + 1
                                        if (cand > HIGHEND-3 )
                                                call error('Files are too big to handle.')
                                        # c <- cand(i,j,K[s])
                                        tab(cand+ALINE) = i
                                        tab(cand+BLINE) = j
                                        tab(cand+PREV) = ks
                                        c = cand
                                        cand = cand+CANDSIZ
                                }
                                if (s == k) {                   # McI: (merge.5)
                                        tab(k+2) = tab(k+1)     # move fence
                                        k = k + 1
                                        break
                                }
                        }
                        if (tab(p) < 0) # McI: (merge.6) if E[p].last == true,
                                break   #  then break out of step2's loop,
                        else            #  otherwise increment "p".
                                p = p + 1
                }
                tab(r) = c              # McI: (merge.7)  K[r] <- c
        }
}

# STEP 7.  Clear table.
                                        # Discard the P[] vector.
                                        # Let J[0:m] be a vector of integers.
c = tab(k)                              # save for step8
for (i = nnn+3; i <= totsiz; i = i + 1)
        tab(i) = 0                      # zero out J[]
tab(totsiz+1) = nnn+1

# STEP 8.  Build table.

                                        # For each element "c" of the chain
                                        #  of candidates referred to by K[k]
                                        #  and linked by "PREV" references,
                                        #  set:  J[c.a] <- c.b
while (c != nil) {                      # traverse the tree
        i = tab(c+ALINE)
        j = tab(c+BLINE)
        tab(i) = j
        c = tab(c+PREV)
}
# The non-zero elements of J now pick out a longest common subsequence,
#  possibly including spurious "jackpot" sequences.  The pairings between
#  the two files are given by:  { (i,J[i]) | J[i] != 0 }.

# STEP 9.  Print the differences.  Weed out jackpots.

call rstget()                           # return to start of history text

fdrev = open(revfile, READ)             # return to top of revision
if (fdrev == ERR)
        call cant(revfile)

irec1 = 0; irec2 = 0; count = 0
                                        # Transitions in the state signal
                                        #  a change in the correspondence
                                        #  between the two files.
                                        # This version is set up for the
                                        #  Text Control System
                                        #  and therefore develops the
                                        #  "differences" in an appropriate
                                        #  manner.
i = nnn+2
flag = MATCHING                         # holds current state
repeat {
        irec1 = irec1 +  1
        if (irec1 <= mmm)
                len1 = lineget(hisbuf, YES)             # history file
        i = i + 1
        j = tab(i)
        if (j == 0) {                                   # no matching line found
                                                        #  in revision-file
                if (flag != INHIST) {
                        if (flag == INRVSN)
                                call puttag(sendseg)
                        call puttag(sdelete)
                        flag = INHIST
                }
                call putlin(hisbuf, fdscr)              # put out "old" line
        } else {                                 # potential match
                repeat {
                        irec2 = irec2 + 1
                        if (irec2 <= nnn)
                                len2 = getlin(revbuf, fdrev)    # revision file
                        if (irec2 >= j)                 # MAY be a match
                                break
                        if (flag != INRVSN) {
                                if (flag == INHIST)
                                        call puttag(sendseg)
                                call puttag(sinsert)
                                flag = INRVSN
                        }
                        call putlin(revbuf, fdscr)
                }
                if (irec2 > nnn)
                        break
                if (equal(hisbuf, revbuf) == YES) {     # assures equality
                        if (flag != MATCHING) {
                                call puttag(sendseg)
                                flag = MATCHING
                        }
                        count = count + 1
                        call putlin(hisbuf, fdscr)      # matching line
                } else {                         # jackpot
                        # Jackpot!  The hash results matched, but
                        #  the lines were not identical.  Output the lines
                        #  with appropriate wrappers and carry onward.
                        if (flag != INHIST) {
                                if (flag == INRVSN)
                                        call puttag(sendseg)
                                call puttag(sdelete)
                        }
                        call putlin(hisbuf, fdscr)
                        call puttag(sendseg)
                        call puttag(sinsert)
                        call putlin(revbuf, fdscr)
                        flag = INRVSN
                }
        }
}
if (flag != MATCHING)
        call puttag(sendseg)

# copy the rest of the history to the end of the new history file
while (lineget(hisbuf, YES) != EOF)
        # let lineget xfer the lines to the new file
        call putlin(hisbuf, fdscr)

call close(fdhis)
call close(fdrev)
call close(fdscr)

call putnum(nnn - count, 1, ERROUT)             # print the statistics
call remark(' insertions.')
call putnum(mmm - count, 1, ERROUT)
call remark(' deletions.')
call putnum(count, 1, ERROUT)
call remark(' unchanged.')

# STEP 10. Move the result to the new-history file,
#  prepending the new family tree info.

fdhis = create(newfile, WRITE)                  # re-use file descriptor
if (fdhis == ERR)
        call cant(newfile)

fdscr = open(scrfile, READ)
if (fdscr == ERR) {
        call putlin(tferr)
        call cant(scrfile)
}

# add a "hash" value for integrity
call putlin(sstats, fdhis)                       # statistics
call putnum(nnn - count, 1, fdhis)
call putch(SLASH, fdhis)
call putnum(mmm - count, 1, fdhis)
call putch(SLASH, fdhis)
call putnum(count, 1, fdhis)
call putch(NEWLINE, fdhis)

call putlin(sverkey, fdhis)
call putlin(dee, fdhis)                        # signal delta
call putlin(wanted, fdhis)
call putch(BLANK, fdhis)

call gdate(date)                        # date
call putlin(date, fdhis)
call putch(BLANK, fdhis)
call gtime(date)                        # time
call putlin(date, fdhis)
call putch(BLANK, fdhis)

call getuid(revbuf)                     # fetch user name
call putlin(revbuf, fdhis)
call putch(BLANK, fdhis)

call putnum(maxver, 1, fdhis)
call putch(BLANK, fdhis)
call putnum(myances, 1, fdhis)
call putch(NEWLINE, fdhis)

# now move the file
while (getlin(hisbuf, fdscr) != EOF)
        call putlin(hisbuf, fdhis)

# cleanup
call remove(scrfile)

return

end
#-t- makdelta       11235  asc  22-oct-81 12:07:25  npg
#-h- parse           1892  asc  22-oct-81 12:07:28  npg
#-p-
#******************************************************************************
#*
#*
#*                               PARSE
#*
#*    author: Neil P Groundwater                       date: 12-AUG-81
#*
#*
#*
#*    Purpose:  Decompose the "Ad" lines in the history file return the
#*       members of the line via an array of indexes into the original text
#*       line. Replace the delimiter character with EOS characters.
#*
#*
#*    Calling convention:   parse(inbuf, from, outarray, delim)
#*
#*
#*    Formal Parameters
#*       inbuf:  Input string (array)
#*       from:  Starting index in inbuf
#*       outarray:  Returned array of member-offsets in inbuf
#*       delim:  Delimiter character supplied by caller
#*
#*
#*    Modules which call PARSE
#*       main
#*
#*
#*    Description of algorithm:  Move "pointer" across input line and set
#*       outarray with pertinent values.
#*
#*
#******************************************************************************
#-p-
# Subroutine: PARSE(INBUF, FROM, OUTARRAY, DELIMITER)

# Enter the chars from the inbuf,
# break it into its components

# Outarray will contain pointers to the start of each memeber of inbuf
# Convert the delimiters to EOS, in place.
# The string is assumed to be NEWLINE terminated.

define(NULL,0)

subroutine parse(inbuf, from, outarray, delim)
character inbuf(MAXLINE)
integer from                            # start offset in inbuf
integer outarray(16)                    # point to each "token"
character delim

integer ptr

        ptr = from
        while (inbuf(ptr) == delim)     # skip to 1st field
                ptr = ptr+1
        for (i=1; inbuf(ptr) != NEWLINE; i=i+1) {
                outarray(i) = ptr

                # skip thru field
                while ((inbuf(ptr) != delim) & (inbuf(ptr) != NEWLINE))
                        ptr = ptr+1

                # zap and skip delimiters
                while ((inbuf(ptr) == delim) & (inbuf(ptr) != NEWLINE)) {
                        inbuf(ptr) = EOS
                        ptr = ptr+1
                }
        }
        inbuf(ptr) = EOS
        outarray(i) = NULL
return
end

#-t- parse           1892  asc  22-oct-81 12:07:28  npg
#-h- bmatch          1377  asc  21-jan-82 14:32:32  npg
#-p-
#******************************************************************************
#*
#*
#*                               BMATCH
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  Pattern match - from Software Tools (p.140) (renamed)
#*
#*
#*    Calling convention:   bmatch(lin, from, pat)
#*
#*
#*    Formal Parameters
#*       lin:  source pattern
#*       from:  index in source pattern at which to start comparison
#*       pat:  pattern to match against
#*
#*
#*    Module Returns:  zero if PAT is not present in LIN index of next char
#*       in LIN after the appearance of PAT
#*
#*
#*    Modules which call BMATCH
#*       main
#*       setget
#*       lineget
#*
#*
#*    Description of algorithm:  Compares PAT with a substring of LIN.
#*       Starts comparison with 1st char of PAT and LIN(FROM). If PAT is
#*       present, the index of the "following" char in LIN is returned,
#*       otherwise returns zero.
#*
#*
#******************************************************************************
#-p-
# bmatch - most basic match, Software Tools p. 140.  (renamed)

integer function bmatch(lin, from, pat)
character lin (MAXLINE), pat(MAXLINE)
integer from, i, j

i = from
for (j=1; pat(j) != EOS; j = j + 1) {
        if (lin(i)!=pat(j)) {
                bmatch = 0
                return          # with no match
        }
        i = i + 1
}
bmatch = i
return
end

#-t- bmatch          1377  asc  21-jan-82 14:32:32  npg
#-h- bmch2            308  asc  22-oct-81 12:07:29  npg
# bmch2 - basic match, also compares the LENGTH of the args

integer function bmch2(lin, from, pat)
character lin (MAXLINE), pat(MAXLINE)
integer from

integer equal

character temp(MAXLINE)

call scopy(lin, from, temp, 1)          # copy string to temp
return(equal(temp, pat))                # returns YES if exactly equal
end

#-t- bmch2            308  asc  22-oct-81 12:07:29  npg
#-h- ctoi2            962  asc  21-jan-82 14:32:33  npg
#-p-
#******************************************************************************
#*
#*
#*                               CTOI2
#*
#*    author: Neil P Groundwater                       date: 12-AUG-81
#*
#*
#*
#*    Purpose:  Calls CTOI but allows the caller of CTOI2 to pass a
#*       fixed-value argument.
#*
#*
#*    Calling convention:   ctoi2(buf, fixed)
#*
#*
#*    Formal Parameters
#*       buf:  input string
#*       fixed:  offset in buf to begin conversion. May be a FIXED NUMBER
#*          (like 3).
#*
#*
#*    Module Returns:  An integer value.
#*
#*
#*    Modules called by CTOI2
#*       ctoi
#*
#*
#*    Modules which call CTOI2
#*       lineget
#*
#*
#******************************************************************************
#-p-
# convert character string to integer - allows "constant" index as arg

integer function ctoi2(buf, fixed)
character buf
integer fixed

integer ctoi

integer ptr

ptr = fixed
return(ctoi(buf, ptr))
end
#-t- ctoi2            962  asc  21-jan-82 14:32:33  npg
#-h- setget          3370  asc  21-jan-82 14:32:33  npg
#-p-
#******************************************************************************
#*
#*
#*                               SETGET
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  Set up ANCESTRY of the previous version of the file.
#*    Used in conjunction with LINEGET which will return
#*    the next line from the desired version and RSTGET
#*    which puts the file pointer at the start of the
#*    "content" portion of the file in preparation for
#*    a new series of LINEGET calls.
#*
#*
#*    Calling convention:   setget (filename, wanted)
#*
#*
#*    Formal Parameters
#*       filename:  file from which to read data
#*       wanted:  (string) version number desired
#*
#*
#*    Global Variables Changed
#*       ancestry:  the family history of the desired version (array)
#*       seekptr:  the file offset at the end of the header info
#*
#*
#*    Modules called by SETGET
#*       error
#*       putlin
#*       parse
#*       aputlin
#*       putch
#*       note
#*       bmatch
#*       bmch2
#*       ctoi2
#*       scopy
#*
#*
#*    Modules which call SETGET
#*       main
#*
#*
#******************************************************************************
#-p-

subroutine setget (filename, wanted)
character filename(FILENAMESIZE)
character wanted(FILENAMESIZE)

include "decls"

integer bmatch, bmch2, ctoi2, getlin, open       # functions

character inbuf(MAXLINE)
integer array(16)       # holds pointers returned by PARSE
integer i
integer thread, iprev, ithis    # trace family tree

string vnbr "Version # "
string sverkey VERKEY
string sendkey ENDKEY

fdhis = open(filename, READ)
if (fdhis == ERR)
        call error("Cannot locate TCS history file.")

for (i=1; i<=MAXVER; i=i+1)                     # initialize
        ancestry(i) = NO
thread = -1                                     # follows back up tree
repeat {
        i = getlin(inbuf, fdhis)
        if (i == EOF)
                call error("Unexpected EOF on history-info scan.")
ifdef(GET, call putlin(inbuf, fdscr)  )         # keep it for posterity

        if (bmatch(inbuf, 1, sendkey) != 0)
                call error("Nonexistant revision level requested.")

        # Screen for version-info lines
        if (bmatch(inbuf, 1, sverkey) != 0) {
                call parse(inbuf, KEYSIZ, array, BLANK)
                ithis = ctoi2(inbuf, array(THISVER))    # thread values
                iprev = ctoi2(inbuf, array(PREVVER))

                if (thread < 0) {
                        # When the FIRST version-info line is detected, get
                        #  the "absolute" version number so that it may be
                        #  added later to the family tree.
                        maxver = ithis
                        thread = 0
                }

                if (thread == 0) {                      # started yet?
                        # Was either no version specified or
                        #  is this the requested version?
                        if ((wanted(1) == EOS) | # if none, take latest version
                            (bmch2(inbuf, array(WEWANT), wanted) == YES)) {
                                if (wanted(1) == EOS) { # go get latest number
                                        call scopy(inbuf, array(WEWANT),
                                                wanted, 1)
                                        call putlin(vnbr, ERROUT)
                                        call putlin(wanted, ERROUT)
                                        call putch(NEWLINE, ERROUT)
                                }
                                # yes, start recording ancestry
                                ancestry(ithis) = YES
ifdef(GET,                      myances = ithis )       # parent of new stuff
                                thread = iprev          # predecessor
                                if (thread == 0)        # reached root
                                        break
                        } else
                                next    # not a match, go on to next info-line
                } else
                        # next on the tree?
                        if (ithis == thread) {
                                ancestry(ithis) = YES
                                thread = iprev
                                if (thread == 0)
                                        break   # scan thru header is complete
                        }
        }
}

call note(seekptr, fdhis)      # tag the start of the text portion of the file
return
end

#-t- setget          3370  asc  21-jan-82 14:32:33  npg
#-h- rstget           979  asc  21-jan-82 14:32:34  npg
#-p-
#******************************************************************************
#*
#*
#*                               RSTGET
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  Restore read pointer to start of text info in the Text
#*       Control System file.
#*
#*
#*    Calling convention:   rstget()
#*
#*
#*    Formal Parameters
#*
#*
#*
#*    Global Variables Changed
#*       insert:  Mode of scanner in LINEGET. Reset here, but forced to
#*          correct value in LINEGET anyway when it reads the "version 1"
#*          keyline because "version 1.1" is everybodies ancestor.
#*
#*
#*    Modules called by RSTGET
#*       seek
#*
#*
#*    Modules which call RSTGET
#*       (unknown)
#*
#*
#******************************************************************************
#-p-
subroutine rstget()

include "decls"

call seek(seekptr, fdhis)       # point to start of data portion
insert = OFF                    # current mode

return
end
#-t- rstget           979  asc  21-jan-82 14:32:34  npg
#-h- lineget         2813  asc  21-jan-82 14:37:33  npg
#-p-
#******************************************************************************
#*
#*
#*                               LINEGET
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  Ancestry has been established. Develop the particular version
#*    Returns a line-at-a-time to caller.
#*
#*
#*    Calling convention:   lineget (inbuf, passthru)
#*
#*
#*    Formal Parameters
#*       inbuf:  buffer to fill with next line from appropriate ancestor
#*          version.
#*       passthru:  flag signalling that ".tcs" file is being regenerated.
#*          Used only in the version of this file compiled into DELTA.
#*
#*
#*    Module Returns:  the number of chars in the line read from the file or
#*       EOF at end-of-file.
#*
#*
#*    Modules called by LINEGET
#*       error
#*       puttag
#*       putlin
#*       getlin
#*       bmatch
#*       ctoi2
#*
#*
#*    Modules which call LINEGET
#*       main
#*
#*
#*    Description of algorithm:
#*       Based on the "family tree" set up in the ancestry array, the
#*       appropriate text line are passed back to the caller.
#*       The local variable (saved upon return) CURRNEST keeps track of the
#*       current level of being retrieved.
#*
#*
#******************************************************************************
#-p-

integer function lineget (inbuf, passthru)
character inbuf(MAXLINE)
integer passthru                        # send text to new-history file

include "decls"

integer bmatch, ctoi2, getlin

integer currnest, i

string sinsert INSERT
string sdelete DELETE
string sendseg ENDSEG

save currnest

repeat {
        i = getlin(inbuf, fdhis)
        if (i == EOF)
                call error("Unexpected EOF on history-data scan.")

        if (bmatch(inbuf, 1, sendseg) != 0) {    # non-zero implies it matched
                if (ctoi2(inbuf, KEYSIZ) == 1) {                        # done
                        if (passthru == YES)
                                call putlin(inbuf, fdscr)       # last line
                        break
                }
                if (insert == OFF)
                        if (ctoi2(inbuf, KEYSIZ) == currnest)
                                insert = ON
        } else if (bmatch(inbuf, 1, sinsert) != 0)
                # "insert" is not initialized because it will always be set
                # to ON here when the 1st "I 1" line is encountered.  All
                # versions descend from 1.1.
                if (ancestry(ctoi2(inbuf, KEYSIZ)) == YES)
                        insert = ON
                else {
                        # not in one of its ancestors,
                        # skip to matching ENDSEG line
                        if (insert == ON) {
                                currnest = ctoi2(inbuf, KEYSIZ)
                                insert = OFF
                        }
                }
        else if (bmatch(inbuf, 1, sdelete) != 0) {
                if (ancestry(ctoi2(inbuf, KEYSIZ)) == YES)
                        # skip to matching ENDSEG line
                        if (insert == ON) {
                                currnest = ctoi2(inbuf, KEYSIZ)
                                insert = OFF
                        }
        } else
                if (insert == ON)
                        return (i)      # text returned in "inbuf"

        # pass all other lines thru to the output file
        if (passthru == YES) {
                if (flag == INHIST) {
                        call puttag(sendseg)
                        flag = MATCHING
                }
                call putlin(inbuf, fdscr)
        }
}

return (EOF)    # at EOF
end

#-t- lineget         2813  asc  21-jan-82 14:37:33  npg
#-h- hash             362  asc  22-oct-81 12:09:48  npg
integer function hash (mcard)
character mcard(MAXLINE)
integer i, n



hash = 0
for (i=1; mcard(i) != EOS; i= i + 1) {
        n = mcard(i)
        if (n < 0)
                n = (n+MAXINTEGER) + COMPLEMENT
        if (hash < MAXINTEGER/2 )                       
                hash = hash + hash + 1
        else
                hash = (hash-MAXINTEGER) + hash-1
        hash = n - hash
        if (hash < 0)
                hash = (hash+MAXINTEGER) + COMPLEMENT
}
return
end

#-t- hash             362  asc  22-oct-81 12:09:48  npg
#-h- incvnum          919  asc  22-oct-81 12:07:32  npg
# Increment version-number string.
#       given a string: 1.2.33.44
#       change it to:   1.2.33.45
#       or 1.3.4.99 --> 1.3.4.100
#       or 1.2 --> 1.3

subroutine incvnum( in )
character in(MAXLINE)

define (FALSE, 0)
define (TRUE, 1)

integer ctoi, itoc
integer eflag
integer i, ki, n
character tmp(10)               # scratch spot

i = 1                           # ptr into string
eflag = FALSE
repeat {
        ki = i                  # start of final number in string
        n = ctoi(in, i)         # get a number, ctoi moves "i"
        if (n > 0)              # a number was found here
                eflag = FALSE   #  reset the flag
        if (in(i) != PERIOD)       # stop at EOS
                break
        else {
                i = i+1         # skip past 'dot'
                if (eflag == TRUE)
                        call error("TCS Version number corrupted!.")
                eflag = TRUE    # prohibit consecutive delimiters
        }
}

if (n == 0)
        call error("TCS Version Number corrupted!.")
n = n+1                         # increment version number

i = itoc(n, tmp, 10)            # store the new number
call scopy(tmp, 1, in, ki)
in(ki+i) = EOS

return
end

#-t- incvnum          919  asc  22-oct-81 12:07:32  npg
#-h- putnum           337  asc  22-oct-81 12:09:49  npg
#       putnum - print integer in field width >=w
#               (modeled after putdec page 61 SOFTWARE TOOLS)

subroutine putnum(n, w, file)
        character chars(MAXCHARS)
        integer itoc
        integer i, n, nd, w

        nd = itoc(n, chars, MAXCHARS)
        for (i=nd+1; i<=w; i=i+1)
                call putch(BLANK, file)
        for (i=1; i<=nd; i=i+1)
                call putch(chars(i), file)
        return
end
#-t- putnum           337  asc  22-oct-81 12:09:49  npg
#-h- aputlin         1120  asc  21-jan-82 14:32:36  npg
#-p-
#******************************************************************************
#*
#*
#*                               APUTLIN
#*
#*    author: Neil P Groundwater                       date: 12-MAR-82
#*
#*
#*
#*    Purpose:  call putlin, but start at a (given) offset in the line
#*
#*
#*    Calling convention:   aputlin(str, off, outfd)
#*
#*
#*    Formal Parameters
#*       str:  source text string
#*       off:  offset in string at which to begin output
#*       outfd:  output file-descriptor
#*
#*
#*    Modules called by APUTLIN
#*       putlin
#*
#*
#*    Modules which call APUTLIN
#*       main
#*       setget
#*
#*
#******************************************************************************
#-p-

subroutine aputlin(str, off, outfd)
character str(MAXLINE)
integer off, outfd

character tmplin(MAXLINE)
integer i, j

i = off-1
j = 1                           # start of buffer
repeat {
        i = i+1                 # point TO the char xferred
        tmplin(j) = str(i)
        j = j+1                 # point AFTER the char just xferred
} until ((str(i) == EOS) | (str(i) == NEWLINE))
tmplin(j) = EOS                 # terminate the string
call putlin(tmplin, outfd)

return
end
#-t- aputlin         1120  asc  21-jan-82 14:32:36  npg
#-h- puttag           155  asc  22-oct-81 12:07:33  npg
subroutine puttag( tag )
character tag(20)

include "decls"

call putlin(tag, fdscr)
call putnum(maxver, 1, fdscr)
call putch(NEWLINE, fdscr)
return

end

#-t- puttag           155  asc  22-oct-81 12:07:33  npg
#-h- lineget       1435  asc  22-oct-81 12:24:25  npg
# Ancestry has been established.  Develop the particular version.
# Returns a line-at-a-time to caller.

#integer function lineget (inbuf, passthru)
#character inbuf(MAXLINE)
#integer passthru                        # send text to new-history file
#
#include "defns"
#
#integer bmatch, ctoi2, getlin
#
#integer currnest, i
#
#string sinsert INSERT
#string sendseg ENDSEG
#
#save currnest
#
#repeat {
#        i = getlin(inbuf, fdhis)
#        if (i == EOF)
#                call error("Unexpected EOF on history-data scan.")
#
#        if (bmatch(inbuf, 1, sendseg) != 0) {
#                if (ctoi2(inbuf, KEYSIZ) == 1) {                        # done
#ifdef(GET,        if (passthru == YES) call putlin(inbuf, fdscr) )  # last line
#                        break
#                }
#                if (insert == OFF)
#                        if (ctoi2(inbuf, KEYSIZ) == currnest)
#                                insert = ON
#        } else if (bmatch(inbuf, 1, sinsert) != 0)
#                if (ancestry(ctoi2(inbuf, KEYSIZ)) == YES)
#                        insert = ON
#                else {
#                        # not in one of its ancestors,
#                        # skip to matching ENDSEG line
#                        if (insert == ON) {
#                                currnest = ctoi2(inbuf, KEYSIZ)
#                                insert = OFF
#                        }
#                }
#        else if (bmatch(inbuf, 1, sdelete) != 0) {
#                if (ancestry(ctoi2(inbuf, KEYSIZ)) == YES)
#                        # skip to matching ENDSEG line
#			if (insert == ON)
#				{
#                                currnest = ctoi2(inbuf, KEYSIZ)
#                                insert = OFF
#				}
#        } else
#                if (insert == ON)
#                        return (i)      # text returned in "inbuf"
#
#                      # pass all other lines thru to the output file
#ifdef(GET, if (passthru == YES)
#             {
#             if (flag == INHIST)
#		     {
#                     call puttag(sendseg)
#                     flag = MATCHING
#                     }
#             call putlin(inbuf, fdscr)
#             } )
#}
#
#return (EOF)    # at EOF
#end
#
#-t- lineget       1435  asc  22-oct-81 12:24:25  npg
#-h-  gdate                       169  ascii   05/26/82  14:31:31
## gdate - get current date
subroutine gdate (date)
character date(ARB)
character time (9)
integer now(7)

call getnow (now)
call fmtdat (date, time, now, 0)
return
end
#-t-  gdate                       169  ascii   05/26/82  14:31:31
#-h-  gtime                       168  ascii   05/26/82  14:31:31
## gtime - get current time
subroutine gtime (time)
character time(ARB)
character date(9)
integer now(7)

call getnow (now)
call fmtdat (date, time, now, 0)
return
end
#-t-  gtime                       168  ascii   05/26/82  14:31:31
#-t-  delta.r                   40153  ascii   05/26/82  14:31:48
#-h-  delta.rof                  3171  ascii   04/02/82  17:07:41
.bp 1
.rm 70 
.in 0 
.he 'DELTA (1)'9/14/81'DELTA (1)'
.fo ''-#-' 
.fi 
.in 7 
.ti -7 
NAME 
.br 
delta - make a TCS delta
.sp 1 
.ti -7 
SYNOPSIS 
.br 
delta revision history [newhistory]
.sp 1 
.ti -7 
DESCRIPTION 
.br 
Delta integrates the current "revision" of a file into its
TCS "history" file or into a "newhistory" file.
Differences between this version and the preceeding version are
computed and the TCS file will be able to reproduce either
version (or earlier versions) by means of the GET command.

The user is requested to provide a reason-for-change when
prompted by "History?".
Multiple lines may be entered to describe changes and
terminated by '.' on a line by itself.
.sp 1
.ti -7 
FILES 
.br 
A scratch file is created during processing, then copied onto
the "history".
If a "newhistory" is given, the result will be moved there instead.
.sp 1
.ti -7 
SEE ALSO 
.br 
ADMIN, GET.
.br
"The Source Code Control System, by Marc J. Rochkind,
.ul
IEEE Transactions on Software Engineering,
Vol. SE-1, No. 4, December 1975
.sp
.ti -7
EXAMPLES
.br
delta newversion program.tcs
.in +5
Insert the "newversion" of program into the TCS-maintained history,
kept on "program.tcs" (which was originally created with "admin").
.in -5
.sp
delta newversion program.tcs new.tcs
.in +5
Insert the "newversion" of program into the TCS-maintained history,
but this time put the output on "new.tcs" instead of "program.tcs".
.in -5
.sp
Use "get" to retrieve this, or other versions, from the TCS-maintained
file.
.sp 1 
.ti -7 
DIAGNOSTICS 
.br 
.in +10
.ti -10
Usage: delta revision history [newhistory]
.br 
Correct calling format is provided when called without arguments.

.ti -10
TCS Version Number corrupted.
.ti -10
Unexpected EOF on history-info scan.
.ti -10
Unexpected EOF on history-data scan.
.br
The TCS code seems to be present but garbled.
Refer to a guru.

.ti -10
Sudden death in input
.br 
An end-of-file was detected while requesting the "reason
for change".
 
.ti -10
Revision file is empty
.br 
Perhaps an incorrect filename was given.

.ti -10
History file is empty
.br 
The first formal version is entered by means of the ADMIN
command.

.ti -10
Files are too big to handle
.br 
The DIFF algorithm table-size has been exceeded.
Current version supports files of approximately 15000-lines.

.ti -10
Cannot locate TCS history file.
.br
Unable to read filename specified as the history file.

.ti -10
Temp file error: (filename)
.br
The tempoary file created during processing disappeared unexpectedly.

.in -10
.ti -7 
AUTHORS 
.br 
An Algorithm for Differential File Comparison by J.W.Hunt
and M.D.McIlroy (BTL Computing Science Technical Report #41).
Original code by Wil Baden;
converted from MORTRAN by Dave Murray.
Modifications and conversion to BTL-SCCS style by Neil
Groundwater at Analytic Disciplines Inc.
.sp 1 
.ti -7 
BUGS/DEFICIENCIES 
.br
File permissions are NOT manipluated to restrict users from
disturbing the maintained files.

Version numbering ranges from 1.1 to 1.N where N is a very
large number.
Provision to increment the "primary" number upon demand
is scheduled.

Branching capabilities are scheduled to be implemented.
.br 
#-t-  delta.rof                  3171  ascii   04/02/82  17:07:41
