     TITLE     tol.COM Skeleton
     PAGE      66,96          ;12 pitch
;*************************************************
;
;    tol.COM skeleton -- This program is assembled 
;         into a .COM file and is used to load and
;         execute a Tool from COMMAND.COM under 
;         MSDOS 2.X.  The parameters specifying the 
;         name of the Tool and its .EXE file
;         must be set prior to assembly.
;
;    In progress -- 5/7/84 -- sp, pld
;
;--- symbol definitions ---

;    PSP parameters provided when loaded

env_seg   equ  [2Ch]     ;loc of seg addr env table
fcb_arg1  equ  [5Ch]     ;loc of first arg FCB
fcb_arg2  equ  [6Ch]     ;       second arg FCB
cmd_lth   equ  [80h]     ;loc of cmd line length
cmd_line  equ  [81h]     ;loc of cmd line image

;    DOS function codes

fnc_disp_string equ 9h  ;write string to console
fnc_dos_version equ 30h  ;ask dos version number
fnc_write_handle equ 40h ;write to handle
fnc_shrnk      equ  4Ah  ;free memory
fnc_exec       equ  4Bh  ;execute file
fnc_exit       equ  4Ch  ;terminate process
fnc_getcod     equ  4Dh  ;get exit code

;    DOS function error codes

err_not_found  equ  2    ;file not found

;    Error codes that we return to calling process

err_ctrlbrk    equ  10   ;Control-Break
err_bigline    equ  11   ;Command line too long
err_nopath     equ  12   ;no TOOLPATH= in env
err_unexp      equ  13   ;unexpected function error

;    Miscellaneous

cmd_lmax  equ  106  ;allowed length of cmd line
stacksize equ  50   ;size of local stack
lf        equ  10
cr        equ  13
semicolon equ  59
errout_handle  equ  2


;--- Entry point to tol.COM ---

tolcom    segment
          assume    ds:tolcom, es:tolcom, cs:tolcom, ss:tolcom

     org  100h

begin:
     jmp  start     ;jump around tables

    db "Version {version} {date} {initials}",cr,lf

;--- Tool dependent data tables ---

;tol_cmd is defined at end of code.

tf_name db '\cmtbox'
tf_number db '{small box number}.exe',0
tf_name_end equ this byte
tf_lth    equ  tf_name_end-tf_name
if (tf_lth - 14)	; '\' + 8 + '.' + 3 + EOS
    %out Error in {toolname}.asm:  wrong number of digits in boxname
    endif

;--- Working parameters ---

err_code  db   ?    ;storage for error code
err_msg_addr dw ?   ;storage for pointer to error msg structure
psp_seg   dw   ?    ;PSP segment address
save_sp   dw   ?    ; Save SP across "load & execute" call

dos_version_msg db "requires DOS version 2+",cr,lf,"$"

			; Macro to define error message structure:
msg macro mname,mcode,mtext
     local mstart,mend
     msg_&mname db mcode
                dw mend-mstart
     mstart     db "&mtext&",cr,lf
     mend       equ this byte
     endm

msg too_big,err_bigline,<command line too long>
msg no_toolpath,err_nopath,<no TOOLPATH entry in environment>

msg_cant_load 	db	err_unexp
		dw 	cant_load_msg_end - cant_load_msg_start
	cant_load_msg_start	db	"can't load cmtbox"
	    cant_load_number	db	"{small box number}.exe"
				db	" from TOOLPATH directory",cr,lf
	cant_load_msg_end	equ	this byte

big_tool  db   'BIGTOOLS='	; Strings to compare against
tool_path db   'TOOLPATH='

                    ;Stack is at end of code.

ex_blk    equ  this word
ex_blk_env     dw   ?    ;Execute block, env seg addr
               dw   offset tol_cmd ;ptr to tol_cmd
ex_blk_cmd_seg dw   ?
               dw   fcb_arg1       ;ptr to fcb_arg1
ex_blk_fcb1_seg dw  ?
               dw   fcb_arg2       ;ptr to fcb_arg2
ex_blk_fcb2_seg dw  ?


;--- tol.COM process ---

st0:
     JMP  exit_msg

start:

     MOV  AH,fnc_dos_version  ;check DOS version 2+
     INT  21h
     CMP  AL,2
     JAE  vers_ok
     LEA  DX,dos_version_msg  ;complain
     MOV  AH,fnc_disp_string
     INT  21h
     INT  20h                 ;die

vers_ok:
     MOV  sp,offset stacktop
     MOV  psp_seg,CS     ;save seg address
     MOV  ex_blk_cmd_seg,CS
     MOV  ex_blk_fcb1_seg,CS
     MOV  ex_blk_fcb2_seg,CS

                         ;check cmd_line lgth
     MOV  err_msg_addr,offset msg_too_big
     MOV  BX,cmd_lth
     MOV  AL,[BX]
     CMP  AL,cmd_lmax
     JA   st0

     MOV  CL,AL          ;compute total length
     ADD  tol_cmd,AL

     MOV  CH,0           ;move cmd line to buffer
     INC  CX             ; one extra for carriage return
     CLD
     MOV  SI,cmd_line
     MOV  DI,offset cmd_buf
     JCXZ no_cmd
rep  MOVSB
no_cmd:


     MOV  BX,env_seg     ; locate BIGTOOL= in env
     MOV  DS,[BX]
     assume DS:nothing
     MOV  ex_blk_env,DS	; save environment addr, while we have it.
     MOV  SI,0
     CLD

bigtool_next:
     CMP  byte ptr [SI],0    ;done if no next line
     JE   bigtool_done

     MOV  BX,SI          ;find end of next line
bigtool_skip:
	INC  BX
	CMP  byte ptr [BX],0
	JNE  bigtool_skip

     MOV  DI,offset big_tool ;check if BIGTOOL=
     MOV  CX,9
repe CMPSB
     JE   bigtool_found
     MOV  SI,BX          ; no, go to next line
     INC  SI
     JMP  bigtool_next

bigtool_found:
	lodsw		; See whether 'on' (ignore case)
	call lower
	xchg ah,al
	call lower
	cmp ax,'on'
	jne bigtool_done
			; First two chars match 'on'
	mov ax,'{big box number}'
	xchg ah,al	;   so poke the two filenames.
	mov word ptr cant_load_number,ax
	mov word ptr tf_number,ax	
bigtool_done:


     MOV  err_msg_addr,offset msg_no_toolpath   ; error if not found
     MOV  SI,0
     CLD

st1: CMP  byte ptr [SI],0    ;error exit if no next line
     jne tp_have_entry
	jmp exit_msg
tp_have_entry:

     MOV  BX,SI          ;find end of next line
st2: INC  BX
     CMP  byte ptr [BX],0
     JNE  st2

     MOV  DI,offset tool_path ;check if TOOLPATH=
     MOV  CX,9
repe CMPSB
     JE   st3
     MOV  SI,BX          ; no, go to next line
     INC  SI
     JMP  st1

st3:                     ; Now DS:SI --> actual toolpath
     mov  bx,si          ; Find delimiter after this toolpath
     dec  bx
find_delim:
          inc  bx
          mov  al,[bx]
          cmp  al,0
          je   found_delim
          cmp  al,semicolon
          je   found_delim
          cmp  al,','
          jne  find_delim
found_delim:
     MOV  CX,BX          ;compute string length
     SUB  CX,SI
     jne tp_have
	jmp exit_msg
tp_have:
     MOV  DI,offset tf_path   ;move path to buffer
rep  MOVSB

     MOV  AL,[SI-1]      ; retrieve last path char
     CMP  AL,'\'
     JE   dropsl
     CMP  AL,'/'
     JNE  keepit
dropsl:
     DEC  DI             ; drop trailing (BACK)SLASH
keepit:
                         ; remove other trailing garbage here

                         ; Now DS:SI --> char after toolpath
     push ds
     push si
     MOV  DS,psp_seg
     assume DS:tolcom
     MOV  CX,tf_lth      ;follow path by \file name
     LEA  SI,tf_name
rep  MOVSB
     MOV  byte ptr [DI],0  ; followed by 0 byte


     MOV  BX,offset last_used ;Compute first free paragraph
     ADD  BX,1111b
     RCL  AX,1           ;save carry flag
     MOV  CL,4
     SHR  BX,CL
     RCR  AX,1           ;restore carry flag
     ADC  BX,0

     mov  err_msg_addr,offset msg_cant_load

     MOV  AH,fnc_shrnk   ;release memory for child
     INT  21h
     
     JC   exit_msg       ;check for unexpected error

     mov  save_sp,sp
     MOV  AL,0           ;issue EXEC function
     MOV  DX,offset tf_path
;     MOV  ES,psp_seg
     LEA  BX,ex_blk
     MOV  AH,fnc_exec
     INT  21h
;         returns when tool exits or @ Ctrl-Brk
     assume DS:nothing, ES:nothing, SS:nothing
     cld
     MOV  CX,CS          ;restore segregs
     MOV  DS,CX
     assume DS:tolcom
     CLI
     MOV  SS,CX
     assume SS:tolcom
     MOV  SP,save_sp     ;restore stack
     STI
     MOV  ES,CX
     assume ES:tolcom

     jnc  get_code
     cmp  ax,err_not_found
     jne  exit_msg
     pop  si             ;load failed because not found:
     pop  ds             ;  try another toolpath
     assume ds:nothing
     cmp  byte ptr [si],0
     je   exit_msg       ;no more toolpaths to try
     inc  si             ;step past delimiter
     jmp  st3            ;extract next toolpath

get_code:
     assume ds:tolcom
     MOV  AH,fnc_getcod  ;get error code 
     INT  21h

     CMP  AH,1           ;force code 1 for Ctrl-Brk
     JNE  st4
     MOV  AL,err_ctrlbrk ;  else use exit code
st4: MOV  err_code,AL
     JMP  short exit     ;assume tool gave its own death cry


exit_msg:
     assume DS:nothing, ES:tolcom, SS:tolcom
     MOV DS,psp_seg
     assume DS:tolcom
     MOV SI,err_msg_addr
     LODSB
     MOV err_code,AL
     LODSW
     MOV CX,AX
     MOV BX,errout_handle
     MOV DX,SI
     MOV AH,fnc_write_handle
     INT 21h

exit:
     assume DS:tolcom, ES:tolcom, SS:tolcom
     MOV  AL,err_code         
     MOV  AH,fnc_exit         
     INT  21h                 
;         there is no return  

				; internal routine 'lower'
				; lowers case of char in AL
lower proc near
    cmp al,'A'
    jb lower_end
    cmp al,'Z'
    ja lower_end

    add al,'a'-'A'

lower_end:
    ret
    lower endp

;---  Workspace ---

tol_cmd   db   20             ;command length
          db   '>CMT'         ;4 char signature
tolnm     db   '{toolname}'     ;8 char tool name
tolnmend equ this byte
if (8 - (tolnmend-tolnm))
          db   (8 - (tolnmend-tolnm)) dup (' ')  ; Padding to make 8 characters
    endif
cmd_flgs  db   '@@@@@@@@'     ;8 char flag/address
cmd_buf   equ  this byte      ;cmd_line buffer

tf_path   equ word ptr cmd_buf+cmd_lmax+1 ;buffer for path+name

stacktop  equ  word ptr tf_path+(stacksize*2)

last_used equ word ptr tf_path+(stacksize*2) ;last word used, free space above

tolcom    ends

     end  begin
