.hd input "easy to use semi-formatted input routine" 01/07/83
integer function input (fd, fmt, a1, a2, ...)
file_des fd
packed_char fmt (ARB)   -or-   character fmt (ARB)
untyped a1, a2, ...
.sp
Library:  vswtlb (standard Subsystem library)
.fs
'Input' is an input routine designed for ease of use.  It allows the
user to specify a file from which to read, a format to control input
from the file, and any number of items to be read.  The first argument
is the file descriptor of the file to be used for input.  The second
argument is a format string (discussed below).  The remaining
arguments (zero or more) are items to be input according to format
control.
The function return is the number of items set as a result of
the input request, or EOF if end-of-file was encountered.
.sp
The format string is a PERIOD-terminated packed character string
(such as that generated by the Ratfor "string"p  construct)
or an unpacked, EOS-terminated string
(such as that generated by the "string"s construct).
The format string
contains literal characters which will be output on
the user's terminal if the given input file refers to the terminal
device, and
format control directives consisting of an asterisk
(*) followed by a single lower-case letter describing the input
format for the next item in the argument list.
For a complete description of format control directives, please
see the Reference Manual entry for 'decode'.
.sp
Note that each call to 'input' causes one call to 'getlin' to
read the input text;
the text read is used to fill as many items as possible,
but any remaining text is lost.
This corresponds to BASIC and FORTRAN input procedures.
.sp
When erroneous input is detected, 'input' outputs the incorrect value
to the terminal, discards the rest of the input line,
and requests reentry of the incorrect value from the the terminal.
The user may type in the corrected item and continue normally.
.sp
Literal characters in the format will be ignored if
the file specified by 'fd' is not directed to the terminal.
This feature allows a program to prompt for input from
the terminal, but suppress the prompt for input from a
file.  Note that if no prompting at the terminal is
desired, literal characters should not be included
in the format string.
.sp
A few short examples may clarify the operation of 'input'.
To input two integers, with a prompt, one might use
.sp
.nf
.ti +5
junk = input (STDIN, "Enter i and j:  *i*i"s, i, j)
.fi
.sp
To input an array of double-precision floating point numbers,
one might use
.sp
.nf
.in +5
i = 1
while (input (file, "*d"s, array (i)) ~= EOF) {
   i += 1
   if (i > ARRAY_SIZE)
      call error ("too many numbers to handle"p)
   }
.sp
.fi
.in -5
.im
'Input' outputs prompt characters as it finds them in the format string,
calls 'getlin' to obtain a string of input from the proper file,
and then calls 'decode' to do the actual conversion of as many items
as possible.
Since the design of 'decode' was heavily influenced by the requirements
of 'input', careful reading of the code for both routines is
recommended.
.am
a1, a2, ....
.ca
ctoc, decode, getlin, index, isatty, print, ptoc, putch
.bu
At most ten items may be input.
'Input' depends heavily on the ability of Prime's Fortran to handle
subroutines with varying numbers of arguments.
The ability to buffer some input text to satisfy later calls would
be nice, but is difficult without some static storage.
.sa
print (2), encode (2), decode (2), getlin (2),
conversion routines ('cto?*' and '?*toc') (2)
