.hd gltoc "convert double precision integer to any radix string" 03/23/80
integer function gltoc (int, str, size, base)
long_int int
integer size, base
character str (size)
.sp
Library:  vswtlb (standard Subsystem library)
.fs
'Gltoc' will convert a double precision (32 bit) integer to a
character string representation in any radix from 2 to 16 (inclusive).
The integer to be converted may be considered as either a signed,
two's-complement number with 31 bits of precision, or as an unsigned
number with 32 bits of precision.
.sp
'Int' is the integer to be converted;
'str' is a character array into which the string representation will be
stored;
'size' is the size of 'str'.
The absolute value of 'base' is the conversion radix.  If 'base' is
negative, then 'int' is treated as an unsigned number; otherwise,
'int' is considered to be a signed, two's-complement number.
If the specified radix is not in the range 2:16, then a decimal
conversion is performed.
.sp
For a signed conversion,
if the  integer is less than zero, its absolute value is preceded by
a minus sign in the converted string; a positive number is never
preceded by a sign.
.sp
The function return is the number of characters required to
represent the integer.
.im
'Gltoc' uses a typical divide-and-remainder algorithm to perform
the conversion; that is, a digit is generated by taking the remainder
when the integer is divided by the radix.
For signed conversions, the absolute value of the number is first taken,
the digits generated, and the minus sign inserted if needed.
For unsigned conversions,
the least significant bit of the number is saved, and then
the number is shifted right one bit position
to put it into the precision range of 31 bits (and effectively
dividing the unsigned number by 2).
Then, as each digit value is generated, it is doubled and added to
the carry from the previous digit position (with the initial carry
being the saved least significant bit) and a new carry value is
generated.
.am
str
.sa
gitoc (2), ltoc (2), other conversion routines ('cto?*' and '?*toc') (2)
