# Global macro definitions for code generator


include ARGUMENT_DEFS


define(DB,#)

# Ratfor language extensions:

define(unsigned,integer)
define(ipointer,unsigned)
define(tpointer,unsigned)
define(spointer,unsigned)
define(opointer,unsigned)
define(regset,integer)

# Run time routine id numbers
define(NUM_RTR_IDS,31)
define(rt_shft_int,Rtr_ids(1))
define(rt_shft_long,Rtr_ids(2))
define(rt_shft_uns,Rtr_ids(3))
define(rt_shft_longuns,Rtr_ids(4))
define(lf_shft_int,Rtr_ids(5))
define(lf_shft_long,Rtr_ids(6))
define(v$cilwb_id,Rtr_ids(7))
define(v$vilwb_id,Rtr_ids(8))
define(v$culwb_id,Rtr_ids(9))
define(v$vulwb_id,Rtr_ids(10))
define(v$cllwb_id,Rtr_ids(11))
define(v$vllwb_id,Rtr_ids(12))
define(v$cvlwb_id,Rtr_ids(13))
define(v$vvlwb_id,Rtr_ids(14))
define(v$ciupb_id,Rtr_ids(15))
define(v$viupb_id,Rtr_ids(16))
define(v$cuupb_id,Rtr_ids(17))
define(v$vuupb_id,Rtr_ids(18))
define(v$clupb_id,Rtr_ids(19))
define(v$vlupb_id,Rtr_ids(20))
define(v$cvupb_id,Rtr_ids(21))
define(v$vvupb_id,Rtr_ids(22))
define(v$cirng_id,Rtr_ids(23))
define(v$virng_id,Rtr_ids(24))
define(v$curng_id,Rtr_ids(25))
define(v$vurng_id,Rtr_ids(26))
define(v$clrng_id,Rtr_ids(27))
define(v$vlrng_id,Rtr_ids(28))
define(v$cvrng_id,Rtr_ids(29))
define(v$vvrng_id,Rtr_ids(30))
define(block_copy_id,Rtr_ids(31))

# Where to find global variables:

define (VCG_COMMON,"vcg_com.i")
define (OTG_DEFS,"otg_def.r.i")
define (POWER_COM,"vcg_powers_com.r.i")
define (RTR_COMMON, "vcg_rtrname_com.r.i")



# Assorted flags

define (LONG_REACH,:777)
define (SHORT_REACH,:111)
define (EXTERNAL,:707)
define (INTERNAL,:7070)


# Data types understood at the machine-instruction level:

define (INT_MODE, 1)
define (LONG_INT_MODE, 2)
define (UNS_MODE, 3)
define (LONG_UNS_MODE, 4)
define (FLOAT_MODE, 5)
define (LONG_FLOAT_MODE, 6)
define (STOWED_MODE, 7)


# Size limits for important variables:

define (MAX_TREE_MEMORY, 65000)     # words available for tree storage
define (MAX_INS_MEMORY, 65530)      # words available for inst. storage
define (MAX_STR_MEMORY, 32767)      # words availalbe for string storage
define (MAX_OBJ_MEMORY, 32767)      # words available for obj. descriptors
define (ADDR_DESC_SIZE, 5)          # size of an address descriptor
define (MAX_BREAK_SP, 10)           # max no. of nested 'break'able constructs
define (MAX_CONTINUE_SP, 10)        # max no. of nested continuable constructs
define (MAXARGS,100)                # max no. of args on a proc call
define (MAXCASES,256)               # max no. of cases in a switch


# Intermediate Form (IMF) operators:

define(ADDAA_OP,1)
define(ADD_OP,2)
define(ANDAA_OP,3)
define(AND_OP,4)
define(ASSIGN_OP,5)
define(BREAK_OP,6)
define(CASE_OP,7)
define(COMPL_OP,8)
define(CONST_OP,9)
define(CONVERT_OP,10)
define(DECLARE_STAT_OP,11)
define(DEFAULT_OP,12)
define(DEFINE_DYNM_OP,13)
define(DEFINE_STAT_OP,14)
define(DEREF_OP,15)
define(DIVAA_OP,16)
define(DIV_OP,17)
define(DO_LOOP_OP,18)
define(EQ_OP,19)
define(FOR_LOOP_OP,20)
define(GE_OP,21)
define(GOTO_OP,22)
define(GT_OP,23)
define(IF_OP,24)
define(INDEX_OP,25)
define(INITIALIZER_OP,26)
define(LABEL_OP,27)
define(LE_OP,28)
define(LSHIFTAA_OP,29)
define(LSHIFT_OP,30)
define(LT_OP,31)
define(MODULE_OP,32)
define(MULAA_OP,33)
define(MUL_OP,34)
define(NEG_OP,35)
define(NEXT_OP,36)
define(NE_OP,37)
define(NOT_OP,38)
define(NULL_OP,39)
define(OBJECT_OP,40)
define(ORAA_OP,41)
define(OR_OP,42)
define(POSTDEC_OP,43)
define(POSTINC_OP,44)
define(PREDEC_OP,45)
define(PREINC_OP,46)
define(PROC_CALL_ARG_OP,47)
define(PROC_CALL_OP,48)
define(PROC_DEFN_ARG_OP,49)
define(PROC_DEFN_OP,50)
define(REFTO_OP,51)
define(REMAA_OP,52)
define(REM_OP,53)
define(RETURN_OP,54)
define(RSHIFTAA_OP,55)
define(RSHIFT_OP,56)
define(SAND_OP,57)
define(SELECT_OP,58)
define(SEQ_OP,59)
define(SOR_OP,60)
define(SUBAA_OP,61)
define(SUB_OP,62)
define(SWITCH_OP,63)
define(UNDEFINE_DYNM_OP,64)
define(WHILE_LOOP_OP,65)
define(XORAA_OP,66)
define(XOR_OP,67)
define(ZERO_INITIALIZER_OP,68)
define(FIELD_OP,69)
define(CHECK_RANGE_OP,70)
define(CHECK_UPPER_OP,71)
define(CHECK_LOWER_OP,72)
define(LAST_OPERATOR,CHECK_LOWER_OP)



# Address descriptor structure definition:

define(AD_MODE(ad),ad(1))
   define(DIRECT_AM,1)
   define(INDEXED_AM,2)
   define(INDIRECT_AM,3)
   define(INDIRECT_POSTX_AM,4)
   define(PREX_INDIRECT_AM,5)
   define(ILIT_AM,6)
   define(LLIT_AM,7)
   define(FLIT_AM,8)
   define(DLIT_AM,9)
   define(LABELED_AM,10)
define(AD_BASE(ad),ad(2))
define(AD_OFFSET(ad),ad(3))
define(AD_LABEL(ad),ad(3))
define(AD_RESOLVED(ad),ad(4))
define(AD_APMODE(ad),ad(4))
define(AD_LIT1(ad),ad(2))
define(AD_LIT2(ad),ad(3))
define(AD_LIT3(ad),ad(4))
define(AD_LIT4(ad),ad(5))



# Reach result values:

define(IN_MEMORY,0)
define(IN_ACCUMULATOR,1)



# Argument dispositions:
define(VALUE_DISP,0)
define(REF_DISP,1)



# Argument pointer (AP) information:

define(DONT_STORE_AP,0)
define(STORE_AP,1)
define(NOT_LAST_AP,0)
define(LAST_AP,1)



#     ap definitions for otg

   define (AP_D,0)
   define (AP_DL,1)
   define (AP_DS,2)
   define (AP_DLS,3)
   define (AP_I,4)
   define (AP_IL,5)
   define (AP_IS,6)
   define (AP_ILS,7)


# Machine Registers:

define(PB_REG,:000000)
define(SB_REG,:000001)
define(LB_REG,:000002)
define(XB_REG,:000003)
define(A_REG, :002000)
define(L_REG, :001000)
define(F_REG, :000400)
define(LF_REG,:000200)
define(X_REG, :000100)
define(ALL_REGS,:003703)      # XB is only base reg we care about



# Machine instruction classes:

define(BRANCH_INSTRUCTION,1)
define(MR_INSTRUCTION,2)
define(LABEL_INSTRUCTION,3)
define(GENERIC_INSTRUCTION,4)
define(MISC_INSTRUCTION,5)
define(PSEUDO_INSTRUCTION,6)



# Branch instructions:

define(BCEQ_INS,1)
define(BCGE_INS,2)
define(BCGT_INS,3)
define(BCLE_INS,4)
define(BCLT_INS,5)
define(BCNE_INS,6)
define(BCR_INS,7)
define(BCS_INS,8)
define(BDX_INS,9)
define(BDY_INS,10)
define(BEQ_INS,11)
define(BFEQ_INS,12)
define(BFGE_INS,13)
define(BFGT_INS,14)
define(BFLE_INS,15)
define(BFLT_INS,16)
define(BFNE_INS,17)
define(BGE_INS,18)
define(BGT_INS,19)
define(BIX_INS,20)
define(BIY_INS,21)
define(BLE_INS,22)
define(BLEQ_INS,23)
define(BLGE_INS,24)
define(BLGT_INS,25)
define(BLLE_INS,26)
define(BLLT_INS,27)
define(BLNE_INS,28)
define(BLR_INS,29)
define(BLS_INS,30)
define(BLT_INS,31)
define(BMEQ_INS,32)
define(BMGE_INS,33)
define(BMGT_INS,34)
define(BMLE_INS,35)
define(BMLT_INS,36)
define(BMNE_INS,37)
define(BNE_INS,38)
define(LAST_BRANCH_INSTRUCTION,BNE_INS)



# Generic instructions and pseudo-ops:

define(A1A_INS,1)
define(A2A_INS,2)
define(ARGT_INS,3)
define(CAL_INS,4)
define(CAR_INS,5)
define(CHS_INS,6)
define(CGT_INS,7)
define(CMA_INS,8)
define(CRA_INS,9)
define(CRB_INS,10)
define(CRE_INS,11)
define(CRL_INS,12)
define(CRLE_INS,13)
define(CSA_INS,14)
define(DFCM_INS,15)
define(DRX_INS,16)
define(FCM_INS,17)
define(FDBL_INS,18)
define(FIN_INS,19)
define(FLTA_INS,20)
define(FLTL_INS,21)
define(FRN_INS,22)
define(FSGT_INS,23)
define(FSLE_INS,24)
define(FSMI_INS,25)
define(FSNZ_INS,26)
define(FSPL_INS,27)
define(FSZE_INS,28)
define(IAB_INS,29)
define(ICA_INS,30)
define(ICL_INS,31)
define(ICR_INS,32)
define(ILE_INS,33)
define(INTA_INS,34)
define(INTL_INS,35)
define(IRX_INS,36)
define(LCEQ_INS,37)
define(LCGE_INS,38)
define(LCGT_INS,39)
define(LCLE_INS,40)
define(LCLT_INS,41)
define(LCNE_INS,42)
define(LEQ_INS,43)
define(LF_INS,44)
define(LFEQ_INS,45)
define(LFGE_INS,46)
define(LFGT_INS,47)
define(LFLE_INS,48)
define(LFLT_INS,49)
define(LFNE_INS,50)
define(LGE_INS,51)
define(LGT_INS,52)
define(LINK_INS,53)
define(LLE_INS,54)
define(LLEQ_INS,55)
define(LLGE_INS,56)
define(LLGT_INS,57)
define(LLLE_INS,58)
define(LLLT_INS,59)
define(LLNE_INS,60)
define(LLT_INS,61)
define(LNE_INS,62)
define(LT_INS,63)
define(NOP_INS,64)
define(PIDA_INS,65)
define(PIDL_INS,66)
define(PIMA_INS,67)
define(PIML_INS,68)
define(PROC_INS,69)
define(PRTN_INS,70)
define(RCB_INS,71)
define(S1A_INS,72)
define(S2A_INS,73)
define(SAR_INS,74)
define(SAS_INS,75)
define(SCB_INS,76)
define(SGT_INS,77)
define(SKP_INS,78)
define(SLE_INS,79)
define(SLN_INS,80)
define(SLZ_INS,81)
define(SMI_INS,82)
define(SNZ_INS,83)
define(SPL_INS,84)
define(SRC_INS,85)
define(SSC_INS,86)
define(SSM_INS,87)
define(SSP_INS,88)
define(STEX_INS,89)
define(STPM_INS,90)
define(SVC_INS,91)
define(SZE_INS,92)
define(TAB_INS,93)
define(TAK_INS,94)
define(TAX_INS,95)
define(TAY_INS,96)
define(TBA_INS,97)
define(TCA_INS,98)
define(TCL_INS,99)
define(TFLL_INS,100)
define(TKA_INS,101)
define(TLFL_INS,102)
define(TXA_INS,103)
define(TYA_INS,104)
define(XCA_INS,105)
define(XCB_INS,106)
define(LAST_GENERIC_INSTRUCTION,XCB_INS)



# Memory-reference instructions:

define(ADD_INS,1)
define(ADL_INS,2)
define(ANA_INS,3)
define(ANL_INS,4)
define(CAS_INS,5)
define(CLS_INS,6)
define(DFAD_INS,7)
define(DFCS_INS,8)
define(DFDV_INS,9)
define(DFLD_INS,10)
define(DFLX_INS,11)
define(DFMP_INS,12)
define(DFSB_INS,13)
define(DFST_INS,14)
define(DIV_INS,15)
define(DVL_INS,16)
define(EAL_INS,17)
define(EALB_INS,18)
define(EAXB_INS,19)
define(ERA_INS,20)
define(ERL_INS,21)
define(FAD_INS,22)
define(FCS_INS,23)
define(FDV_INS,24)
define(FLD_INS,25)
define(FLX_INS,26)
define(FMP_INS,27)
define(FSB_INS,28)
define(FST_INS,29)
define(IMA_INS,30)
define(IRS_INS,31)
define(JMP_INS,32)
define(JST_INS,33)
define(JSX_INS,34)
define(JSXB_INS,35)
define(JSY_INS,36)
define(LDA_INS,37)
define(LDL_INS,38)
define(LDLR_INS,39)
define(LDX_INS,40)
define(LDY_INS,41)
define(MPL_INS,42)
define(MPY_INS,43)
define(ORA_INS,44)
define(PCL_INS,45)
define(SBL_INS,46)
define(STA_INS,47)
define(STL_INS,48)
define(STLR_INS,49)
define(STX_INS,50)
define(STY_INS,51)
define(SUB_INS,52)
define(XEC_INS,53)
define(LAST_MR_INSTRUCTION,XEC_INS)



# Miscellaneous instructions and pseudo_ops:

define(ENT_INS,1)
define(ECB_INS,2)
define(ALL_INS,3)
define(IP_INS,4)
define(EXT_INS,5)
define(DATA_INS,6)
define(BSZ_INS,7)
define(LLL_INS,8)
define(ARL_INS,9)
define(LRL_INS,10)
define(AP_INS,11)
define(SHORT_JUMP_AHEAD_INS,12)
define(SHORT_JUMP_LABEL_INS,13)
define(DAC_INS,14)
define(ARS_INS,15)
define(LRS_INS,16)
define(SETUP_OWNER_INS,17)
define(JSXB_EXT_INS,18)
define(EXT_RTR_INS,19)
define(IP_RTR_INS,20)

# Run time routines
define(C$LSHFS,1)
define(C$LSHFL,2)
define(C$RSHFSS,3)
define(C$RSHFSL,4)
define(C$RSHFUS,5)
define(C$RSHFUL,6)
define(V$VVLWB,7)
define(V$CVLWB,8)
define(V$VLLWB,9)
define(V$CLLWB,10)
define(V$VULWB,11)
define(V$CULWB,12)
define(V$VILWB,13)
define(V$CILWB,14)
define(V$VVUPB,15)
define(V$CVUPB,16)
define(V$VLUPB,17)
define(V$CLUPB,18)
define(V$VUUPB,19)
define(V$CUUPB,20)
define(V$VIUPB,21)
define(V$CIUPB,22)
define(V$VVRNG,23)
define(V$CVRNG,24)
define(V$VLRNG,25)
define(V$CLRNG,26)
define(V$VURNG,27)
define(V$CURNG,28)
define(V$VIRNG,29)
define(V$CIRNG,30)
define(V$MOVE$,31)
