# printverboseerrormessage --- print verbose error message

   subroutine printverboseerrormessage

   include SE_COMMON

   select (Errcode)
      when (EBACKWARD)
         call remark ("Line numbers in backward order"p)
      when (ECANTINJECT)
         call remark ("No room for any more lines!"p)
      when (EBADPAT)
         call remark ("Bad syntax in pattern"p)
      when (EBADSTR)
         call remark ("Bad syntax in string parameter"p)
      when (EBADSUB)
         call remark ("Bad syntax in substitution string"p)
      when (ECANTREAD)
         call remark ("File is not readable"p)
      when (ECANTWRITE)
         call remark ("File is not writeable"p)
      when (EEGARB)
         call remark ("Garbage after your command"p)
      when (EFILEN)
         call remark ("Bad syntax in file name"p)
      when (EINSIDEOUT)
         call remark ("Can't move a group into itself"p)
      when (EKNOTFND)
         call remark ("No line has that mark name"p)
      when (E2LONG)
         call remark ("Resultant line too long to handle"p)
      when (ENOMATCH)
         call remark ("No match for pattern"p)
      when (ENOERR)
         call remark ("No error to report"p)
      when (ENOLIMBO)
         call remark ("No lines in limbo"p)
      when (EODLSSGTR)
         call remark ('Expected "<", ">", or nothing after "od"'p)
      when (EORANGE)
         call remark ("Line number out of range"p)
      when (EOWHAT)
         call remark ("Can't recognize option"p)
      when (EPNOTFND)
         call remark ("No line contains that pattern"p)
      when (ESTUPID)
         call remark ("Buffer hasn't been saved"p)
      when (EWHATZAT)
         call remark ("No command recognized"p)
      when (ELINE2)
         call remark ("Last line number beyond end of file"p)
      when (EBREAK)
         call remark ("You interrupted me"p)
      when (ENOPAT)
         call remark ("No saved pattern -- sorry"p)
      when (ENOLIST)
         call remark ("No saved character list -- sorry"p)
      when (ENOFN)
         call remark ("No saved filename"p)
      when (EBADLIST)
         call remark ("Bad syntax in character list"p)
      when (ENONSENSE)
         call remark ("Unreasonable value"p)
      when (ENOHELP)
         call remark ("No help available"p)
      when (EBADLNR)
         call remark ("Line numbers not allowed"p)
      when (EBADTABS)
         call remark ("Bad tabstop syntax"p)
      when (EFEXISTS)
         call remark ("File already exists"p)
      when (EBADCOL)
         call remark ("Improper column number specification"p)
      when (ENOLANG)
         call remark ("Unknown source language"p)
      when (ENOSUB)
         call remark ("No saved replacement -- sorry"p)
      when (EBADUSER)
         call remark ("Bad user identifier"p)
      when (EBUSYUSER)
         call remark ("User is busy -- try again later"p)
      when (ENOSHELL)
         call remark ("Shell returned ERR"p)
      when (ENOCMD)
         call remark ("No saved shell command -- sorry"p)
   else
      call remark ("?"p)

   Errcode = ENOERR

   return
   end
