[cc]mc |
.hd cdmlc "interface to Prime DBMS Cobol DML preprocessor" 08/27/84
[cc]mc
cdmlc <input file>
         [-b [<output file>]]
         [-l [<listing file>]]
         [-z <CDML option>]
.ds
'Cdmlc' serves as the Subsystem interface to the Prime DBMS
Cobol DML preprocessor (CDML).
It examines its option specifications and checks them for consistency,
provides Subsystem-compatible default file names for the listing
and output files as needed, and then produces a
Primos CDML command and causes it to be executed.
.sp
The "-b" option is used to select the name of the file to receive the
output Cobol code from the preprocessor.
If a file name follows the option, then that file receives the output.
If the option is not specified, or no file name follows it, a default
filename is constructed from the input filename by changing its suffix
to ".dcob".
For example, if the input filename is "prog.cob", the output file will be
"prog.dcob";
if the input filename is "foo", the output file will be "foo.dcob".
.sp
The "-l" option is used to select the name of the file to receive the
listing generated by the preprocessor.
If a file name follows the option, then that file receives the listing.
If the "-l" option is specified without a file name following it
or is not specified,
a default filename is constructed from the input filename by changing
its suffix to ".dl".
For example, if the input filename is "gonzo.cob", the listing file will
be "gonzo.dl";
if the input filename is "bar", the listing file will be "bar.dl".
.sp
The input filename must be a disk file name (conventionally
ending in ".cob" or ".cobol").
.sp
In summary, then, the default command line for compiling a file named
"file.cob" is
.sp
.nf
     cdmlc   file.cob  -b file.dcob  -l file.dl
.sp
which corresponds to the CDML command
.sp
     cdml -i *>file.f -b *>file.dcob -l *>file.dl
.sp
.fi
.es
cdmlc file.cob
cdmlc payroll.cob -b b_payroll -l l_payroll
cdmlc funnyprog.cob -z"-newopt"
.me
.in +5
.ti -5
"Usage: cdmlc ..." for invalid option syntax.
.ti -5
"missing input file name" if no input filename could be found.
.ti -5
"<name>: unreasonable input file name" if an attempt was made to read
from the null device or the line printer spooler.
.ti -5
"<name>: unreasonable output file name" if an attempt was made to
output on the terminal or line printer spooler.
.ti -5
"Sorry, the listing file must be a disk file" if the listing
file was directed to a device file.
.ti -5
"Sorry, the output file must be a disk file" if the output
file was directed to a device file.
.in -5
.bu
'Cdmlc' pays no attention to standard ports.

There is no way to avoid getting both a listing and output file.
.sa
[cc]mc |
cobc (1), csubc (1), ddlc (1), cdmlcl (1), ld (1), bind (3)
[cc]mc
