.TH GETAFM 8 "12 April 1987"
.SH NAME
getafm \- have your PostScript device send you an Adobe Font Metrics file for 
PostScript fonts.
.SH SYNOPSIS
.B getafm 
.I fontname [...]
.SH RATIONALE
The situation may arise where your PostScript device knows about fonts that
your host computer is not familiar with. The popular TranScript package 
from Adobe, for example, contains two
important programs, namely \fIenscript(1)\fR and \fIpscat(1)\fR 
(the guts of \fIptroff(1)\fR), 
that demand font metrics 
information in the Adobe Font Metric (AFM) format. (In the case of \fIpscat,\fR
the program \fIpscatmap(8)\fR must be run on the AFM files to produce troff 
width files before use.)
Adobe, however,
only supplies AFM
files for fonts known to the old Apple LaserWriter. Many sites now use the 
LaserWriter Plus, which has more fonts which are not supported with AFM files.
This program gets the AFM files from the LaserWriter Plus or any other 
PostScript device, thereby enabling \fIenscript, pscat, ptroff,\fR or any
other programs demanding access to AFM files to print in any font supported
by the PostScript device.
.SH DESCRIPTION
Each \fIfontname\fR is the full PostScript name of a font for which font
metrics information is desired.
\fIgetafm\fR spools a program written in PostScript to a PostScript device.
This PostScript code has the device write a file in Adobe Font Metric
(AFM) format (see \fIafm(7)\fR) for each \fIfontname\fR indicated on the 
command line to its idea
of standard output, which is certainly NOT the PostScript virtual page, and is
almost definitely the communications line connecting the device to the host.
This information may be read directly off the line, but on most systems data
comming back from a PostScript device is stored in a log file for that device.
If you have a UNIX-type system running TranScript, this will probably be 
/usr/spool/laser/laser-log. The AFM output will come sandwiched between 
appropriate banner lines. The AFM files for each \fIfontname\fR will be sent
sepreately.
.LP
The system administrator should clip these files out (dropping the banner
lines) and install them where 
software needing them will see them. TranScript programs on UNIX-type systems
will look in the directory given by environment variable PSLIBDIR, or
/usr/local/lib/lw by default. An AFM file for a given font should be named
\fIfontname\fR.afm. CAUTION: The control-M characters should 
be removed from AFM files before use.
.LP
\fIgetafm\fR is a Bourne shell script which currently makes use of \fIlpr(1)\fR
to spool the PostScript code, but can be modified easily to use any spooler.
.SH DIAGNOSTICS
Exits with non-zero return code if no fonts are specified on the command
line. Since \fIgetafm\fR makes no
assumptions about the PostScript device it is working with, all other error
checking is done in PostScript. If PostScript cannot find the font requested
it prints an appropriate message in between the banner lines in lieu of an 
AFM file.
.SH FILES
.TP 2.2i
/usr/local/lib/lw/*.afm
font metrics files.
.TP
/usr/spool/laser/laser-log
probable location of log file where \fIgetafm\fR output will be found.
.SH "SEE ALSO"
enscript(1), pscat(1), ptroff(1), troff(1), afm(7), pscatmap(8).
.br
4.2bsd: lpr(1).
.br
System V: lp(1).
.SH CAVEATS
\fIgetafm\fR output has been used by \fIenscript\fR and \fIpscat\fR 
(through the prior application of \fIpscatmap\fR) to produce
excellent looking documents in all the fonts supplied with the Apple 
LaserWriter Plus. There are differences, however, between AFM files produced
by \fIgetafm\fR for the original LaserWriter fonts and the AFM files supplied
by Adobe. These differences are confined to character bounding box information,
on which point there is never agreement between the two files, although the
numbers are always in the same ballpark. The PostScript code spooled by 
\fIgetafm\fR uses empirical methods to determine this information, and it
does so using a technique described in Adobe PostScript documentation. 
Nevertheless, it seems that \fIenscript\fR and \fIpscat\fR are interested 
only in character
width information, about with there is never a discrepancy, so \fIgetafm\fR
is guaranteed to work beautifully with these programs. If other problems are
detected, they should be brought to the attention of the author.
.SH AUTHORS
.nf
Peter Greenberg 
Swarthmore College
Swarthmore, PA 19081
(215) 328-8384 or 8610
UUCP: ...{seismo!bpa | sun!liberty}!swatsun!greenber
.fi
.RE
.SH NOTICES
PostScript and TranScript are trademarks of Adobe Systems Inc. UNIX and 
System V are a trademarks of AT&T-Bell Labs. LaserWriter is a trademark of
Apple Computer Inc. 
.LP
Special thanks to Scott Schwartz for helping with the Bourne shell side of
\fIgetafm.\fR
