.TH UUHOSTS 1L 85/11/04
.SH NAME
uuhosts \- UUCP mail and USENET news information.
.SH SYNOPSIS
.B
uuhosts
hostname ...
.br
.B
uuhosts
-r [ region ]
.SH DESCRIPTION
The \fIuuhosts\fP command is used to look up information about
the configurations of the UUCP mail network and the USENET news network.
.TP
uuhosts \fIhostname\fP ...
for information about a particular UUCP or USENET host or hosts.
The UUCP mail path is given first, followed by the map information.
The USENET map is carried as notations in entries in the UUCP map,
in the lines starting with ``#USENET''.
Any hosts with names for which the argument is a prefix are shown, e.g.:
.TP
uuhosts ut
gets information about all hosts whose names start with ``ut''.
.TP
uuhosts \-r \fIregion\fP
for information about hosts in a (usually geographical) region.
.TP
uuhosts \-r README
gets an introduction to the map.
.TP
uuhosts \-r path.local
gets map information known only locally.
.TP
uuhosts \-r
for a list of known regions.
.TP
uuhosts
with no arguments gets a short usage message.
.PP
Output is broken into pages by the program named in the PAGER environment
variable, or by a default pager set at compile time,
which is usually one of more, pg, or cat,
as appropriate for the host system.
.SH MAINTENANCE
None of these options should be used by the super-user (root).
.TP
uuhosts \-setup
Once "make\ install" has been done for the initial installation,
this option may be used to extract any backlog of \fBUUCPMAPGROUP\fP articles.
Do not run it as root!
Run it as some user in group news.
.TP
maps:UUCPMAPGROUP:F:UUCPMAP/Batch
This line should go in \fBNEWS/sys\fP.
It causes \fIinews\fP(1L) to list the pathnames of incoming articles of
\fBUUCPMAPGROUP\fP in the \fBBatch\fP file.
.TP
uuhosts \-unbatch
This should be called nightly by \fIcron\fP(8) or whatever mechanism is
used to call the USENET \fIexpire\fP(8) command.
It extracts articles from \fBUUCPMAPGROUP\fP which have
come in since the last time it was run.
Do not run it as root!
Run it as some user in group news.
.TP
uuhosts \-x
Extract an individual \fBUUCPMAPGROUP\fP article.
Ordinarily called from \fIuuhosts\fP\ \-\fBunbatch\fP.
.TP
uuhosts \-i
Rebuild the Index file (see below).
Ordinarily called from \fIuuhosts\fP\ \-\fBunbatch\fP.
.SH FILES
.TP
PATHS
UUCP mail path database as produced by \fIpathalias\fP and used by \fInmail\fP
(which is called automatically from \fIsendmail\fP on \fIut\-sally\fP)
It is searched by \fIlook\fP(1), if present, else \fIgrep\fP(1).
The file WHERE is similarly searched, if present:
see \fIuuwhere\fP(1).
.TP
UUCPMAP
UUCP and USENET map information taken from newsgroup \fBUUCPMAPGROUP\fP
(thanks to the UUCP mapping project).
Notices of updates are mailed to \fBpostmaster\fP, which should be an alias
redistributing to the local mail and UUCP administrators.
.TP
UUCPMAP/Index
This index is used to decrease search time on the map about an order
of magnitude.
The search is done by either \fIlook\fP(1) or \fIgrep\fP(1), as above.
.SH SEE ALSO
vnews(1), readnews(1), mail(1), sendmail(8), look(1)
