#include "rv.h"
#include <signal.h>

#ifdef CURSHDR
#include "curshdr.h"
#endif

extern char editlist[256]; /* List of files to edit */

void
ed_init()
/*
 * Initialize access to ed
 */
{
	INT in, out;
	int pipebroke(), alarmring();
	boolean synced = 0;
	char buf[128];

	alarm(RV_TIMEOUT);
	(void) signal(SIGPIPE, pipebroke);
	(void) signal(SIGALRM, alarmring);
	/*
	 * Open pipe streams to ed
	 */
	if ((in = atoi(Argv[1])) <= 0 || (out = atoi(Argv[2])) <= 0)
		panic("Bad pipe descriptors\n\n");
	if ((file.fi_fpin  = fdopen(in , "r")) == NULL ||
	    (file.fi_fpout = fdopen(out, "w")) == NULL)
		panic("Bad fdopen on pipe stream\n\n");

	/*
	 * All versions of ed are not alike.  In particular the format
	 * of error messages widely varies between systems.  (See the
	 * 'H' command in System V).
	 *
	 * Rvi supports three versions of ed: System V, 4bsd, and Cray.
	 * This piece of code attempts to intuit which version of ed we
	 * have here.
	 */

	if (fputs("zzz\n$=\nH\n$=\n", file.fi_fpout) == NULL)
		panic("Cannot write to ed\n\n");
	fflush(file.fi_fpout);

	for (;;) {
		if (fgets(buf, 126, file.fi_fpin) == NULL)
			panic("Cannot read from ed\n\n");
		if (set_debug > 1)
			fprintf(stderr, "1 %s", buf);
		if (synced) {
			if (buf[0] != '?') {
				/*
				 * If the H command is supported
				 */
				file.fi_sysv = TRUE;
				/*
				 * The H command is a toggle.  Force it "on"
				 * if we just toggled it off.
				 */
				if (atoi(buf) != 0 || buf[0] == '0')
					fputs("H\n", file.fi_fpout);
			}
			break;
		}
		if (atoi(buf) != 0 || buf[0] == '0')
			synced = TRUE;
	}

	/* One line of output waiting to be read at this point */

	if (set_debug > 1)
		fprintf(stderr, "sysv=%d\n", file.fi_sysv);

	if (file.fi_sysv) {
		/*
		 * The Cray version of ed is based on SystemV, however
		 * the format of error messages generated by the 'H' command
		 * are not compatible.
		 *
		 *
		 * System V format:
		 *
		 * ?
		 * error message
		 *
		 *
		 * Cray format:
		 *
		 * ? error message
		 *
		 */
		fputs("zzz\nf\n", file.fi_fpout);
		fflush(file.fi_fpout);
		(void) fgets(buf, 126, file.fi_fpin);
		if (set_debug > 1)
			fprintf(stderr, "2 %s", buf);
		/*
		 * Skip last 'H' response
		 */
		if (fgets(buf, 126, file.fi_fpin) == NULL)
			panic("Cannot read from ed\n\n");
		if (set_debug > 1)
			fprintf(stderr, "3 %s", buf);
		if (buf[0] != '?')
			panic("Sync problem in ed_init\n\n");
		if (buf[1] != '\n')
			file.fi_cray = TRUE;
		else {
			(void) fgets(buf, 126, file.fi_fpin);
			if (set_debug > 1)
				fprintf(stderr, "4 %s", buf);
		}
	} else { /* 4.2bsd */
		fputs("f\n", file.fi_fpout);
		fflush(file.fi_fpout);
		(void) fgets(buf, 126, file.fi_fpin);
		if (set_debug > 1)
			fprintf(stderr, "5 %s", buf);
	}

	if (set_debug > 1) 
		fprintf(stderr, "cray=%d\n", file.fi_cray);
	/*
	 * Get current file name (used in syncs)
	 */
	if (fgets(buf, 126, file.fi_fpin) == NULL)
		panic("Cannot read from ed\n\n");
	buf[strlen(buf)-1] = '\0'; /* Strip trailing \n */
	if (buf[0] == '\0' || buf[0] == ' ') { /* If no file name */
		strcpy(buf, "/dev/null");
		fputs("f /dev/null\n", file.fi_fpout);
	}
	if (set_debug > 1)
		fprintf(stderr, "name: %s.\n", buf);
	strcpy(file.fi_name, buf);
	
	alarm(0);
	signal(SIGINT, quit);
	nextfile = editlist;
	if (editlist[0] != '\0')
		edit(NULL);
	else {
		fetch_window(1, TRUE);
		sizemsg();
	}
}

pipebroke()
{
	panic("Broken pipe\n\n");
	/*NOTREACHED*/
}

alarmring()
{
	panic("Connection timed out - ed now has control.\n\n");
	/*NOTREACHED*/
}
	

initialize()
{
	char *s;
	extern char *getenv();

	initscr();
	noecho();
#ifdef CRAY
	nl();
#else
	nonl();
#endif

	scrollok(stdscr, TRUE);
	scrollok(curscr, TRUE);

#ifdef USG
	idlok(stdscr, TRUE);
	idlok(curscr, TRUE);
	cbreak();
	keypad(stdscr, set_timeout ? 1 : 2);

# ifdef CURSHDR
	/*
	 * Kludge - force VT100 terminals to emulate insert/delete line
	 * with scrolling windows.  I think this looks better.  AEK
	 */
	if (SP->term_costs.ilfixed < INFINITY && SP->term_costs.ilfixed > 10)
		SP->term_costs.ilfixed = 10;
# endif CURSHDR
#else
	crmode();
#endif !USG

	/*
	 * Allocate the window buffer
	 */
	nwin_lines = LINES*3+4;
	line_array = (struct li_line *) xalloc(sizeof(struct li_line) * 
		(nwin_lines + 6));
	/*
	 * Kludge: leave two lines unused below line_addr so that pointer
	 * comparisons on segmented architectures (e.g. iAPX286) wont
	 * wrap around to 0xffff
	 */
	line_array += 2;

	rv_finit();

	set_scroll = LINES/2;
	clear();
	ed_init();
	if ((s = getenv("RVINIT")) != NULL)
		rv_linecmd(s);
	refresh();
}
