.TH CC I 15/05/74
.sh NAME
cc \*- C compiler
.sh SYNOPSIS
.bd cc
[
.bd \*-c
] [
.bd \*-p
] [
.bd \-f
] [
.bd \*-O
] [
.bd \*-S
] [
.bd \*-P
] file ...
.sh DESCRIPTION
.it Cc
is the UNIX C compiler.
It accepts three types of arguments:
.s3
Arguments whose names end with `.c' are taken to be
C source programs; they are compiled, and
each object program is left on the file
whose name is that of the source with `.o' substituted
for `.c'.
The `.o' file is normally deleted, however, if a single
C program is compiled and loaded all at one go.
.s3
The following flags are interpreted by
.it cc.
See
.it "ld (I)"
for load-time flags.
.s3
.lp +6 5
\fB\*-c\fR	Suppress the loading phase of the compilation, and force
an object file to be produced even if only one program is compiled.
.s3
.lp +6 5
\fB\*-p\fR	Arrange for the compiler to produce code
which counts the number of times each routine is called;
also, if loading takes place, replace the standard startup
routine by one which automatically calls the
.it monitor
subroutine (III)
at the start and arranges to write out a
.it mon.out
file at normal termination of execution of the object program.
An execution profile can then be generated by
use of
.it prof
(I).
.s3
.lp +6 5
\fB\-f\fR	In systems without hardware floating-point,
use a version of the C compiler which handles floating-point
constants and
loads the object program with the floating-point interpreter.
Do not use if the hardware is present.
.s3
.lp +6 5
\fB\*-O\fR	Invoke an
object-code optimizer.
.s3
.lp +6 5
\fB\*-S\fR	Compile the named C programs, and leave the
assembler-language output on corresponding files suffixed `.s'.
.s3
.lp +6 5
\fB\*-P\fR	Run only the macro preprocessor
on the named C programs, and leave the output on corresponding
files suffixed `.i'.
.i0
.dt
.s3
Other arguments
are taken
to be either loader flag arguments, or C-compatible
object programs, typically produced by an earlier
.it cc
run,
or perhaps libraries of C-compatible routines.
These programs, together with the results of any
compilations specified, are loaded (in the order
given) to produce an executable program with name
.bd a.out.
.sh FILES
file.c		input file
.br
file.o		object file
.br
a.out		loaded output
.br
/tmp/ctm?	temporary
.br
/lib/c[01]	compiler
.br
/lib/fc[01]	floating-point compiler
.br
/lib/c2		optional optimizer
.br
/lib/crt0.o	runtime startoff
.br
/lib/mcrt0.o	runtime startoff of profiling
.br
/lib/fcrt0.o	runtime startoff for floating-point interpretation
.br
/lib/libc.a	C library; see section III.
.br
/lib/liba.a	Assembler library used by some routines in libc.a
.sh "SEE ALSO"
``Programming in C\(em a tutorial,''
C Reference Manual,
monitor (III), prof (I), cdb (I), ld (I).
.sh DIAGNOSTICS
The diagnostics produced by C itself are intended to be
self-explanatory.
Occasional messages may be produced by the assembler
or loader.
Of these, the most mystifying are from the assembler,
in particular ``m,'' which means
a multiply-defined external symbol (function
or data).
.sh BUGS
