'''
''' @(#) guide.man	1.2 (TDI) 2/3/87
''' This file is part of UNaXcess Conferencing 1.0.2.
'''
.TH UA LOCAL UNaXcess
.ds U \fBUNaXcess\fR
.SH NAME
ua \- the \*U multi-user conferencing system
.SH SYNOPSIS
ua [\fI``username''\fB]
.SH DESCRIPTION
The \*U conferencing system is a multi-user BBS-style message system.
Currently it supports any number of user-created
.B conferences
on any subjects, and a file up/download library with any number of branches.
.P
\*U may be run from the shell or as a UNIX(R) login.  As a login shell, it
prompts for a user name and a password (if applicable).  There are usually
some special user names, such as 
.I new
and 
.IR GUEST .
The user name 
.I off
exits to the 
.B login:
prompt.  From the shell, a user may specify his user name in quotes (to
protect spaces and special characters from the shell); or, if hir \*U user
name is the same as hir UNIX login name, s/he will be logged in to \*U
directly.
.P
Once logged in, the user is shown the latest bulletins, then any new messages
and new or deleted conferences are shown, followed by the main command prompt.
This prompt shows the current conference and the time remaining (if time
limits are imposed), followed by the prompt
.sp
.ce
Command (? for help):
.sp
At this point, any of the \*U commands may be entered; see the 
.B COMMANDS
section of this manual for more details.
.SH "NEW USERS"
The user name 
.I new
is most often used to register new users.  A new user will be shown the new
user bulletin (separate from the standard bulletins), and will be asked if
s/he still wants to become a user.  If so, s/he will be asked a series of
questions for registration purposes:  hir full name, preferred password, full
address, and phone number.  If s/he has a standard UNIX login, s/he will be
asked to supply it; this simplifies the sysop's checking for potential
system-level access (see 
.B "ACCESS MODES"
below).  Depending on the system, the new user will either be logged out or
permitted to use the system.
.SH COMMANDS
\*U has three menus:  the
.BR "Main Menu" ,
the
.BR "Message Base Menu" ,
and the
.BR "Administration Menu" .  Each menu has two levels of help; entering a
question mark (?) once displays the short help message, pressing it a second
time displays a full help file.
.SH "1. The Main Menu"
The following commands are available on the Main Menu:
.de LS
.in +10
.ll -5
.sp
.ns
..
.de LI
.sp
.ti -5
\fB\\$1\fR \-
..
.de LE
.sp
.in -10
.ll +5
.ns
..
.LS
.LI A
Enter the Administration Menu.  See the
.B "Administration Menu"
below for details.
.LI B
Redisplay the new bulletins.  Between each bulletin, the user is asked whether
s/he wishes to Continue reading bulletins or Stop.
.LI C
For users with System access (see
.B "ACCESS LEVELS"
below), this command starts up a shell.  Unfortunately, this command doesn't
work so well from a \*U login "shell"; the user's UNIX permissions are those
of the UNIX login.
.LI D
Change the default conference.  Each user has a ``default'' conference
which s/he automatically joins when s/he logs in.  For new users, this is set
to the
.I general
conference, but the D command allows a user to change this.
.LI F
Enter the File UDL area.  Users with File UDL access (see
.B "ACCESS MODES"
below) can upload and download files; other users may only look at the UDL
library.  See
.B "THE FILE UDL AREA"
below for more information.
.LI G
Exit \*U.  Shell users will be returned to thatever they were doing
before they entered \*U; others will be returned to the
.B "login:"
prompt.
.sp
If the Main Menu is entered from the Message Loop (see the
.BR "Message Base Menu" ),
the G command returns the user to the Message Loop.
.LI M
Enter the Message Base Menu.  See below for details.
.LI W
Show the \*U user log.  This shows the user name and access level of each
user; Fairwitnesses (see
.B "THE FAIRWITNESS"
below) can also see the address and phone number for validation purposes.
.LE
.SH "2. The Message Base Menu"
The primary message base commands are contained on this menu.  The commands
are:
.LS
.LI D
Change the default conference.  Each user has a ``default'' conference
which s/he automatically joins when s/he logs in.  For new users, this is set
to the
.I general
conference, but the D command allows a user to change this.
.LI E
Enter a message.  The user is prompted for the recipient, the message's
subject, and the conference to which the message should be posted.  (The
current conference is the default.)  S/he may also be asked whether the
message is to be private or not; the default is no.  Private messages may not
be enabled on all \*U systems, and if they are, they may only be sent to
existing users.  The user is then placed in the message editor, which
automatically word-wraps the message.  Any of CONTROL-D (the standard UNIX
end-of-message indicator), CONTROL-Z (the end-of-file indicator for some
microcomputer systems), or ESCAPE will end the message and display the Send
prompt.  At this point the user may choose to continue the message, edit it,
list it, send it, or abort it.  S/he is asked for confirmation if s/he chooses
to abort the message.
.LI G
Exit \*U.  Shell users will be returned to thatever they were doing
before they entered \*U; others will be returned to the
.B "login:"
prompt.
.sp
If the Main Menu is entered from the Message Loop (see the
.BR "Message Base Menu" ),
the G command returns the user to the Message Loop.
.LI I
Display the index of conferences.  For each conference, the name, number of
messages, and number of messages read by the current user are shown; if the
conference is restricted, this fact is noted.  If the user is unsubscribed
from the conference, this will also be shown.
.LI J
Join a different conference, or create a new conference.  The user is prompted
for the conference to join; if it doesn't exist, s/he is asked if s/he wants
to create it.  If so, s/he is placed in the Message Editor to compose a
message describing the conference's purpose.
.sp
If the conference is restricted and the user is not a member, s/he will be
informed of the fact and returned to the Message Base Menu.
.sp
If the user is unsubscribed, s/he will be asked if s/he wishes to resubscribe
to the conference.  If not, s/he will be returned to the Message Base Menu.
See the
.B U
command for more details.
.sp
A conference name can be up to at least 14 characters in length; on Berkeley
UNIX systems, it may be up to 32 characters in length.  It may not contain
colons or slashes; these will be converted to dots.  Case is not significant
in a conference name.
.LI K
Kill a message.  The user must be the owner or recipient of the message, or a
Fairwitness, to kill a message.  S/he will be prompted for the message number
to kill.  Only messages in the current conference can be killed.
.LI N
Read all new messages in all conferences.  Unsubscribed conferences and
restricted conferences of which the user is not a member are skipped
silently.  This command works like the R command in the 
.B "Read Commands Menu"
in the New mode (see below) within each conference; between conferences the
user is asked whether s/he wishes to go to the Next conference, Unsubscribe
from the current conference (see below) or Stop.
.LI R
Enter the Read Commands Menu.  See below for more details.
.LI U
Unsubscribe from a conference.  New messages in the conference will not be
noted at login, and the conference will be skipped during an N command; the
user must Join the conference (J command) in order to resubscribe.
.LI X
Return to the Main Menu.
.LI ?
This shows the help menu, similarly to the Main Menu's help command.
.LE
.SH "3. The Read Commands menu"
This menu contains the read commands, all of which work in the same basic
way.  Each command asks whether the user wishes to read Forward (F), Reverse
(R), an Individual message (I), or all New messages (N).  If the user chooses
F or R, s/he will be asked for the first and last messages to read; the
defaults are message 1 and the last message in the conference.  If s/he
chooses I, s/he will be asked for the message number to read.  If s/he chooses
the N command, s/he will be shown all messages posted since s/he last read the
messages in that conference in ascending (chronological) order.  Only the
messages in the current conference can be read.
.P
The commands are:
.LS
.LI G
Exit \*U.  Shell users will be returned to thatever they were doing
before they entered \*U; others will be returned to the
.B "login:"
prompt.
.sp
If the Main Menu is entered from the Message Loop (see the
.BR "Message Base Menu" ),
the G command returns the user to the Message Loop.
.LI N
Read all new messages.  This command is identical to the N command of the
.B "Message Base Menu"
and is placed here for the user's convenience.
.LI Q
Quick scan of messages.  Only the subjects of messages are shown.
.LI R
Read messages.  The full text of each message is shown.
.LI S
Scan messages.  Only the headers of messages are shown.
.LI X
Return to the
.BR "Message Base Menu" .
.LE
After each message read by the N or R commands, the user is placed in the
.BR "Read Loop" .
From this mini-menu, the following commands are available:
.LS
.LI C
Continue to the next message.
.LI S
Stop reading messages; from the R command, the user is returned to the Read
Menu; from the N command the user is sent to the Next Conference/Stop prompt.
(See the N command above.)
.LI K
Kill the current message.  Only the sender or recipient of a message, or a
Fairwitness, may Kill a message.
.LI U
Unsubscribe from the current conference.  From the N command, the user is sent
to the Next Conference/Stop prompt; from the R command, s/he is returned to
the Read Commands Menu.
.LI R
Reply to the current message.  The user is asked for the conference to which
the reply should be directed (the default is the conference containing the
message).  On some \*U systems, the user will be asked whether the message is
private or not; the default is the privacy status of the original message.
.LI E
Enter a new message.  This functions identically to the E command of the
.BR "Message Base Menu" ,
save that the message will be placed by default into the conference from which
the E subcommand is entered.
.LI X
eXecute.  The user will be placed in the Main Menu, with a changed prompt:
.sp
.ce
Command (? for help, G to return):
.sp
The G command, rather than exiting \*U, will return the user to the Read Loop.
.LE
.SH "4. The Administration Menu"
The Administration Menu contains commands useful for \*U system
administration.  Some of the commands are duplicated on the
.BR "Main Menu" ,
and some are usable by ordinary users.  The commands are:
.LS
.LI A
Alter a user.  If the current user is a Fairwitness, see the
.B "UNaXcess Administrator's Manual"
for details on usage.
.sp
Ordinary users may only alter themselves, and only certain parameters:  their
password, line length, or screen size.  The subcommands available to ordinary
users are:
.LS
.LI P
Change the user's password.  The user is prompted to enter a new password of
between 3 and 8 characters.
.LI S
Change the line Size (line length).  The user is prompted for a new line
length of between 40 and 132 characters.  The default line length is 80,
suitable for use on a standard terminal.
.LI L
Change the Lines per screen.  The user is prompted for a new screen size of
between 0 and 66.  A value of 0 disables all display paging and is useful on
hardcopy terminals such as the TI "Silent 700"(TM).
.LE
.SH "ACCESS LEVELS"
There are 5 standard access levels in \*U.  They are:
.LS
.LI Guest
The Guest access level permits a user to read messages in any non-restricted
conference; however, the user may not use the C command, upload or download
files, or enter messages except in the 
.I guest
conference, if it exists.
.LI Messages
The Messages access level permits a user to read or enter messages in
non-restricted conferences.  S/he may not use the C command or upload or
download files.
.LI "File UDL"
The File UDL access level allows a user to upload or download files.  The C
command is still off limits, however.
.LI System
The System access level allows a user too use the C command to get a shell.
The shell will have the permissions of the user who ran \*U; from a shell
prompt, it will be that of the currently-logged-in user, but from a \*U
login "shell" it will be that of the UNIX(R) user owning that login.
.LI Fairwitness
A Fairwitness is a special user, as described previously.  A Fairwitness may
read or kill any message in any conference, including restricted conferences.
However, a Fairwitness must be a member of a restricted conference in order to
change the membership list for that conference.  S/he may also create and post
messages to Read-Only conferences on some systems;  this permits the creation
of truly moderated forums.
.LI Sysop
The sysop is a very special user indeed; no restrictions whatsoever apply to
hir.  S/he is the only user permitted to restrict or de-restrict a conference,
or to promote or demote Fairwitnesses.
.LE
.SH "THE FAIRWITNESS"
It should be obvious by now that the Fairwitness is not intended to be simply
an assistant sysop.  S/he is, in fact, intended to be a discussion leader;
s/he is in charge of a conference or a group of conferences, and has a
responsibility to stimulate discussion in those conferences.  The means of
doing this are to condense and recap previously posted messages, to point out
possibly-obscure relationships between the current topic and other topics, and
to ask questions designed to stimulate discussion.  A good Fairwitness can
make or break a conference.
.P
The original idea of a Fairwitness came from the CommuniTree Group, a
non-profit organization in California.  This group pioneered the conferencing
BBS system via their "Conference Tree" program.  They lifted the Fairwitness
from the novel
.I "STRANGER IN A STRANGE LAND"
by Robert A. Heinlein -- but with some major differences.  The CommuniTree
Group's guidelines for a Fairwitness are preserved intact in \*U.  Their
intent was the evolution of a new kind of BBS system:  a system designed to
stimulate creative and critical thinking, rather than a literal electronic
"bulletin board", classified-ad, or "dial-your-match" kind of system.  As a
former Fairwitness of the now-defunct Conference Tree #1085, the Great North
CommuniTree, I stand by their aims, and hope that \*U will help to fulfill
them.
.SH "THE FILE UDL AREA"
The File UDL area is arranged as a "library" consisting of multiple
"branches".  Each "branch" (hopefully) contains files to be downloaded, and
has an upload area.  The branches are usually set up by subject or by
computer.
.P
On entry to the File UDL area, the user is shown a list of branches and is
prompted to select a branch.  After selecting one, s/he enters the File UDL
Menu, consisting of the following commands:
.LS
.LI U
Upload a file to the current branch.  The user is asked for a file name, a
description, and an upload method.
.LI D
Download a file from the current branch.  The user is asked for a file name
and a download method.
.LI L
Display a list of the files in the current branch.
.LI G
Download a list of the files in the current branch.  Any user may execute this
function, regardless of access level.  The user is asked for the download
method desired.
.LI E
Redisplay the list of File UDL branches.
.LE
\*U supports three file transfer protocols:
.LS
.LI Xmodem
The "standard" file transfer method, also known as "MODEM7" or "Ward
Christensen" protocol.
.LI Kermit
The micro-to-mainframe file transfer method developed at Columbia University.
The Kermit program is in the public domain, and is available from Columbia
University directly and from many BBSes across the country.
.LI ASCII
As a lowest common denominator, straight ASCII transfer is available.  No
error checking is performed, and it is not advised to send or receive binary
data.  An ASCII upload is terminated with a CONTROL-D.
.LE
Not all transfer methods may be available on all systems (although they should
be; public-domain implementations of Xmodem and Kermit are freely available).
The ASCII method is guaranteed to be available.
.P
Uploaded files are not automatically placed in the download area of a branch;
a Fairwitness must move them there.  This makes possible
checking for "trojan horse" programs.
.SH "RESTRICTED CONFERENCES"
The sysop may choose to restrict a conference.  This limits access to a
conference to the sysop, all Fairwitnesses, and any users listed as members of
the conference, making possible special interest groups (SIGs), users'
groups, etc.
.P
Only the sysop may restrict or remove restrictions on a conference.  While any
Fairwitness may read, enter, or kill messages within a restricted conference,
s/he may only add or delete members if s/he is listed as a member of the
conference hirself.
.P
A user attempting to Join a restricted conference will not be permitted to do
so if s/he is not a member.  Restricted conferences will automatically be
skipped by the N command of the Message Base Menu if the user is not a member
of the conference.
.SH "ACKNOWLEDGEMENTS AND COPYRIGHTS"
UNIX(R) is a registered trademark of AT&T.
.sp
TI(R) and "Silent 700"(R) are registered trademarks of Texas Instruments.
.sp
Kermit is a trademark of Columbia University.
.sp
"Berkeley UNIX" is Fourth Berkeley Standard Distribution UNIX, copyrighted by
the Regents of the University of California.
.SH AUTHOR
.nf
Brandon S. Allbery
6615 N. Center St., Apt. A1-105
Mentor, Ohio 44060-4101

Phone: +01 215 974 9210

Net address: cbatt!cwruecmp!ncoast!allbery
ARPA address: ncoast!allbery%Case.CSNET@CSNet-Relay
.fi
