# VAPPLI- MAIN VERB PROCESSING ROUTINE
#
# DECLARATIONS
#
	LOGICAL FUNCTION VAPPLI(RI)
	IMPLICIT INTEGER (A-Z)
	LOGICAL LIT,OBJACT
	LOGICAL QEMPTY,RMINFO,CLOCKD
	LOGICAL QOPEN,EDIBLE,DRKBLE
	LOGICAL TAKE,PUT,DROP,WALK
	LOGICAL QHERE,SVERBS,FINDXT,OAPPLI,F
#
# PARSER OUTPUT
#
	LOGICAL PRSWON
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/	MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
			LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
	COMMON /STAR/ MBASE,STRBIT
#
# ROOMS
#
	COMMON /ROOMS/	RLNT,RDESC2,RDESC1(215),REXIT(215),
			RACTIO(215),RVAL(215),RFLAG(215)
	INTEGER RRAND(215)
	EQUIVALENCE (RVAL,RRAND)
#
	COMMON /RFLAG/	RSEEN,RLIGHT,RLAND,RWATER,RAIR,
			RSACRD,RFILL,RMUNG,RBUCK,RHOUSE,RNWALL,REND
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1	
	COMMON /RINDEX/ MGRAT,MAZ15	
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF	
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU	
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
# EXITS
#
	COMMON /XSRCH/	XMIN,XMAX,XDOWN,XUP,
			XNORTH,XSOUTH,XENTER,XEXIT
#
# OBJECTS
#
	COMMON /OBJCTS/	OLNT,ODESC1(250),ODESC2(250),ODESCO(250),
			OACTIO(250),OFLAG1(250),OFLAG2(250),OFVAL(250),
			OTVAL(250),OSIZE(250),OCAPAC(250),OROOM(250),
			OADV(250),OCAN(250),OREAD(250)
#
	COMMON /OFLAGS/	VISIBT,READBT,TAKEBT,DOORBT,TRANBT,FOODBT,
			NDSCBT,DRNKBT,CONTBT,LITEBT,VICTBT,BURNBT,FLAMBT,
			TOOLBT,TURNBT,ONBT
	COMMON /OFLAGS/	FINDBT,SLEPBT,SCRDBT,TIEBT,CLMBBT,ACTRBT,
			WEAPBT,FITEBT,VILLBT,STAGBT,TRYBT,NOCHBT,OPENBT,
			TCHBT,VEHBT,SCHBT
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# ADVENTURERS
#
	COMMON /ADVS/	ALNT,AROOM(4),ASCORE(4),AVEHIC(4),
			AOBJ(4),AACTIO(4),ASTREN(4),AFLAG(4)
#
	COMMON /AINDEX/ PLAYER,AROBOT,AMASTR
#
# VERBS
#
	COMMON /VINDEX/ CINTW,DEADXW,FRSTQW,INXW,OUTXW
	COMMON /VINDEX/ WALKIW,FIGHTW,FOOW
	COMMON /VINDEX/ MELTW,READW,INFLAW,DEFLAW,ALARMW,EXORCW
	COMMON /VINDEX/ PLUGW,KICKW,WAVEW,RAISEW,LOWERW,RUBW
	COMMON /VINDEX/ PUSHW,UNTIEW,TIEW,TIEUPW,TURNW,BREATW
	COMMON /VINDEX/ KNOCKW,LOOKW,EXAMIW,SHAKEW,MOVEW,TRNONW,TRNOFW
	COMMON /VINDEX/ OPENW,CLOSEW,FINDW,WAITW,SPINW,BOARDW,UNBOAW,TAKEW
	COMMON /VINDEX/ INVENW,FILLW,EATW,DRINKW,BURNW
	COMMON /VINDEX/ MUNGW,KILLW,ATTACW,SWINGW
	COMMON /VINDEX/ WALKW,TELLW,PUTW,DROPW,GIVEW,POURW,THROWW
	COMMON /VINDEX/ DIGW,LEAPW,STAYW,FOLLOW
	COMMON /VINDEX/ HELLOW,LOOKIW,LOOKUW,PUMPW,WINDW
	COMMON /VINDEX/ CLMBW,CLMBUW,CLMBDW,TRNTOW
#
# FUNCTIONS AND DATA
#
	QOPEN(R)=AND(OFLAG2(R),OPENBT).NE.0
	EDIBLE(R)=AND(OFLAG1(R),FOODBT).NE.0
	DRKBLE(R)=AND(OFLAG1(R),DRNKBT).NE.0
	DATA MXNOP/49/,MXSMP/99/

# VAPPLI, PAGE 2
#
	VAPPLI=.TRUE.				#ASSUME WINS.
	IF((PRSO.NE.0).and.(prsa.ne.142)) ODO2=ODESC2(PRSO)#SET UP DESCRIPTORS.
	IF(PRSI.NE.0) ODI2=ODESC2(PRSI)
	AV=AVEHIC(WINNER)
	RMK=372+RND(6)				#REMARK FOR HACK-HACKS.
#
	IF(RI.EQ.0) GO TO 10			#ZERO IS FALSE.
	IF(RI.LE.MXNOP) RETURN			#NOP?
	IF(RI.LE.MXSMP) GO TO 100		#SIMPLE VERB?
	GO TO (18000,20000,
	        22000,22999,24000,25000,26000,27000,28000,29000,30000,
	  31000,32000,33000,34000,35000,36000,      38000,39000,40000,
	  41000,42000,43000,44000,45000,46000,47000,48000,49000,50000,
	  51000,52000,53000,      55000,56000,      58000,59000,60000,
	              63000,64000,65000,66000,      68000,69000,70000,
	  71000,72000,73000,74000,            77000,78000,
	  80000,81000,82000,83000,84000,85000,86000,87000,88000),
	 	(RI-MXSMP)
	CALL BUG(7,RI)
#
# ALL VERB PROCESSORS RETURN HERE TO DECLARE FAILURE.
#
10	VAPPLI=.FALSE.				#LOSE.
	RETURN
#
# SIMPLE VERBS ARE HANDLED EXTERNALLY.
#
100	VAPPLI=SVERBS(RI)
	RETURN

# VAPPLI, PAGE 3
#
# V100--	READ.  OUR FIRST REAL VERB.
#
18000	IF(LIT(HERE)) GO TO 18100		#ROOM LIT?
	CALL RSPEAK(356)			#NO, CANT READ.
	RETURN
#
18100	IF(PRSI.EQ.0) GO TO 18200		#READ THROUGH OBJ?
	IF(AND(OFLAG1(PRSI),TRANBT).NE.0) GO TO 18200
	CALL RSPSUB(357,ODI2)			#NOT TRANSPARENT.
	RETURN
#
18200	IF(AND(OFLAG1(PRSO),READBT).NE.0) GO TO 18300
	CALL RSPSUB(358,ODO2)			#NOT READABLE.
	RETURN
#
18300	IF(.NOT.OBJACT(X)) CALL RSPEAK(OREAD(PRSO))
	RETURN
#
# V101--	MELT.  UNLESS OBJECT HANDLES, JOKE.
#
20000	IF(.NOT.OBJACT(X)) CALL RSPSUB(361,ODO2)
	RETURN
#
# V102--	INFLATE.  WORKS ONLY WITH BOATS.
#
22000	IF(.NOT.OBJACT(X)) CALL RSPEAK(368)	#OBJ HANDLE?
	RETURN
#
# V103--	DEFLATE.
#
22999	IF(.NOT.OBJACT(X)) CALL RSPEAK(369)	#OBJ HANDLE?
	RETURN

# VAPPLI, PAGE 4
#
# V104--	ALARM.  IF SLEEPING, WAKE HIM UP.
#
24000	IF(AND(OFLAG2(PRSO),SLEPBT).EQ.0) GO TO 24100
	VAPPLI=OBJACT(X)			#SLEEPING, LET OBJ DO.
	RETURN
#
24100	CALL RSPSUB(370,ODO2)			#JOKE.
	RETURN
#
# V105--	EXORCISE.  OBJECTS HANDLE.
#
25000	F=OBJACT(X)				#OBJECTS HANDLE.
	RETURN
#
# V106--	PLUG.  LET OBJECTS HANDLE.
#
26000	IF(.NOT.OBJACT(X)) CALL RSPEAK(371)
	RETURN
#
# V107--	KICK.  IF OBJECT IGNORES, JOKE.
#
27000	IF(.NOT.OBJACT(X)) CALL RSPSB2(378,ODO2,RMK)
	RETURN
#
# V108--	WAVE.  SAME.
#
28000	IF(.NOT.OBJACT(X)) CALL RSPSB2(379,ODO2,RMK)
	RETURN
#
# V109,V110--	RAISE, LOWER.  SAME.
#
29000	CONTINUE
30000	IF(.NOT.OBJACT(X)) CALL RSPSB2(380,ODO2,RMK)
	RETURN
#
# V111--	RUB.  SAME.
#
31000	IF(.NOT.OBJACT(X)) CALL RSPSB2(381,ODO2,RMK)
	RETURN
#
# V112--	PUSH.  SAME.
#
32000	IF(.NOT.OBJACT(X)) CALL RSPSB2(382,ODO2,RMK)
	RETURN

# VAPPLI, PAGE 5
#
# V113--	UNTIE.  IF OBJECT IGNORES, JOKE.
#
33000	IF(OBJACT(X)) RETURN			#OBJECT HANDLE?
	I=383					#NO, NOT TIED.
	IF(AND(OFLAG2(PRSO),TIEBT).EQ.0) I=384	#NOT TIEABLE.
	CALL RSPEAK(I)
	RETURN
#
# V114--	TIE.  NEVER REALLY WORKS.
#
34000	IF(AND(OFLAG2(PRSO),TIEBT).NE.0) GO TO 34100
	CALL RSPEAK(385)			#NOT TIEABLE.
	RETURN
#
34100	IF(.NOT.OBJACT(X)) CALL RSPSUB(386,ODO2) #JOKE.
	RETURN
#
# V115--	TIE UP.  NEVER REALLY WORKS.
#
35000	IF(AND(OFLAG2(PRSI),TIEBT).NE.0) GO TO 35100
	CALL RSPSUB(387,ODO2)			#NOT TIEABLE.
	RETURN
#
35100	I=388					#ASSUME VILLAIN.
	IF(AND(OFLAG2(PRSO),VILLBT).EQ.0) I=389
	CALL RSPSUB(I,ODO2)			#JOKE.
	RETURN
#
# V116--	TURN.  OBJECT MUST HANDLE.
#
36000	IF(AND(OFLAG1(PRSO),TURNBT).NE.0) GO TO 36100
	CALL RSPEAK(390)			#NOT TURNABLE.
	RETURN
#
36100	IF(AND(OFLAG1(PRSI),TOOLBT).NE.0) GO TO 36200
	CALL RSPSUB(391,ODI2)			#NOT A TOOL.
	RETURN
#
36200	VAPPLI=OBJACT(X)			#LET OBJECT HANDLE.
	RETURN
#
# V117--	BREATHE.  BECOMES INFLATE WITH LUNGS.
#
38000	PRSA=INFLAW
	PRSI=LUNGS
	GO TO 22000				#HANDLE LIKE INFLATE.
#
# V118--	KNOCK.  MOSTLY JOKE.
#
39000	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	I=394					#JOKE FOR DOOR.
	IF(AND(OFLAG1(PRSO),DOORBT).EQ.0) I=395
	CALL RSPSUB(I,ODO2)			#JOKE FOR NONDOORS TOO.
	RETURN
#
# V119--	LOOK.
#
40000	IF(PRSO.NE.0) GO TO 41500		#SOMETHING TO LOOK AT?
	VAPPLI=RMINFO(.TRUE.)			#HANDLED BY RMINFO.
	RETURN
#
# V120--	EXAMINE.
#
41000	IF(PRSO.NE.0) GO TO 41500		#SOMETHING TO EXAMINE?
	VAPPLI=RMINFO(.FALSE.)			#HANDLED BY RMINFO.
	RETURN
#
41500	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	I=OREAD(PRSO)				#GET READING MATERIAL.
	IF(I.EQ.0) I=429			#DEFAULT IF NO READING.
	CALL RSPSUB(I,ODO2)			#PROCESS.
	PRSA=FOOW				#DEFUSE ROOM PROCESSORS.
	RETURN
#
# V121--	SHAKE.  IF HOLLOW OBJECT, SOME ACTION.
#
42000	IF(OBJACT(X)) RETURN			#OBJECT HANDLE?
	IF(AND(OFLAG2(PRSO),VILLBT).EQ.0) GO TO 42100
	CALL RSPEAK(371)			#JOKE FOR VILLAINS.
	RETURN
#
42100	IF(QEMPTY(PRSO)) GO TO 10		#EMPTY?  FAILS.
	IF(QOPEN(PRSO)) GO TO 42300		#OPEN?  SPILL.
	CALL RSPSUB(396,ODO2)			#NO, DESCRIBE NOISE.
	RETURN
#
42300	DO I=1,OLNT {				#SPILL CONTENTS.
	  IF(OCAN(I).EQ.PRSO) {			#INSIDE?
	    CALL NEWSTA(I,0,HERE,0,0)		#ONTO FLOOR.
	    IF(AV.NE.0) CALL NEWSTA(I,0,0,AV,0)	#OR INTO VEHICLE.
	    }
	  }
	CALL RSPSUB(397,ODO2)			#SPILL THE WORKS.
	RETURN
#
# V122--	MOVE.  MOSTLY JOKES.
#
43000	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	I=398					#ASSUME NOT HERE.
	IF(QHERE(PRSO,HERE)) I=399
	CALL RSPSUB(I,ODO2)			#JOKE.
	RETURN

# VAPPLI, PAGE 6
#
# V123--	TURN ON.
#
44000	F=LIT(HERE)				#RECORD IF LIT.
	IF(OBJACT(X)) GO TO 44300		#OBJ HANDLE?
	IF((AND(OFLAG1(PRSO),LITEBT).NE.0).AND.
		(OADV(PRSO).EQ.WINNER)) GO TO 44100
	CALL RSPEAK(400)			#CANT DO IT.
	RETURN
#
44100	IF(AND(OFLAG1(PRSO),ONBT).EQ.0) GO TO 44200
	CALL RSPEAK(401)			#ALREADY ON.
	RETURN
#
44200	OFLAG1(PRSO)=OR(OFLAG1(PRSO),ONBT)	#TURN IT ON.
	CALL RSPSUB(404,ODO2)
44300	IF(.NOT.F .AND.LIT(HERE)) F=RMINFO(.FALSE.)	#ROOM NEWLY LIT.
	RETURN
#
# V124--	TURN OFF.
#
45000	IF(OBJACT(X)) GO TO 45300		#OBJ HANDLE?
	IF((AND(OFLAG1(PRSO),LITEBT).NE.0).AND.
		(OADV(PRSO).EQ.WINNER)) GO TO 45100
	CALL RSPEAK(402)			#CANT DO IT.
	RETURN
#
45100	IF(AND(OFLAG1(PRSO),ONBT).NE.0) GO TO 45200
	CALL RSPEAK(403)			#ALREADY OFF.
	RETURN
#
45200	OFLAG1(PRSO)=AND(OFLAG1(PRSO),NOT(ONBT))
	CALL RSPSUB(405,ODO2)
45300	IF(.NOT.LIT(HERE)) CALL RSPEAK(406)	#MAY BE DARK.
	RETURN
#
# V125--	OPEN.  A FINE MESS.
#
46000	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	IF(AND(OFLAG1(PRSO),CONTBT).NE.0) GO TO 46100
46050	CALL RSPSUB(407,ODO2)			#NOT OPENABLE.
	RETURN
#
46100	IF(OCAPAC(PRSO).NE.0) GO TO 46200
	CALL RSPSUB(408,ODO2)			#NOT OPENABLE.
	RETURN
#
46200	IF(.NOT.QOPEN(PRSO)) GO TO 46225
	CALL RSPEAK(412)			#ALREADY OPEN.
	RETURN
#
46225	OFLAG2(PRSO)=OR(OFLAG2(PRSO),OPENBT)	#OPEN IT.
	IF((AND(OFLAG1(PRSO),TRANBT).NE.0).OR.QEMPTY(PRSO))
		GO TO 46300
	CALL PRINCO(PRSO,410)			#PRINT CONTENTS.
	RETURN
#
46300	CALL RSPEAK(409)			#DONE
	RETURN
#
# V126--	CLOSE.
#
47000	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	IF(AND(OFLAG1(PRSO),CONTBT).EQ.0) GO TO 46050
	IF(OCAPAC(PRSO).NE.0) GO TO 47100
	CALL RSPSUB(411,ODO2)			#NOT CLOSABLE.
	RETURN
#
47100	IF(QOPEN(PRSO)) GO TO 47200		#OPEN?
	CALL RSPEAK(413)			#NO, JOKE.
	RETURN
#
47200	OFLAG2(PRSO)=AND(OFLAG2(PRSO),NOT(OPENBT))
	CALL RSPEAK(414)			#DONE.
	RETURN

# VAPPLI, PAGE 7
#
# V127--	FIND.  BIG MEGILLA.
#
48000	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	I=415					#DEFAULT CASE.
	IF(QHERE(PRSO,HERE)) GO TO 48300	#IN ROOM?
	IF(OADV(PRSO).EQ.WINNER) GO TO 48200	#ON WINNER?
	J=OCAN(PRSO)				#DOWN ONE LEVEL.
	IF(J.EQ.0) GO TO 10
	IF(((AND(OFLAG1(J),TRANBT).EQ.0).AND.
	  (.NOT.QOPEN(J).OR.(AND(OFLAG1(J),(DOORBT+CONTBT)).EQ.0)))) {
	 	GO TO 10			#IF NOT VISIBLE, PUNT.
		}
	I=417					#ASSUME IN ROOM.
	IF(QHERE(J,HERE)) GO TO 48100
	IF(OADV(J).NE.WINNER) GO TO 10		#NOT HERE OR ON PERSON.
	I=418
48100	CALL RSPSUB(I,ODESC2(J))		#DESCRIBE FINDINGS.
	RETURN
#
48200	I=416
48300	CALL RSPSUB(I,ODO2)			#DESCRIBE FINDINGS.
	RETURN
#
# V128--	WAIT.  RUN CLOCK DEMON.
#
49000	CALL RSPEAK(419)			#TIME PASSES.
	DO I=1,3 {
	  IF(CLOCKD(X)) RETURN
	  }
	RETURN
#
# V129--	SPIN.
# V159--	TURN TO.
#
50000	CONTINUE
88000	IF(.NOT.OBJACT(X)) CALL RSPEAK(663)	#IF NOT OBJ, JOKE.
	RETURN
#
# V130--	BOARD.  WORKS WITH VEHICLES.
#
51000	IF(AND(OFLAG2(PRSO),VEHBT).NE.0) GO TO 51100
	CALL RSPSUB(421,ODO2)			#NOT VEHICLE, JOKE.
	RETURN
#
51100	IF(QHERE(PRSO,HERE)) GO TO 51200	#HERE?
	CALL RSPSUB(420,ODO2)			#NO, JOKE.
	RETURN
#
51200	IF(AV.EQ.0) GO TO 51300			#ALREADY GOT ONE?
	CALL RSPSUB(422,ODO2)			#YES, JOKE.
	RETURN
#
51300	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	CALL RSPSUB(423,ODO2)			#DESCRIBE.
	AVEHIC(WINNER)=PRSO
	IF(WINNER.NE.PLAYER) OCAN(AOBJ(WINNER))=PRSO
	RETURN
#
# V131--	DISEMBARK.
#
52000	IF(AV.EQ.PRSO) GO TO 52100		#FROM VEHICLE?
	CALL RSPEAK(424)			#NO, JOKE.
	RETURN
#
52100	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	IF(AND(RFLAG(HERE),RLAND).NE.0) GO TO 52200
	CALL RSPEAK(425)			#NOT ON LAND.
	RETURN
#
52200	AVEHIC(WINNER)=0
	CALL RSPEAK(426)
	IF(WINNER.NE.PLAYER) CALL NEWSTA(AOBJ(WINNER),0,HERE,0,0)
	RETURN
#
# V132--	TAKE.  HANDLED EXTERNALLY.
#
53000	VAPPLI=TAKE(.TRUE.)
	RETURN
#
# V133--	INVENTORY.  PROCESSED EXTERNALLY.
#
55000	CALL INVENT(WINNER)
	RETURN

# VAPPLI, PAGE 8
#
# V134--	FILL.  STRANGE DOINGS WITH WATER.
#
56000	IF(PRSI.NE.0) GO TO 56050		#ANY OBJ SPECIFIED?
	IF(AND(RFLAG(HERE),(RWATER+RFILL)).NE.0) GO TO 56025
	CALL RSPEAK(516)			#NOTHING TO FILL WITH.
	PRSWON=.FALSE.				#YOU LOSE.
	RETURN
#
56025	PRSI=GWATE				#USE GLOBAL WATER.
56050	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	CALL RSPSB2(444,ODI2,ODO2)		#NO, JOKE.
	RETURN
#
# V135,V136--	EAT/DRINK
#
58000	CONTINUE
59000	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	IF(EDIBLE(PRSO).AND.(OADV(PRSO).EQ.WINNER)) {
	 	GO TO 59200			#EDIBLE & HAS IT.
		}
	IF(PRSO.EQ.GWATE) GO TO 59500		#DRINK GLOBAL WATER?
	IF(DRKBLE(PRSO).AND.(OCAN(PRSO).NE.0)) {
		GO TO 59400			#DRKBLE & INSIDE.
		}
59100	I=453					#ASSUME NOT FOOD.
	IF(EDIBLE(PRSO).OR.DRKBLE(PRSO)) I=454	#NOT ACCESSIBLE.
	CALL RSPSUB(I,ODO2)
	RETURN
#
59200	IF(PRSA.EQ.DRINKW) GO TO 59300		#DRINK FOOD?
	CALL NEWSTA(PRSO,455,0,0,0)		#NO, IT DISAPPEARS.
	RETURN
#
59300	CALL RSPEAK(456)			#YES, JOKE.
	RETURN
#
59400	IF(OADV(OCAN(PRSO)).NE.WINNER) GO TO 59100
	IF(QOPEN(OCAN(PRSO))) GO TO 59500	#CONT OPEN?
	CALL RSPEAK(457)			#NO, JOKE.
	RETURN
#
59500	CALL NEWSTA(PRSO,458,0,0,0)		#GONE.
	RETURN
#
# V137--	BURN.  COMPLICATED.
#
60000	IF(AND(OFLAG1(PRSI),(FLAMBT+LITEBT+ONBT)).NE.
		(FLAMBT+LITEBT+ONBT)) GO TO 60400
	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	IF(AV.NE.BALLO) GO TO 60050		#BALLOON?
	IF(OAPPLI(OACTIO(BALLO),0)) RETURN	#DID IT HANDLE?
60050	IF(AND(OFLAG1(PRSO),BURNBT).EQ.0) GO TO 60300
	IF(OADV(PRSO).NE.WINNER) GO TO 60100	#CARRYING IT?
	CALL RSPSUB(459,ODO2)
	CALL JIGSUP(460)
	RETURN
#
60100	J=OCAN(PRSO)				#GET CONTAINER.
	IF(QHERE(PRSO,HERE).OR. ((AV.NE.0).AND.(J.EQ.AV)))
		GO TO 60200			#REACHABLE?
	IF(J.EQ.0) GO TO 60150			#INSIDE?
	IF(.NOT.QOPEN(J)) GO TO 60150		#OPEN?
	IF(QHERE(J,HERE).OR.((AV.NE.0).AND.(OCAN(J).EQ.AV))) {
		GO TO 60200			#REACHABLE?
		}
60150	CALL RSPEAK(461)			#CANT REACH IT.
	RETURN
#
60200	CALL RSPSUB(462,ODO2)			#BURN IT.
	CALL NEWSTA(PRSO,0,0,0,0)
	RETURN
#
60300	CALL RSPSUB(463,ODO2)			#CANT BURN IT.
	RETURN
#
60400	CALL RSPSUB(301,ODI2)		#CANT BURN IT WITH THAT.
	RETURN

# VAPPLI, PAGE 9
#
# V138--	MUNG.  GO TO COMMON ATTACK CODE.
#
63000	I=466					#CHOOSE PHRASE.
	IF(AND(OFLAG2(PRSO),VILLBT).NE.0) GO TO 66100
	IF(.NOT.OBJACT(X)) CALL RSPSB2(466,ODO2,RMK)
	RETURN
#
# V139--	KILL.  GO TO COMMON ATTACK CODE.
#
64000	I=467					#CHOOSE PHRASE.
	GO TO 66100
#
# V140--	SWING.  INVERT OBJECTS, FALL THRU TO ATTACK.
#
65000	J=PRSO					#INVERT.
	PRSO=PRSI
	PRSI=J
	J=ODO2
	ODO2=ODI2
	ODI2=J
	PRSA=ATTACW				#FOR OBJACT.
#
# V141--	ATTACK.  FALL THRU TO ATTACK CODE.
#
66000	I=468
#
# COMMON MUNG/ATTACK/SWING/KILL CODE.
#
66100	IF(PRSO.NE.0) GO TO 66200		#ANYTHING?
	CALL RSPEAK(469)			#NO, JOKE.
	RETURN
#
66200	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	IF(AND(OFLAG2(PRSO),VILLBT).NE.0) GO TO 66300
	IF(AND(OFLAG1(PRSO),VICTBT).EQ.0) {
		CALL RSPSUB(470,ODO2)		#NOT A VILLAIN.
		}
	RETURN
#
66300	J=471					#ASSUME NO WEAPON.
	IF(PRSI.EQ.0) GO TO 66500
	IF(AND(OFLAG2(PRSI),WEAPBT).EQ.0) GO TO 66400
	MELEE=1					#ASSUME SWORD.
	IF(PRSI.NE.SWORD) MELEE=2		#MUST BE KNIFE.
	I=BLOW(PLAYER,PRSO,MELEE,.TRUE.,0)	#STRIKE BLOW.
	RETURN
#
66400	J=472					#NOT A WEAPON.
66500	CALL RSPSB2(I,ODO2,J)			#JOKE.
	RETURN

# VAPPLI, PAGE 10
#
# V142--	WALK.  PROCESSED EXTERNALLY.
#
68000	VAPPLI=WALK(X)
	RETURN
#
# V143--	TELL.  PROCESSED IN GAME.
#
69000	CALL RSPEAK(603)
	RETURN
#
# V144--	PUT.  PROCESSED EXTERNALLY.
#
70000	VAPPLI=PUT(.TRUE.)
	RETURN
#
# V145,V146,V147,V148--	DROP/GIVE/POUR/THROW
#
71000	CONTINUE
72000	CONTINUE
73000	CONTINUE
74000	VAPPLI=DROP(.FALSE.)
	RETURN
#
# V149--	SAVE
#
77000	IF(AND(RFLAG(TSTRS),RSEEN).EQ.0) GO TO 77100
	CALL RSPEAK(828)			#NO SAVES IN ENDGAME.
	RETURN
#
77100	CALL SAVEGM
	RETURN
#
# V150--	RESTORE
#
78000	IF(AND(RFLAG(TSTRS),RSEEN).EQ.0) GO TO 78100
	CALL RSPEAK(829)			#NO RESTORES IN ENDGAME.
	RETURN
#
78100	CALL RSTRGM
	RETURN

# VAPPLI, PAGE 11
#
# V151--	HELLO
#
80000	IF(PRSO.NE.0) GO TO 80100		#ANY OBJ?
	CALL RSPEAK(346+RND(4))			#NO, VANILLA HELLO.
	RETURN
#
80100	IF(PRSO.NE.AVIAT) GO TO 80200		#HELLO AVIATOR?
	CALL RSPEAK(350)			#NOTHING HAPPENS.
	RETURN
#
80200	IF(PRSO.NE.SAILO) GO TO 80300		#HELLO SAILOR?
	HS=HS+1					#COUNT.
	I=351					#GIVE NORMAL OR
	IF(MOD(HS,10).EQ.0) I=352		#RANDOM MESSAGE.
	IF(MOD(HS,20).EQ.0) I=353
	CALL RSPEAK(I)				#SPEAK UP.
	RETURN
#
80300	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	I=354					#ASSUME VILLAIN.
	IF(AND(OFLAG2(PRSO),(VILLBT+ACTRBT)).EQ.0) I=355
	CALL RSPSUB(I,ODO2)			#HELLO THERE!
	RETURN
#
# V152--	LOOK INTO
#
81000	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	IF(AND(OFLAG2(PRSO),VEHBT).NE.0) GO TO 81400	#VEHICLE?
	IF(AND(OFLAG1(PRSO),DOORBT).EQ.0) GO TO 81200	#DOOR?
	IF(.NOT.QOPEN(PRSO)) GO TO 81300	#OPEN?
	CALL RSPSUB(628,ODO2)			#OPEN DOOR- UNINTERESTING.
	RETURN
#
81200	IF(AND(OFLAG1(PRSO),CONTBT).EQ.0) GO TO 81600	#CONTAINER?
	IF(QOPEN(PRSO).OR.(AND(OFLAG1(PRSO),TRANBT).NE.0)) {
		GO TO 81400			#SEE INSIDE?
		}
81300	CALL RSPSUB(525,ODO2)			#CANT SEE INSIDE.
	RETURN
#
81400	IF(QEMPTY(PRSO)) GO TO 81500		#VEH OR OPEN.  EMPTY?
	CALL PRINCO(PRSO,573)			#NO, LIST CONTENTS.
	RETURN
#
81500	CALL RSPSUB(629,ODO2)			#EMPTY.
	RETURN
#
81600	CALL RSPSUB(630,ODO2)			#CANT LOOK INSIDE.
	RETURN
#
# V153--	LOOK UNDER
#
82000	IF(.NOT.OBJACT(X)) CALL RSPEAK(631)	#OBJECT HANDLE?
	RETURN

# VAPPLI, PAGE 12
#
# V154--	PUMP
#
83000	IF((OROOM(PUMP).EQ.HERE).OR.(OADV(PUMP).EQ.WINNER)) {
		GO TO 83100			#PUMP HERE?
		}
	CALL RSPEAK(632)			#NO.
	RETURN
#
83100	PRSI=PUMP				#BECOMES INFLATE
	PRSA=INFLAW				#X WITH PUMP.
	GO TO 22000				#DONE.
#
# V155--	WIND
#
84000	IF(.NOT.OBJACT(X)) CALL RSPSUB(634,ODO2)	#OBJ HANDLE?
	RETURN
#
# V156--	CLIMB
# V157--	CLIMB UP
# V158--	CLIMB DOWN
#
85000	CONTINUE
86000	CONTINUE
87000	I=XUP					#ASSUME UP.
	IF(PRSA.EQ.CLMBDW) I=XDOWN		#UNLESS CLIMB DN.
	F=AND(OFLAG2(PRSO),CLMBBT).NE.0
	IF(F.AND.FINDXT(I,HERE)) GO TO 87500		#ANYTHING TO CLIMB?
	IF(OBJACT(X)) RETURN			#OBJ HANDLE?
	I=657
	IF(F) I=524				#VARIETY OF JOKES.
	IF(.NOT.F .AND.((PRSO.EQ.WALL).OR.
		((PRSO.GE.WNORT).AND.(PRSO.LE.WNORT+3)))) {
		I=656				#IF WALLS.
		}
	CALL RSPEAK(I)			#JOKE.
	RETURN
#
87500	PRSA=WALKW				#WALK
	PRSO=I					#IN SPECIFIED DIR.
	VAPPLI=WALK(X)
	RETURN
#
	END
