# GDT- GAME DEBUGGING TOOL
#
# DECLARATIONS
#
	SUBROUTINE GDT
	IMPLICIT INTEGER (A-Z)
	INTEGER ARGTYP(36)
#	LOGICAL LINE(6),CHAL(6)
	CHARACTER LINE(6),CHAL(6)
	LOGICAL VALID1,VALID2,VALID3
	CHARACTER*2 DBGCMD(36)
#
# PARSER OUTPUT
#
	LOGICAL PRSWON,ccflg
	COMMON /spare/ccflg
	COMMON /PRSVEC/ PRSA,PRSI,PRSO,PRSWON,PRSCON
#
# PARSER STATE
#
	COMMON /ORPHS/ ORP(5)
	COMMON /LAST/ LASTIT
	COMMON /PV/ PVEC(5)
	COMMON /SYNTAX/ SYN(11)
#
# GAME STATE
#
	LOGICAL TELFLG
	COMMON /PLAY/ WINNER,HERE,TELFLG
	COMMON /STATE/	MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,
			LTSHFT,BLOC,MUNGRM,HS,EGSCOR,EGMXSC
#
# SCREEN OF LIGHT
#
	COMMON /SCREEN/ FROMDR,SCOLRM,SCOLAC
#
	COMMON /STAR/ MBASE,STRBIT
	COMMON /CHAN/ INPCH,OUTCH,DBCH
#
# MESSAGE INDEX
#
	COMMON /RMSG/ MLNT,RTEXT(1050)
#
	COMMON /DEBUG/ DBGFLG,PRSFLG,GDTFLG
#
# ROOMS
#
	COMMON /ROOMS/ RLNT,RDESC2,EQR(215,5)
#
	COMMON /RINDEX/ WHOUS,LROOM,CELLA
	COMMON /RINDEX/ MTROL,MAZE1
	COMMON /RINDEX/ MGRAT,MAZ15
	COMMON /RINDEX/ FORE1,FORE3,CLEAR,RESER
	COMMON /RINDEX/ STREA,EGYPT,ECHOR
	COMMON /RINDEX/ TSHAF
	COMMON /RINDEX/ BSHAF,MMACH,DOME,MTORC
	COMMON /RINDEX/ CAROU
	COMMON /RINDEX/ RIDDL,LLD2,TEMP1,TEMP2,MAINT
	COMMON /RINDEX/ BLROO,TREAS,RIVR1,RIVR2,RIVR3,MCYCL
	COMMON /RINDEX/ RIVR4,RIVR5,FCHMP,FALLS,MBARR
	COMMON /RINDEX/ MRAIN,POG,VLBOT,VAIR1,VAIR2,VAIR3,VAIR4
	COMMON /RINDEX/ LEDG2,LEDG3,LEDG4,MSAFE,CAGER
	COMMON /RINDEX/ CAGED,TWELL,BWELL,ALICE,ALISM,ALITR
	COMMON /RINDEX/ MTREE,BKENT,BKVW,BKTWI,BKVAU,BKBOX
	COMMON /RINDEX/ CRYPT,TSTRS,MRANT,MREYE
	COMMON /RINDEX/ MRA,MRB,MRC,MRG,MRD,FDOOR
	COMMON /RINDEX/ MRAE,MRCE,MRCW,MRGE,MRGW,MRDW,INMIR
	COMMON /RINDEX/ SCORR,NCORR,PARAP,CELL,PCELL,NCELL
#
	COMMON /OROOM2/ R2LNT,O2(15),R2(15)
#
# EXITS
#
	COMMON /EXITS/ XLNT,TRAVEL(870)
#
# OBJECTS
#
	COMMON /OBJCTS/ OLNT,EQO(250,14)
#
	COMMON /OINDEX/ GARLI,FOOD,GUNK,COAL,MACHI,DIAMO,TCASE,BOTTL
	COMMON /OINDEX/ WATER,ROPE,KNIFE,SWORD,LAMP,BLAMP,RUG
	COMMON /OINDEX/	LEAVE,TROLL,AXE
	COMMON /OINDEX/ RKNIF,KEYS,ICE,BAR
	COMMON /OINDEX/ COFFI,TORCH,TBASK,FBASK,IRBOX
	COMMON /OINDEX/ GHOST,TRUNK,BELL,BOOK,CANDL
	COMMON /OINDEX/ MATCH,TUBE,PUTTY,WRENC,SCREW,CYCLO,CHALI
	COMMON /OINDEX/ THIEF,STILL,WINDO,GRATE,DOOR
	COMMON /OINDEX/ HPOLE,LEAK,RBUTT,RAILI
	COMMON /OINDEX/ POT,STATU,IBOAT,DBOAT,PUMP,RBOAT
	COMMON /OINDEX/ STICK,BUOY,SHOVE,BALLO,RECEP,GUANO
	COMMON /OINDEX/ BROPE,HOOK1,HOOK2,SAFE,SSLOT,BRICK,FUSE
	COMMON /OINDEX/ GNOME,BLABE,DBALL,TOMB
	COMMON /OINDEX/ LCASE,CAGE,RCAGE,SPHER,SQBUT
	COMMON /OINDEX/ FLASK,POOL,SAFFR,BUCKE,ECAKE,ORICE,RDICE,BLICE
	COMMON /OINDEX/ ROBOT,FTREE,BILLS,PORTR,SCOL,ZGNOM
	COMMON /OINDEX/ EGG,BEGG,BAUBL,CANAR,BCANA
	COMMON /OINDEX/ YLWAL,RDWAL,PINDR,RBEAM
	COMMON /OINDEX/ ODOOR,QDOOR,CDOOR,NUM1,NUM8
	COMMON /OINDEX/ HANDS,WALL,LUNGS,SAILO,AVIAT,TEETH
	COMMON /OINDEX/ ITOBJ,EVERY,VALUA,OPLAY,WNORT,GWATE,MASTER
#
# CLOCK INTERRUPTS
#
	LOGICAL CFLAG
	COMMON /CEVENT/ CLNT,EQC(25,2),CFLAG(25)
#
# VILLAINS AND DEMONS
#
	LOGICAL THFFLG,SWDACT,THFACT
	COMMON /HACK/ THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
	COMMON /VILL/ VLNT,EQV(4,5)
#
# ADVENTURERS
#
	COMMON /ADVS/ ALNT,EQA(4,7)
#
# FLAGS
#
	LOGICAL FLAGS(50)
	INTEGER SWITCH(27)
	LOGICAL TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF
	LOGICAL DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF
	LOGICAL MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF
	LOGICAL EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF
	LOGICAL GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF
	LOGICAL GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF
	LOGICAL MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF
	LOGICAL FOLLWF,SPELLF,spare(6)
	COMMON /FINDEX/	TROLLF,CAGESF,BUCKTF,CAROFF,CAROZF,LWTIDF,
			DOMEF,GLACRF,ECHOF,RIDDLF,LLDF,CYCLOF,
			MAGICF,LITLDF,SAFEF,GNOMEF,GNODRF,MIRRMF,
			EGYPTF,ONPOLF,BLABF,BRIEFF,SUPERF,BUOYF,
			GRUNLF,GATEF,RAINBF,CAGETF,EMPTHF,DEFLAF,
			GLACMF,FROBZF,ENDGMF,BADLKF,THFENF,SINGSF,
			MRPSHF,MROPNF,WDOPNF,MR1F,MR2F,INQSTF,
			FOLLWF,SPELLF,sparf(6)
	COMMON /FINDEX/ SWITCH
	EQUIVALENCE (FLAGS(1),TROLLF)
	CHARACTER*3 CMD
#
# FUNCTIONS AND DATA
#
	VALID1(A1,L1)=(A1.GT.0).AND.(A1.LE.L1)
	VALID2(A1,A2,L1)=VALID1(A1,L1).AND.VALID1(A2,L1).AND.(A1.LE.A2)
	VALID3(A1,L1,A2,L2)=VALID1(A1,L1).AND.VALID1(A2,L2)
	DATA CMDMAX/36/
#
	DATA ARGTYP /	2 ,  2 ,  2 ,  2 ,  2 ,  0 ,  0 ,  2 ,  2 ,  0 ,
      			1 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
      			1 ,  0 ,  3 ,  3 ,  3 ,  3 ,  1 ,  3 ,  2 ,  2 ,
      			1 ,  2 ,  1 ,  0 ,  0 ,  0 /

	DATA DBGCMD/	'DR','DO','DA','DC','DX','DH','DL','DV','DF','DS',
      			'AF','HE','NR','NT','NC','ND','RR','RT','RC','RD',
      			'TK','EX','AR','AO','AA','AC','AX','AV','DB','DN',
      			'AN','DM','DT','AH','DP','PD'/
# GDT, PAGE 2
#
# FIRST, VALIDATE THAT THE CALLER IS AN IMPLEMENTER.
#
        FMAX=50
	SMAX=27
#
	IF(GDTFLG.NE.0) GO TO 2050		#IF OK ONCE, SKIP.
	DO I=1,6 {				#CREATE CHALLENGE.
#	  CHAL(I)=RND(26)*"4000000000
#	  CHAL(I)=CHAL(I)+'A'
          CHAL(I)=CHAR((RAND()*26)+ICHAR('A'))
	  }
	WRITE(OUTCH,100) CHAL                   #OUTPUT CHALLENGE.
	CALL ENCRYP(CHAL,LINE)			#CREATE RESPONSE.
#D	WRITE(OUTCH,105) LINE			#FOR DEBUGGING.
#D105	FORMAT('+',6A1)
#
	READ(INPCH,110) CHAL			#READ RESPONSE.
	IF(CHAL(1).EQ.' ') GO TO 31000		#DECLINED? EXIT.
	DO I=1,6{				#CHECK FOR MATCH.
	  IF(CHAL(I).NE.LINE(I)) GO TO 1500
        }
	WRITE(OUTCH,120)			#AT YOUR SERVICE!
	GDTFLG=1				#DISABLE TRAP.
	GO TO 2000
#
1500	CALL JIGSUP(182)			#YOU LOSE.
	RETURN
#
100	FORMAT("+A booming voice calls out:",
	/"To prove your worthiness, answer the following challenge.",
	/" Challenge: ",6A1/" Response:  ")
110	FORMAT(6A1)
120	FORMAT('+At your service!')
# GDT, PAGE 2A
#
# HERE TO GET NEXT COMMAND
#
2000	write(outch,205)
2050	WRITE(OUTCH,200)			#OUTPUT PROMPT.
	READ(INPCH,210) CMD			#GET COMMAND.
	IF(CMD.EQ.'  ') GO TO 2050		#IGNORE BLANKS.
#	CMD=CMD.and.o'576777777777'		#remove lower case
	DO I=1,CMDMAX {				#LOOK IT UP.
	  IF(CMD.EQ.DBGCMD(I)) GO TO 2300	#FOUND?
	  }
2200	WRITE(OUTCH,220)			#NO, LOSE.
	GO TO 2000
#
200	FORMAT('+GDT>')
205	format(' ')
210	FORMAT(A2)
220	FORMAT('+?')
230	FORMAT(2I)
240	FORMAT(I)
225	FORMAT('+Limits:   ')
235	FORMAT('+Entry:    ')
245	FORMAT('+Idx,Ary:  ')
#
2300	GO TO (2400,2500,2600,2700),ARGTYP(I)+1	#BRANCH ON ARG TYPE.
	GO TO 2200				#ILLEGAL TYPE.
#
2700	WRITE(OUTCH,245)			#TYPE 3, REQUEST ARRAY COORDS.
	READ(INPCH,230) J,K
	GO TO 2400
#
2600	WRITE(OUTCH,225)			#TYPE 2, READ BOUNDS.
	READ(INPCH,230) J,K
	IF(K.EQ.0) K=J
	GO TO 2400
#
2500	WRITE(OUTCH,235)			#TYPE 1, READ ENTRY NO.
	READ(INPCH,240) J
2400	GO TO (
      	10000,11000,12000,13000,14000,15000,16000,17000,18000,19000,
      	20000,21000,22000,53000,24000,25000,26000,27000,28000,29000,
      	30000,31000,32000,33000,34000,35000,36000,37000,38000,39000,
      	40000,41000,42000,43000,44000,45000) I
	GO TO 2200						#WHAT???
# GDT, PAGE 3
#
# DR-- DISPLAY ROOMS
#
10000	IF(.NOT.VALID2(J,K,RLNT)) GO TO 2200	#ARGS VALID?
	WRITE(OUTCH,300)			#COL HDRS.
	DO I=J,K {
	  RDFOO=RDESC2-I
	  WRITE(OUTCH,310) I,RDFOO,(EQR(I,L),L=1,5)
	  }
	GO TO 2000
#
300	FORMAT('+RM# DESC2  DESC1  EXITS ACTION  VALUE  FLAGS')
310	FORMAT(1X,I3,1X,I5,4(1X,I6),1X,O6)
#
# DO-- DISPLAY OBJECTS
#
11000	IF(.NOT.VALID2(J,K,OLNT)) GO TO 2200	#ARGS VALID?
	WRITE(OUTCH,320)			#COL HDRS
	DO I=J,K {
	  WRITE(OUTCH,330) I,(EQO(I,L),L=1,14)
	  }
	GO TO 2000
#
320	FORMAT('+OB# DESC1 DESC2 DESCO ACT FLAGS1 FLAGS2 FVL TVL',
      	'SIZE CAPAC ROOM ADV CON  READ')
330	FORMAT(1X,I3,3I6,I4,2O7,2I4,2I6,1X,3I4,I6)
#
# DA-- DISPLAY ADVENTURERS
#
12000	IF(.NOT.VALID2(J,K,ALNT)) GO TO 2200	#ARGS VALID?
	WRITE(OUTCH,340)
	DO I=J,K {
	  WRITE(OUTCH,350) I,(EQA(I,L),L=1,7)
	  }
	GO TO 2000
#
340	FORMAT('+AD#   ROOM  SCORE  VEHIC OBJECT ACTION  STREN  FLAGS')
350	FORMAT(1X,I3,6(1X,I6),1X,O6)
#
# DC-- DISPLAY CLOCK EVENTS
#
13000	IF(.NOT.VALID2(J,K,CLNT)) GO TO 2200	#ARGS VALID?
	WRITE(OUTCH,360)
	DO I=J,K {
	  WRITE(OUTCH,370) I,(EQC(I,L),L=1,2),CFLAG(I)
	  }
	GO TO 2000
#
360	FORMAT('+CL#   TICK ACTION  FLAG')
370	FORMAT(1X,I3,1X,I6,1X,I6,5X,L1)
#
# DX-- DISPLAY EXITS
#
14000	IF(.NOT.VALID2(J,K,XLNT)) GO TO 2200	#ARGS VALID?
	WRITE(OUTCH,380)			#COL HDRS.
	DO I=J,K,10 {			#TEN PER LINE.
	  L=MIN0(I+9,K)				#COMPUTE END OF LINE.
	  WRITE(OUTCH,390) I,L,(TRAVEL(L1),L1=I,L)
	  }
	GO TO 2000
#
380	FORMAT('+  RANGE   CONTENTS')
390	FORMAT(1X,I3,'-',I3,3X,10O7)
#
# DH-- DISPLAY HACKS
#
15000	WRITE(OUTCH,400) THFPOS,THFFLG,THFACT,SWDACT,SWDSTA
	GO TO 2000
#
400	FORMAT('+THFPOS=',I6,', THFFLG=',L2,',THFACT=',L2/,
      	' SWDACT=',L2,', SWDSTA=',I2)
#
# DL-- DISPLAY LENGTHS
#
16000	WRITE(OUTCH,410) RLNT,XLNT,OLNT,CLNT,VLNT,ALNT,MLNT,R2LNT,
      	MBASE,STRBIT
	GO TO 2000
#
410	FORMAT('+R=',I6,', X=',I6,', O=',I6,', C=',I6/,
      	' V=',I6,', A=',I6,', M=',I6,', R2=',I5/,
      	' MBASE=',I6,', STRBIT=',I6)
#
# DV-- DISPLAY VILLAINS
#
17000	IF(.NOT.VALID2(J,K,VLNT)) GO TO 2200	#ARGS VALID?
	WRITE(OUTCH,420)			#COL HDRS
	DO I=J,K {
	  WRITE(OUTCH,430) I,(EQV(I,L),L=1,5)
	  }
	GO TO 2000
#
420	FORMAT('+VL# OBJECT   PROB   OPPS   BEST  MELEE')
430	FORMAT(1X,I3,5(1X,I6))
#
# DF-- DISPLAY FLAGS
#
18000	IF(.NOT.VALID2(J,K,FMAX)) GO TO 2200	#ARGS VALID?
	DO I=J,K {
	  WRITE(OUTCH,440) I,FLAGS(I)
	  }
	GO TO 2000
#
440	FORMAT(' Flag #',I2,' = ',L1)
#
# DS-- DISPLAY STATE
#
19000	WRITE(OUTCH,450) PRSA,PRSO,PRSI,PRSWON,PRSCON
	WRITE(OUTCH,460) WINNER,HERE,TELFLG
	WRITE(OUTCH,470) MOVES,DEATHS,RWSCOR,MXSCOR,MXLOAD,LTSHFT,BLOC,
      	MUNGRM,HS,EGSCOR,EGMXSC
	WRITE(OUTCH,475) FROMDR,SCOLRM,SCOLAC
	GO TO 2000
#
450	FORMAT('+Parse vector=',3(1X,I6),1X,L6,1X,I6)
460	FORMAT(' Play vector= ',2(1X,I6),1X,L6)
470	FORMAT(' State vector=',9(1X,I6)/14X,2(1X,I6))
475	FORMAT(' Scol vector= ',1X,O6,2(1X,I6))
# GDT, PAGE 4
#
# AF-- ALTER FLAGS
#
20000	IF(.NOT.VALID1(J,FMAX)) GO TO 2200	#ENTRY NO VALID?
	WRITE(OUTCH,480) FLAGS(J)		#TYPE OLD, GET NEW.
	READ(INPCH,490) FLAGS(J)
	GO TO 2050
#
480	FORMAT('+Old=',L2,6X,'New= ')
490	FORMAT(L1)
#
# 21000-- HELP
#
21000	WRITE(OUTCH,900)
	GO TO 2000
#
900	FORMAT('+Valid commands are:'/' AA- Alter ADVS'/,
      	' AC- Alter CEVENT'/' AF- Alter FINDEX'/' AH- Alter HERE'/,
      	' AN- Alter switches'/' AO- Alter OBJCTS'/' AR- Alter ROOMS'/,
      	' AV- Alter VILLS'/' AX- Alter EXITS'/' DA- Display ADVS'/,
      	' DC- Display CEVENT'/' DF- Display FINDEX'/' DH- Display HACKS'/,
      	' DL- Display lengths'/' DM- Display RTEXT'/,
      	' DN- Display switches'/,
      	' DO- Display OBJCTS'/' DP- Display parser'/,
      	' DR- Display ROOMS'/' DS- Display state'/,
      	' DT- Display text'/' DV- Display VILLS'/' DX- Display EXITS'/,
      	' DB- Display ROOM2'/' EX- Exit'/' HE- Type this message'/,
      	' NC- No cyclops'/' ND- No deaths'/' NR- No robber'/,
      	' NT- No troll'/' PD- Program detail'/,
      	' RC- Restore cyclops'/' RD- Restore deaths'/,
      	' RR- Restore robber'/' RT- Restore troll'/' TK- Take.')
#
# NR-- NO ROBBER
#
22000	THFFLG=.FALSE.				#DISABLE ROBBER.
	THFACT=.FALSE.
	CALL NEWSTA(THIEF,0,0,0,0)		#VANISH THIEF.
	WRITE(OUTCH,500)
	GO TO 2000
#
500	FORMAT('+No robber.')
#
# NT-- NO TROLL
#
53000	TROLLF=.TRUE.
	CALL NEWSTA(TROLL,0,0,0,0)
	WRITE(OUTCH,510)
	GO TO 2000
#
510	FORMAT('+No troll.')
#
# NC-- NO CYCLOPS
#
24000	CYCLOF=.TRUE.
	CALL NEWSTA(CYCLO,0,0,0,0)
	WRITE(OUTCH,520)
	GO TO 2000
#
520	FORMAT('+No cyclops.')
#
# ND-- IMMORTALITY MODE
#
25000	DBGFLG=1
	WRITE(OUTCH,530)
	GO TO 2000
#
530	FORMAT('+No deaths.')
#
# RR-- RESTORE ROBBER
#
26000	THFACT=.TRUE.
	WRITE(OUTCH,540)
	GO TO 2000
#
540	FORMAT('+Restored robber.')
#
# RT-- RESTORE TROLL
#
27000	TROLLF=.FALSE.
	CALL NEWSTA(TROLL,0,MTROL,0,0)
	WRITE(OUTCH,550)
	GO TO 2000
#
550	FORMAT('+Restored troll.')
#
# RC-- RESTORE CYCLOPS
#
28000	CYCLOF=.FALSE.
	MAGICF=.FALSE.
	CALL NEWSTA(CYCLO,0,MCYCL,0,0)
	WRITE(OUTCH,560)
	GO TO 2000
#
560	FORMAT('+Restored cyclops.')
#
# RD-- MORTAL MODE
#
29000	DBGFLG=0
	WRITE(OUTCH,570)
	GO TO 2000
#
570	FORMAT('+Restored deaths.')
# GDT, PAGE 5
#
# TK-- TAKE
#
30000	IF(.NOT.VALID1(J,OLNT)) GO TO 2200	#VALID OBJECT?
	CALL NEWSTA(J,0,0,0,WINNER)		#YES, TAKE OBJECT.
	WRITE(OUTCH,580)			#TELL.
	GO TO 2000
#
580	FORMAT('+Taken.')
#
# EX-- GOODBYE
#
31000	PRSCON=1
	RETURN
#
# AR--	ALTER ROOM ENTRY
#
32000	IF(.NOT.VALID3(J,RLNT,K,5)) GO TO 2200	#INDICES VALID?
	WRITE(OUTCH,590) EQR(J,K)		#TYPE OLD, GET NEW.
	READ(INPCH,600) EQR(J,K)
	GO TO 2050
#
590	FORMAT('+Old= ',I6,6X,'New= ')
600	FORMAT(I6)
#
# AO-- ALTER OBJECT ENTRY
#
33000	IF(.NOT.VALID3(J,OLNT,K,14)) GO TO 2200	#INDICES VALID?
	WRITE(OUTCH,590) EQO(J,K)
	READ(INPCH,600) EQO(J,K)
	GO TO 2050
#
# AA-- ALTER ADVS ENTRY
#
34000	IF(.NOT.VALID3(J,ALNT,K,7)) GO TO 2200	#INDICES VALID?
	WRITE(OUTCH,590) EQA(J,K)
	READ(INPCH,600) EQA(J,K)
	GO TO 2050
#
# AC-- ALTER CLOCK EVENTS
#
35000	IF(.NOT.VALID3(J,CLNT,K,3)) GO TO 2200	#INDICES VALID?
	IF(K.EQ.3) GO TO 35500			#FLAGS ENTRY?
	WRITE(OUTCH,590) EQC(J,K)
	READ(INPCH,600) EQC(J,K)
	GO TO 2050
#
35500	WRITE(OUTCH,480) CFLAG(J)
	READ(INPCH,490) CFLAG(J)
	GO TO 2050
#
# AX-- ALTER EXITS
#
36000	IF(.NOT.VALID1(J,XLNT)) GO TO 2200	#ENTRY NO VALID?
	WRITE(OUTCH,610) TRAVEL(J)
	READ(INPCH,620) TRAVEL(J)
	GO TO 2050
#
610	FORMAT('+Old= ',O6,6X,'New= ')
620	FORMAT(O6)
#
# AV-- ALTER VILLAINS
#
37000	IF(.NOT.VALID3(J,VLNT,K,5)) GO TO 2200	#INDICES VALID?
	WRITE(OUTCH,590) EQV(J,K)
	READ(INPCH,600) EQV(J,K)
	GO TO 2050
#
# D2-- DISPLAY ROOM2 LIST
#
38000	IF(.NOT.VALID2(J,K,R2LNT)) GO TO 2200
	DO I=J,K {
	  WRITE(OUTCH,630) I,R2(I),O2(I)
	  }
	GO TO 2000
#
630	FORMAT('+#',I2,'   Room=',I6,'   Obj=',I6)
#
# DN-- DISPLAY SWITCHES
#
39000	IF(.NOT.VALID2(J,K,SMAX)) GO TO 2200	#VALID?
	DO I=J,K {
	  WRITE(OUTCH,640) I,SWITCH(I)
	  }
	GO TO 2000
#
640	FORMAT(' Switch #',I2,' = ',I6)
#
# AN-- ALTER SWITCHES
#
40000	IF(.NOT.VALID1(J,SMAX)) GO TO 2200	#VALID ENTRY?
	WRITE(OUTCH,590) SWITCH(J)
	READ(INPCH,600) SWITCH(J)
	GO TO 2050
#
# DM-- DISPLAY MESSAGES
#
41000	IF(.NOT.VALID2(J,K,MLNT)) GO TO 2200	#VALID LIMITS?
	WRITE(OUTCH,380)
	DO I=J,K,10 {
	  L=MIN0(I+9,K)
	  WRITE(OUTCH,650) I,L,(RTEXT(L1),L1=I,L)
	  }
	GO TO 2000
#
650	FORMAT(1X,I3,'-',I3,3X,10(1X,I6))
#
# DT-- DISPLAY TEXT
#
42000	CALL RSPEAK(J)
	GO TO 2000
#
# AH--	ALTER HERE
#
43000	WRITE(OUTCH,590) HERE
	READ(INPCH,600) HERE
	EQA(1,1)=HERE
	GO TO 2050
#
# DP--	DISPLAY PARSER STATE
#
44000	WRITE(OUTCH,660) ORP,LASTIT,PVEC,SYN
	GO TO 2000
#
660	FORMAT('+ORPHS= ',I7,O7,4I7/,
      	' PV=    ',O7,4I7/' SYN=   ',6O7/15X,5O7)
#
# PD--	PROGRAM DETAIL DEBUG
#
45000	WRITE(OUTCH,610) PRSFLG			#TYPE OLD, GET NEW.
	READ(INPCH,620) PRSFLG
	GO TO 2000
#
	END
