/*-------------------------------------------------------------*/
/*  File:  oldemo_ev.c 
 *
 *  An example program that displays a OblongButton widget 
 *  and uses an event handler to change the label when user
 *  presses any mouse button on the OblongButton.
 *
 */
 /*-------------------------------------------------------------*/
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/OblongButt.h>

static int quit_now = 0;

/* Initial label for the oblong button */
static char quit_label[] = "Press here to exit...";

/* Room for setting up arguments passed to widgets */
#define MAXARGS 10
static Arg args[MAXARGS];

/* Event handler */

static void my_event_handler();

/*-------------------------------------------------------------*/
void main(argc, argv)
int  argc;
char **argv;
{
    Widget main_widget, quit_button;

    main_widget = OlInitialize(argv[0], "Oldemo", NULL, 0,
                               &argc, argv);

/* Use XtVaCreateManaged to create the oblong button and
 * initialize its XtNlabel resource in a single function call.
 */
    
    quit_button = XtVaCreateManagedWidget("Exit",
                      oblongButtonWidgetClass, main_widget, 
                      XtNlabel, quit_label,
                      NULL);

/* Install an event handler for ButtonPress events */

    XtAddEventHandler(quit_button, ButtonPressMask, FALSE, 
                      my_event_handler, NULL);

/* Realize the widgets and start event-processing loop */

    XtRealizeWidget(main_widget);
    XtMainLoop();
}
/*-------------------------------------------------------------*/
/*  m y _ e v e n t _ h a n d l e r
 *
 *  Function to be called when the user presses a mouse button
 *  in the "exit" pushbutton.
 */
static void my_event_handler(w, client_data, p_event)
Widget    w;
XtPointer client_data;
XEvent    *p_event;
{
/* Exit if the quit flag is set */
    if(quit_now)
        exit(0);
    else
    {
/* Change the OblongButton's label */
        XtSetArg(args[0], XtNlabel, "Press again please");
        XtSetValues(w, args, 1);

/* Set flag so that we quit on next ButtonPress */        
        quit_now = 1;
    }
}
