/*-------------------------------------------------------------*/
/*  File:  oldemo.c 
 *
 *  An example program that displays a OblongButton widget.
 *
 */

/* STEP 1:  Include the header files */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/OblongButt.h>

/* Label for the oblong button */
static char quit_label[] = "Press here to exit...";

/* Room for setting up arguments passed to widgets */
#define MAXARGS 10
static Arg args[MAXARGS];

/* Callback function */

static void button_pushed();

/*-------------------------------------------------------------*/
void main(argc, argv)
int  argc;
char **argv;
{
    Widget main_widget, quit_button;
    int    argcount;

/* STEP 2: Initialize toolkit and create the top-level widget.
 *         Note that Xt Intrinsics include other initialization
 *         functions such as XtInitialize and XtAppInitialize,
 *         but OLIT requires a call to OlInitialize.
 */
    main_widget = OlInitialize(argv[0], "Oldemo", NULL, 0,
                               &argc, argv);

/* STEP 3: Set up argument list for the button widget,
 *         create the button, and set up a callback
 *         function. In this case, the argument is a label
 *         for the button.
 */
    argcount = 0;
    XtSetArg(args[argcount], XtNlabel, quit_label);
    argcount++;
    
    quit_button = XtCreateManagedWidget("Exit",
                      oblongButtonWidgetClass, main_widget, 
                      args, argcount);

/* Install the callback function for this pushbutton */
    XtAddCallback(quit_button, XtNselect, button_pushed, NULL);

/* STEP 4: Realize the widgets */
    XtRealizeWidget(main_widget);

/* STEP 5: Start the main event-handling loop */
    XtMainLoop();
}
/*-------------------------------------------------------------*/
/*  b u t t o n _ p u s h e d
 *
 *  Function to be called when user presses and releases the
 *  SELECT mouse button in the "exit" button.
 */
static void button_pushed(w, client_data, call_data)
Widget    w;
XtPointer client_data;
XtPointer call_data;
{
    XtCloseDisplay(XtDisplay(w));
    exit(0);
}
