#
# Try to summarize the results of "timekeeper".
# Awk script by msb.
# $Ident$

BEGIN	{
		# Anything over this long is considerd "you forgot to logout".
		maxhr = 10
	}

$2 == "Start" {
		if (project != "") {
			timechunk = $1 - start
			if (timechunk > maxhr*3600) \
				err = err "Over " maxhr \
					" hours shown without break: " \
					start "->" $1 " on " project "\n"
			else \
				projtime[project] += timechunk
		}
		project = $3
		if (project == "RECORDING") project = ""
		else start = $1
		next
	}

$2 == "End" {
		if (project != "") {
			timechunk = $1 - start
			if (timechunk > maxhr*3600) \
				err = err "Over " maxhr \
					" hours shown without break: " \
					start "->" $1 " on " project "\n"
			else \
				projtime[project] += timechunk
		}
		project = ""
		next
	}

	{
		err = err "Unrecognized line: " $0 "\n"
	}

END	{
		for (project in projtime) {
			printf "%5.1f hours	%s\n", \
				projtime[project]/3600, project
			tot += projtime[project]
		}
		printf \
	 "\n%5.1f total hours (may not agree with above due to rounding)\n", \
			 tot/3600
		if (err != "") {
			print "\nErrors:"
			print err
		}
	}
