/* FILE main_stubs.c ****************************************
 *
 * xplan - project planning tool
 * Copyright (C) 1992 Brian Gaubert, Mark M. Lacey, Richard Malingkas,
 * and Mike Marlow.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License (distributed with this program in the file
 * COPYING) for more details.
 * 
 * If you did not received a copy of the GNU General Public License
 * along with this program, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * Since this was a project for a one semester software engineering
 * course, the authors will not be offering support for the product
 * after its release.
 *
 * DESCRIPTION OF CONTENTS
 *
 * main_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `main.G'.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include <xview/notice.h>
#include "db.h"
#include "calc.h"
#include "xplan.h"

void	taskList_Notify(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);

int selected=0, last_selected=0;
struct task_node *current_task=NULL;
extern char project_filename[256];
extern char export_filename[];
int load_save_flag;

/*
 * Menu handler for `fileMenu (Load...)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
  main_fileMenu_item0_callback(Menu_item item, Menu_generate op)
{
   char wd[256];

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/* make the main window and task window busy */
		xv_set(Main_mainWindow->mainWindow,
		       FRAME_BUSY, TRUE, NULL);
		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup,
		       FRAME_BUSY, TRUE, NULL);

		/* set the flag to load */
		load_save_flag = LOAD;
		xv_set(File_filePopup->filePopup, FRAME_LABEL, 
		       "Load File", NULL);
		xv_set(File_filePopup->applyButton, PANEL_LABEL_STRING,
		       "Load", NULL);

		/* get working directory */
		getwd(wd);

		/* set directory in window field */
		xv_set(File_filePopup->directoryField, PANEL_VALUE,
		       wd, NULL);
		
		/* fill the file list */
		fill_filelist(wd);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(File_filePopup->filePopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(File_filePopup->filePopup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `fileMenu (Save As...)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
main_fileMenu_item3_callback(Menu_item item, Menu_generate op)
{
   char wd[256];

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* make the main window busy */
		xv_set(Main_mainWindow->mainWindow,
		       FRAME_BUSY, TRUE, NULL);
		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup,
		       FRAME_BUSY, TRUE, NULL);

		/* set flag to save */
		load_save_flag = SAVE;
		xv_set(File_filePopup->filePopup, FRAME_LABEL, 
		       "Save File", NULL);
		xv_set(File_filePopup->applyButton, PANEL_LABEL_STRING,
		       "Save", NULL);
		
		/* get working directory */
		getwd(wd);

		/* set it in field */
		xv_set(File_filePopup->directoryField, PANEL_VALUE,
		       wd, NULL);
		
		/* fill the file list */
		fill_filelist(wd);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(File_filePopup->filePopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(File_filePopup->filePopup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */
		
		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `exportMenu (Options...)'.
 * 
 * Author: Mark M. Lacey
 *
 */
Menu_item
main_exportMenu_item3_callback(Menu_item item, Menu_generate op)
{
   char wd[256];

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		/* get directory */
		getwd(wd);
		
		/* set it in field */
		xv_set(Export_exportPopup->directory,
		       PANEL_VALUE, wd, NULL);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Export_exportPopup->exportPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(Export_exportPopup->exportPopup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}


/*
 * Menu handler for `insertMenu (Before)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
main_insertMenu_item0_callback(Menu_item item, Menu_generate op)
{
   struct task_list *temp_list;
   struct task_node *new_task_node;
   struct task_node *temp_task;
   char *temp_name;
   Xv_notice       notice;

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		/* if nothing has been selected, let them know */
		if (selected == -1) {
		   notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      "You must first select a task to add before", 
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return item;
		}
		
		/* if they inserted one earlier and haven't applied */
		/* changes to it yet, let them know */
		if (find_task(get_main_task_list(), "New Task")) {
		   
		   notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				      NOTICE_MESSAGE_STRINGS, "You must first rename the current task and select 'Apply'", NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		/* create a new task */
		new_task_node = create_default_task();

		temp_list = get_main_task_list();

		/* find the name of the task we are adding before */
		temp_name = (char *) xv_get(ip->taskList,
					    PANEL_LIST_STRING,
					    selected, NULL);

		/* find a pointer to the task we are adding before */
		temp_task = find_task(temp_list, temp_name);
		/* add the new task before the existing one */
		add_task_before(temp_list, temp_task, new_task_node);

		/* modify the scrolling list to show what happened */
		xv_set(ip->taskList, PANEL_LIST_INSERT, selected,
		       PANEL_LIST_STRING, selected,
		       new_task_node->data->name,
		       PANEL_LIST_SELECT, selected, TRUE, NULL);

		/* update various displays along with global data */
		current_task = new_task_node;
		load_data_to_taskinfoPopup(new_task_node);
		fill_dependency_popup(new_task_node);
		fill_resource_popup(new_task_node);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `insertMenu (After)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
main_insertMenu_item1_callback(Menu_item item, Menu_generate op)
{
   struct task_list *temp_list;
   struct task_node *new_task_node;
   struct task_node *temp_task;
   char *temp_name;
   Xv_notice       notice;


	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* if nothing has been selected, let them know */
		if (selected == -1) {
		   notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				      NOTICE_MESSAGE_STRINGS, "You must first select a task to add after", NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		/* if they created a new task and haven't applied */
		/* changes, let them know */
		if (find_task(get_main_task_list(), "New Task")) {
		   
		   notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				      NOTICE_MESSAGE_STRINGS, "You must first rename the current task and select 'Apply'", NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		/* create a new task */
		new_task_node = create_default_task();

		temp_list = get_main_task_list();

		/* find the name of the one we are adding after */
		temp_name = (char *) xv_get(ip->taskList,
					    PANEL_LIST_STRING,
					    selected, NULL);

		/* find a pointer to it */
		temp_task = find_task(temp_list, temp_name);
		/* add after it */
		add_task_after(temp_list, temp_task, new_task_node);
		/* modify the selected field */
		selected = selected+1;

		/* highlight selected field */
		xv_set(ip->taskList, PANEL_LIST_INSERT, selected,
		       PANEL_LIST_STRING, selected,
		       new_task_node->data->name,
		       PANEL_LIST_SELECT, selected, TRUE, NULL);

		/* store global data and update displays */
		current_task = new_task_node;
		load_data_to_taskinfoPopup(new_task_node);
		fill_dependency_popup(new_task_node);
		fill_resource_popup(new_task_node);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `insertMenu (Top)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
main_insertMenu_item2_callback(Menu_item item, Menu_generate op)
{
   struct task_list *temp_list;
   struct task_node *new_task_node;
   struct task_node *temp_task;
   Xv_notice       notice;


	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		if (find_task(get_main_task_list(), "New Task")) {
		   
		   notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				      NOTICE_MESSAGE_STRINGS, "You must first rename the current task and select 'Apply'", NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		new_task_node = create_default_task();

		temp_list = get_main_task_list();

		add_task_to_beginning(temp_list, new_task_node);
		selected = 0;
		xv_set(ip->taskList, PANEL_LIST_INSERT, selected,
		       PANEL_LIST_STRING, selected,
		       new_task_node->data->name,
		       PANEL_LIST_SELECT, selected, TRUE, NULL);

		current_task = new_task_node;
		load_data_to_taskinfoPopup(new_task_node);
		fill_dependency_popup(new_task_node);
		fill_resource_popup(new_task_node);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `insertMenu (Bottom)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
main_insertMenu_item3_callback(Menu_item item, Menu_generate op)
{
   struct task_list *temp_list;
   struct task_node *new_task_node;
   struct task_node *temp_task;
   unsigned nrows;
   Xv_notice       notice;

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		if (find_task(get_main_task_list(), "New Task")) {
		   notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				      NOTICE_MESSAGE_STRINGS, "You must first rename the current task and select 'Apply'", NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		new_task_node = create_default_task();

		temp_list = get_main_task_list();

		add_task_to_end(temp_list, new_task_node);
		
		nrows = (unsigned) xv_get(ip->taskList,
					  PANEL_LIST_NROWS,
					  NULL);
		selected = nrows;
		xv_set(ip->taskList, PANEL_LIST_INSERT, selected,
		       PANEL_LIST_STRING, selected,
		       new_task_node->data->name,
		       PANEL_LIST_SELECT, selected, TRUE, NULL);

		current_task = new_task_node;
		load_data_to_taskinfoPopup(new_task_node);
		fill_dependency_popup(new_task_node);
		fill_resource_popup(new_task_node);


		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `taskList'.
 *
 * Author: Mark M. Lacey
 *
 */
int
main_mainWindow_taskList_notify_callback(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	main_mainWindow_objects *ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:

	   /* set up global data */
	   last_selected = selected;
	   selected = -1;
		break;

	case PANEL_LIST_OP_SELECT:
		
	   /* find the current task that was selected */
	   current_task = find_task(get_main_task_list(), string);
	   /* update windows */
	   load_data_to_taskinfoPopup(current_task);
	   fill_dependency_popup(current_task);
	   fill_resource_popup(current_task);
	   /* store which row it was in */
	   selected = row;
		
	   xv_set(Taskinfo_taskinfoPopup->taskinfoPopup,
		  FRAME_CMD_PUSHPIN_IN, TRUE, XV_SHOW, TRUE,
		  NULL);


		break;

	case PANEL_LIST_OP_VALIDATE:
		break;

	case PANEL_LIST_OP_DELETE:
		break;
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	taskList_Notify(item, string, client_data, op, event, row);
	
	/* gxv_end_connections */

	return XV_OK;
}

/*
 * User-defined action for `taskList'.
 */
void
taskList_Notify(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{

}

/*
 * Menu handler for `chartMenu (PERT)'.
 */
Menu_item
display_pert_callback(Menu_item item, Menu_generate op)
{
   Xv_notice notice;
   char buffer[100];

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		/* set up the formatting information and check for a */
		/* dependency loop */
		traverse_task_list();

		if (loop_found) {
		   sprintf(buffer, "A dependency loop was found at "
			   "task %s", loop_pointer->data->name);
		   notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      buffer, NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return;
		}

		/* calculate the critical path */
		calc_critical();

		/* pop up the window */

		xv_set(PERT_pertPopup->pertPopup,
		       FRAME_CMD_PUSHPIN_IN, TRUE, NULL);

		xv_set(PERT_pertPopup->pertPopup, XV_SHOW, TRUE, NULL);
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `chartMenu (Gantt)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
display_gantt_callback(Menu_item item, Menu_generate op)
{
	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		/* pop up the window */

		xv_set(Gantt_ganttPopup->ganttPopup,
		       FRAME_CMD_PUSHPIN_IN, TRUE, NULL);

		xv_set(Gantt_ganttPopup->ganttPopup, XV_SHOW, TRUE, NULL);
		
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `analyzeMenu (Find Critical Path)'.
 */
Menu_item
find_critical_path_callback(Menu_item item, Menu_generate op)
{
   Xv_notice notice;

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		/* find the critical path */
		calc_critical();
		notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				   NOTICE_MESSAGE_STRINGS, 
				   "Critical path calculated and stored",
				   NULL,
				   NOTICE_BUTTON_YES, "Continue",
				   XV_SHOW, TRUE,
				      NULL);
		xv_destroy_safe(notice);
		return;

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `analyzeMenu (Check Dependencies)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
check_dependencies_callback(Menu_item item, Menu_generate op)
{
   Xv_notice notice;
   char buffer[200];
   struct task_node *loop_pointer;

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		/* check for dependency loop */
		traverse_task_list();

		if (loop_found) {
		   sprintf(buffer, "A dependency loop was found at "
			   "task %s", loop_pointer->data->name);
		   notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				      NOTICE_MESSAGE_STRINGS, 
				      buffer, NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return item;
		} else {
		   notice = xv_create(Main_mainWindow->mainWindow,
				      NOTICE,
				      NOTICE_MESSAGE_STRINGS,
				      "The dependencies are acceptable",
				      NULL,
				      NOTICE_BUTTON_YES, "Continue",
				      XV_SHOW, TRUE,
				      NULL);
		   xv_destroy_safe(notice);
		   return item;
		}

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `deleteButton'.
 *
 * Author: Mark M. Lacey
 *
 */
void
main_deleteButton_callback(Panel_item item, Event *event)
{
   int
     nrows;
   char
     *string;
   struct task_node
     *t1, /* nodes to traverse lists */
     *t2;
   Xv_notice       notice;
   struct task_node *temp_task;

	main_mainWindow_objects *ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
   /* if nothing has been selected, quit */
   if (selected == -1) {
      notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
			 NOTICE_MESSAGE_STRINGS, "You must first select a task to delete", NULL,
			 NOTICE_BUTTON_YES, "Continue",
			 XV_SHOW, TRUE,
			 NULL);
      xv_destroy_safe(notice);
      return;
   }

   string = (char *) xv_get(ip->taskList, PANEL_LIST_STRING, selected);
   temp_task = find_task(get_main_task_list(), string);

   if (!temp_task) return;

   /* first remove ourself from our dependency list, if we are there */
   t1 = find_task(temp_task->data->dependencies, temp_task->data->name);
   while (t1) {
      remove_task_node(temp_task->data->dependencies, t1);
      t1 = find_task(temp_task->data->dependencies, 
		     temp_task->data->name);
   }

   /* now remove ourself from all dependents lists */
   t1 = temp_task->data->dependencies->head;
   while (t1) {
      t2 = find_task(t1->data->dependents, temp_task->data->name);
      while (t2) {
	 remove_task_node(t1->data->dependents, t2);
	 t2 = find_task(t1->data->dependents, temp_task->data->name);
      }
      t1 = t1->next;
   }

   /* first remove ourself from our dependents list, if we are there */
   t1 = find_task(temp_task->data->dependents, temp_task->data->name);
   while (t1) {
      remove_task_node(temp_task->data->dependents, t1);
      t1 = find_task(temp_task->data->dependents, temp_task->data->name);
   }

   /* now remove ourself from all dependency lists */
   t1 = temp_task->data->dependents->head;
   while (t1) {
      t2 = find_task(t1->data->dependencies, temp_task->data->name);
      while (t2) {
	 remove_task_node(t1->data->dependencies, t2);
	 t2 = find_task(t1->data->dependencies, temp_task->data->name);
      }
      t1 = t1->next;
   }

   destroy_task_node(get_main_task_list(), temp_task);
   current_task = list_current(get_main_task_list());
   xv_set(ip->taskList, PANEL_LIST_DELETE, selected, NULL);

   nrows = (unsigned) xv_get(ip->taskList, PANEL_LIST_NROWS, NULL);

   if (nrows == 0) {
      xv_set(Taskinfo_taskinfoPopup->taskinfoPopup,
	     FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
      xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, XV_SHOW, FALSE,
	     NULL);
      xv_set(Dependencies_dependenciesPopup->dependenciesPopup,
	     FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
      xv_set(Dependencies_dependenciesPopup->dependenciesPopup, 
	     XV_SHOW, FALSE, NULL);
      return;
   }

   if (selected == nrows) selected = selected - 1;

   xv_set(ip->taskList, PANEL_LIST_SELECT, selected, TRUE, NULL);

   /* load the data for the new current item in the list */
   load_data_to_taskinfoPopup(current_task);
   fill_dependency_popup(current_task);
   fill_resource_popup(current_task);

	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

}

/*
 * Menu handler for `fileMenu (New Project)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
new_project_callback(Menu_item item, Menu_generate op)
{
   int nrows;

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		strcpy(project_filename, "untitled.prj");
		strcpy(export_filename, "untitled.tex");

		destroy_task_list(get_main_task_list());
		/* find the number of rows currently in the list, and */
		/* delete them */
		nrows = (int) xv_get(Main_mainWindow->taskList, PANEL_LIST_NROWS);
		xv_set(Main_mainWindow->taskList, PANEL_LIST_DELETE_ROWS, 0, nrows,
		       NULL);
		/* pop down the task info and dependencies popups */
		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, 
		       FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
		xv_set(Taskinfo_taskinfoPopup->taskinfoPopup, 
		       XV_SHOW, FALSE, NULL);

		xv_set(Dependencies_dependenciesPopup->dependenciesPopup, 
		       FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
		xv_set(Dependencies_dependenciesPopup->dependenciesPopup, 
		       XV_SHOW, FALSE, NULL);

		xv_set(Resources_resourcesPopup->resourcesPopup, 
		       FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
		xv_set(Resources_resourcesPopup->resourcesPopup, 
		       XV_SHOW, FALSE, NULL);
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `fileMenu (Save)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
save_callback(Menu_item item, Menu_generate op)
{
   Xv_notice notice;
   int status;
   char wd[256];
   struct stat     s_buf;	/* points to file stat structure */

   
   main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
   
   switch (op) {
    case MENU_DISPLAY:
      break;
      
    case MENU_DISPLAY_DONE:
      break;
      
    case MENU_NOTIFY:

      if (writefile_init(project_filename)==1) {
	 notice = xv_create(File_filePopup->filePopup, NOTICE,
			    NOTICE_MESSAGE_STRINGS, 
			    "Permission denied on file write", NULL,
			    NOTICE_BUTTON_YES, "Continue",
			    XV_SHOW, TRUE,
			    NULL);
	 xv_destroy_safe(notice);
      } 
      return item;
      break;
      
    case MENU_NOTIFY_DONE:
      break;
   }
   
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */
}

/*
 * Menu handler for `analyzeMenu (Date Calculation)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
calc_early_start_date(Menu_item item, Menu_generate op)
{
   Xv_notice notice;

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		calc_dates();
		load_data_to_taskinfoPopup(current_task);
		fill_dependency_popup(current_task);
		fill_resource_popup(current_task);
		notice = xv_create(Main_mainWindow->mainWindow, NOTICE,
				   NOTICE_MESSAGE_STRINGS, 
				   "Dates calculated and stored", NULL,
				   NOTICE_BUTTON_YES, "Continue",
				   XV_SHOW, TRUE,
				   NULL);
		xv_destroy_safe(notice);
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `exportMenu (Generate Task Sheet)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
task_list_callback(Menu_item item, Menu_generate op)
{
   Xv_notice notice;

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:

		latex_task_list();
		notice = xv_create(File_filePopup->filePopup, NOTICE,
				   NOTICE_MESSAGE_STRINGS, 
				   "LaTeX task sheet generated", NULL,
				   NOTICE_BUTTON_YES, "Continue",
				   XV_SHOW, TRUE,
				   NULL);
		xv_destroy_safe(notice);
		

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `exportMenu (Generate PERT Chart)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
latex_pert_callback(Menu_item item, Menu_generate op)
{
   Xv_notice notice;

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		generate_latex_pert_pages();
		notice = xv_create(File_filePopup->filePopup, NOTICE,
				   NOTICE_MESSAGE_STRINGS, 
				   "LaTeX PERT chart generated", NULL,
				   NOTICE_BUTTON_YES, "Continue",
				   XV_SHOW, TRUE,
				   NULL);
		xv_destroy_safe(notice);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `exportMenu (Generate Gantt Chart)'.
 *
 * Author: Mark M. Lacey
 *
 */
Menu_item
latex_gantt_callback(Menu_item item, Menu_generate op)
{
   Xv_notice notice;

	main_mainWindow_objects * ip = (main_mainWindow_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		generate_gantt_charts();

		notice = xv_create(File_filePopup->filePopup, NOTICE,
				   NOTICE_MESSAGE_STRINGS, 
				   "LaTeX Gantt chart generated", NULL,
				   NOTICE_BUTTON_YES, "Continue",
				   XV_SHOW, TRUE,
				   NULL);
		xv_destroy_safe(notice);

		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}
