/*****************************************************************************
 * slider.c: Demonstrate the Slider widget.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/ControlAre.h>
#include <Xol/Slider.h>

main(argc, argv)
  int argc;
  char *argv[];
{
  void       slider_callback();
  Widget     toplevel, con, slider1, slider2;

  toplevel = OlInitialize(argv[0], "Slider", NULL, 0, &argc, argv);
  con = XtCreateManagedWidget("control", controlAreaWidgetClass,
                              toplevel, NULL, 0);
  /*
   * Create two slider widgets and their callbacks.
   */
  slider1 = XtCreateManagedWidget("slider1", sliderWidgetClass,
                                  con, NULL, 0);
  slider2 = XtCreateManagedWidget("slider2", sliderWidgetClass,
                                  con, NULL, 0);
  XtAddCallback(slider1, XtNsliderMoved, slider_callback, slider2);
  XtAddCallback(slider2, XtNsliderMoved, slider_callback, slider1);

  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void
slider_callback(w, client_data, call_data)
  Widget w;
  XtPointer client_data, call_data;
{
  int n;
  int s1val, s2val, tmp;
  Arg wargs[1];
  Widget otherslider = (Widget)client_data;

  n = 0;
  if(strcmp(XtName(w), "slider1") == NULL) {
    tmp = s1val = *(int *)call_data;
    XtSetArg(wargs[n], XtNsliderValue, &s2val); n++;
    XtGetValues(otherslider, wargs, n);
  } else {
    tmp = s2val = *(int *)call_data;
    XtSetArg(wargs[n], XtNsliderValue, &s1val); n++;
    XtGetValues(otherslider, wargs, n);
  }
  if(s1val > s2val) {
    n = 0;
    XtSetArg(wargs[n], XtNsliderValue, tmp); n++;
    XtSetValues(otherslider, wargs, n);
  }
}
