/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "@(#)con.c	1.31 89/01/10";

/*
**	con [-quit-char] remote_tty[^quit-char]
**
**	Connect user to remote machine:- assumes "conn"
**	 or intelligent "getty" exists on any intermediate machine.
**	Uses "ttyconnect" system call.
**
**	SETUID ==> ROOT
*/

#define	FILE_CONTROL
#define	STAT_CALL
#define	STDIO
#define	TERMIOCTL
#define	TTYCONNECT

#include	"global.h"

#include	"Passwd.h"
#include	"state.h"

#include	<errno.h>
#include	<signal.h>
#include	<setjmp.h>


/*
**	Parameters
*/

char *		devnet		= DEVNET();
char *		remote;

#define		QUIT		'y'
#define		QUIT_SEP	'^'
#define		ENV_SEP		':'

char		quit		= QUIT;		/* default escape char */
char *		env;
char *		quitdescrpt	= "ctrl-";	/* escape prefix */

#define		TIMEOUT		20	/* give up line if no result after TIMEOUT secs */

/*
**	Miscellaneous
*/

char *		Name;		/* program invoked name */
char *		HomeNode;
NodeLink	LinkD;
int		Traceflag;
Passwd		User;
jmp_buf		alrm_jb;
jmp_buf		to_jb;
#if	SYSTEM < 3
struct sgttyb	orig_tty, new_tty;
#ifdef	TIOCGETC
struct tchars	orig_tchars;
struct tchars	null_tchars	= {-1,-1,-1,-1,-1,-1};
#endif	TIOCGETC
#ifdef	TIOCGLTC
struct ltchars	orig_ltchars;
struct ltchars	null_ltchars	= {-1,-1,-1,-1,-1,-1};
#endif	TIOCGLTC
#else	SYSTEM < 3
struct termio	orig_tty, new_tty;
#endif	SYSTEM < 3
int		done_stty;

#define		Fprintf	(void)fprintf
#define		Fflush	(void)fflush

#if	defined(SIGTSTP) && V8 == 0
int		onsusp();
#endif
#ifndef	TTYCONNECT
#ifdef	SIGIO
		oninput();
#endif
#endif	TTYCONNECT
int		alrmcatch(), sigcatch();
void		con(), execute(), finish();




int
main(argc, argv)
	int		argc;
	register char *	argv[];
{
	register char *	qp;
	bool		quitset;
	extern char *	getenv();

	Name = *argv++;
	if ( (qp = strrchr(Name, '/')) != NULLSTR )
		Name = qp+1;
	
	if ( argc != 2 && argc != 3 )
	{
		Error("Usage: %s [-quit-char] remote-host[^quit-char][:env]", Name);
		exit(1);
	}

	if ( !GetUser(&User, getuid()) )
	{
		Error(User.P_error);
		exit(1);
	}

	HomeNode = NodeName();

	if ( okuse() )
	{
		if ( argc == 3 && argv[0][0] == '-' )
		{
			quit = argv[0][1];
			argv++;
			quitset = true;
		}
		else
			quitset = false;

		if ( (qp = strchr(argv[0], ENV_SEP)) != NULLSTR )
		{
			env = qp + 1;
			*qp = '\0';
		}
#		define	PASS_CON_TERM	1
#		if	PASS_CON_TERM
#		if	BSD4
#		define	ENV_LOGIN_NAME	"USER"
#		else	BSD4
#		define	ENV_LOGIN_NAME	"LNAME"
#		endif	BSD4
		else
		{
			static char lbuf[80];
			char *termp, *getenv();
			if((termp=getenv("TERM")) != NULL)
			{
				char *lp;
				if
				(
					User.P_uid
					||
					(lp = getenv(ENV_LOGIN_NAME)) == NULL
				)
					sprintf
					(
						lbuf,
						"TERM=%s:LNAME=%s",
						termp,
						User.P_name
					);
				else
					sprintf
					(
						lbuf,
						"TERM=%s:LNAME=%s",
						termp,
						getenv(ENV_LOGIN_NAME)
				);
				env = lbuf;
			}
		}
#endif		PASS_CON_TERM

		if ( !quitset )
		{
			if ( (qp = strrchr(argv[0], QUIT_SEP)) != NULLSTR )
			{
				quit = qp[1];
				*qp = '\0';
			}
			else
			if ( (qp = getenv("CONTERM")) != NULLSTR )
				quit = *qp;
		}

		con(argv[0]);
		exit(0);
	}

	Error("illegal use!");
	exit(1);
}


void
con(target)
	char *		target;
{
	register char *	port;
	register char *	link;
	int		fd;
	bool		end_to_end;
	bool		find_error;
	FILE *		remotefd;
	char		sobuf[BUFSIZ];
	extern		errno;

	if ( strcmp(target, HomeNode) == STREQUAL )
	{
		Error("This IS %s!\07", HomeNode);
		return;
	}

	if ( (link = FindAlias(target)) == NULLSTR )
		link = target;
	else
		target = link;

	if
	(
		!(User.P_flags & P_CANCON)
#		ifdef	LOCAL_NODES
		&&
		!InList(target, LOCAL_NODES, NULLSTR)
#		endif	LOCAL_NODES
	)
	{
		Error("No permission.");
		exit(1);
	}

	if ( FindNode(link, pt_con, &LinkD) )
	{
		find_error = false;
		link = LinkD.nl_name;

		if ( LinkD.nl_connector != NULLSTR )
		{
			execute(LinkD.nl_connector, link, target);
			return;
		}
	}
	else
		find_error = true;

	remote = concat(devnet, target, "0", NULLSTR);

	if ( access(remote, 0) == SYSERROR )
	{
		free(remote);

		remote = concat(devnet, link, "0", NULLSTR);

		if ( access(remote, 0) == SYSERROR )
		{
			if ( find_error )
				Error("destination \"%s\" %s", target, LinkD.nl_name);
			else
				Syserror("link via \"%s\" to \"%s\" unavailable", link, target);

			return;
		}
	}
	else
		link = target;

	end_to_end = (bool)(link == target || strcmp(link, target) == 0);
	port = remote + strlen(remote) - 1;

	if ( setjmp(alrm_jb) )
	{
		Error("line hung");
		return;
	}

	(void)signal(SIGALRM, alrmcatch);
	(void)alarm(TIMEOUT);

	while
	(
		(fd = open(remote, O_EXCL|O_RDWR)) == SYSERROR
#		if	V8 == 1
		||
		ioctl(fd, FIOALOCK, 0) == SYSERROR
#		endif	V8 == 1
#		if	FLOCK
		||
		flock(fd, LOCK_EX|LOCK_NB) == SYSERROR
#		endif	FLOCK
	)
		if
		(
			(
				errno == ENXIO
				||
				errno == EPERM
#				ifdef	EOPENFAIL
				||
				errno == EOPENFAIL
#				endif	EOPENFAIL
#				ifdef	EWOULDBLOCK
				||
				errno == EWOULDBLOCK
#				endif	EWOULDBLOCK
			)
			&&
			*port != '9'
		)
		{
			(*port)++;
		}
		else
		{
			if ( errno == ENOENT && *port != '0' )
				Error("link to %s busy", target);
			else
				Syserror("can't open link \"%s\" to %s", link, target);

			return;
		}

#	ifdef	TIOCEXCL
	(void)ioctl(fd, TIOCEXCL, (char *)0);
#	endif

	/*
	**	Put circuit in RAW mode, don't change speed.
	**	(For SYSTEM xx, set VMIN to min, VTIME to min, turn on XON/XOFF.)
	*/

#	if	BSD4 < 3 /* daved changed from just "if BSD" */
	(void)SetRaw(fd, 0, 1, 1, false);
#	else
	(void)SetRaw(fd, 0, 1, 1, true);
#	endif

	if ( (remotefd = fdopen(fd, "r+")) == NULL )
	{
		Syserror("fdopen failed on %s file %d", remote, fd);
		return;
	}

	if ( setjmp(to_jb) || setjmp(alrm_jb) )
	{
		finish(1);
		return;
	}

	(void)signal(SIGHUP, sigcatch);
	(void)signal(SIGINT, sigcatch);
	(void)signal(SIGQUIT, sigcatch);
	(void)signal(SIGPIPE, sigcatch);
#	if	defined(SIGTSTP) && V8 == 0
	(void)signal(SIGTSTP, onsusp);
#	endif

#	if	SYSTEM < 3
	if ( gtty(0, &orig_tty) != SYSERROR )
	{
		done_stty = 1;
		new_tty = orig_tty;
		new_tty.sg_flags &= ~(ECHO|CRMOD);
		new_tty.sg_flags |= CBREAK;
#		ifdef	TIOCGETC
		new_tty.sg_erase = -1;
		new_tty.sg_kill = -1;
#		endif	TIOCGETC
		(void)stty(0, &new_tty);
#		ifdef	TIOCGETC
		(void)ioctl(0, TIOCGETC, &orig_tchars);
		null_tchars.t_startc = orig_tchars.t_startc;
		null_tchars.t_stopc = orig_tchars.t_stopc;
		(void)ioctl(0, TIOCSETC, &null_tchars);
#		endif	TIOCGETC
#		ifdef	TIOCGLTC
		(void)ioctl(0, TIOCGLTC, &orig_ltchars);
		if (orig_ltchars.t_suspc != (quit&037))
			null_ltchars.t_suspc = orig_ltchars.t_suspc;
		if (orig_ltchars.t_dsuspc != (quit&037))
			null_ltchars.t_dsuspc = orig_ltchars.t_dsuspc;
		if (orig_ltchars.t_flushc != (quit&037))
			null_ltchars.t_flushc = orig_ltchars.t_flushc;
		if (orig_ltchars.t_lnextc != (quit&037))
			null_ltchars.t_lnextc = orig_ltchars.t_lnextc;
		(void)ioctl(0, TIOCSLTC, &null_ltchars);
#		endif	TIOCGLTC
	}
#	else	SYSTEM < 3
	if ( ioctl(0, TCGETA, &orig_tty) != SYSERROR )
	{
		done_stty = 1;
		new_tty = orig_tty;
		new_tty.c_iflag &= ~(BRKINT|ISTRIP|INLCR|ICRNL|IGNCR|IUCLC);
		new_tty.c_iflag |= IGNBRK;
		new_tty.c_oflag &= ~(OLCUC|ONLCR|OCRNL|ONOCR|ONLRET);
		new_tty.c_lflag &= ~(ISIG|ICANON|ECHO);
		new_tty.c_cc[VMIN] = 1;
		new_tty.c_cc[VTIME] = 1;
		(void)ioctl(0, TCSETA, &new_tty);
	}
#	endif	SYSTEM < 3

	(void)chown(remote, User.P_uid, User.P_gid);	/* indicate current user of the log line */
	(void)chmod(remote, 0600);			/* protect against other access */

	/*
	** logically connect local terminal to remote until quit char received
	*/

	setbuf(stdout, sobuf);
	Fprintf(stdout, " %s -> %s ('%s%c'=quit)\r\n", HomeNode, link, quitdescrpt, quit);
	Fflush(stdout);
	setbuf(stdout, NULLSTR);
	setbuf(remotefd, sobuf);

	(void)alarm(0);
	sleep(2);	/* allow getty to start up */

	if ( !end_to_end || env != NULL )
	{
		if ( quit != QUIT )
			Fprintf(remotefd, "@@:%s%c%c", target, QUIT_SEP, quit);
		else
			Fprintf(remotefd, "@@:%s", target);
		if ( env != NULL )
			Fprintf(remotefd, ":%s", env);
	}

	Fprintf(remotefd, "\n");

	Fflush(remotefd);

	if ( ttyconnect(0, fileno(remotefd), CONNECT, quit&037) == SYSERROR )
	{
		Syserror("connect to link \"%s\" failed", link);
		finish(1);
	}

#	ifndef	TTYCONNECT
#	ifdef	SIGIO
	Fprintf(remotefd, "@@\004\004%c@@\004\004@", quit&037);
	finish(0);	/* Fast exit (but maybe it only works with xt) */
#	endif	SIGIO

	if ( setjmp(to_jb) || setjmp(alrm_jb) )
	{
		finish(0);
		return;
	}
#	endif	TTYCONNECT

	(void)signal(SIGPIPE, SIG_IGN);
	(void)alarm(3);

	Fprintf(remotefd, "@@\004\004%c@@\004\004@", quit&037);
	Fflush(remotefd);
	(void)alarm(0);
	(void)sleep(2);

	finish(0);
}



#ifndef	TTYCONNECT
#ifdef	SIGIO
static	int	localfd;
static	int	remotefd;
static	char	quitchar;
#endif	SIGIO

int
ttyconnect(local, remote, ignore, quitc)
	int	local, remote, ignore;
	char	quitc;
{
#ifdef	SIGIO
	remotefd = remote;
	localfd = local;
	quitchar = quitc;
	signal(SIGIO, oninput);
	fcntl(0,F_SETFL,FASYNC);
#ifdef	EBUG
	if (fcntl(0,F_GETOWN) != getpid() && -fcntl(0,F_GETOWN) != getpgrp(0))
		Error("F_GETOWN = %d", fcntl(0,F_GETOWN));
#endif
	while (quitchar != -1)
	{
		int	nin;
		char	buf[BUFSIZ];
		nin = read(remote, buf, BUFSIZ);
		if (nin > 0)
			write(local, buf, nin);
		else
			break;	/* EOF from remote */
	}
	return 0;
#else	SIGIO
	register int	n;
	int		child;
#	if	SYSTEM < 3 && V8 == 0
	char		c[1];
#	else	SYSTEM < 3 && V8 == 0
	char		c[16];
#	endif	SYSTEM < 3 && V8 == 0

#	if	V8 == 1
	int		r_ld;
	extern int	buf_ld;

	r_ld = ioctl(remote, FIOPOPLD, 0);

	(void)ioctl(remote, FIOPUSHLD, &buf_ld);
#	endif	V8 == 1

	switch ( child = fork() )
	{
	 case 0:	/*
			**	Child copies remote to user
			*/
			if ( setjmp(to_jb) )
				goto eof;
#			ifdef	TIOCSPGRP
			(void)ioctl(remote, TIOCSPGRP, (char *)0);
#			endif

			(void)signal(SIGHUP, sigcatch);

			while ( (n = read(remote, c, sizeof c)) >= 1 )
				(void)write(local, c, n);
		eof:
			(void)write(local, "\r\n(EOF)\r\n", 9);
			kill(getppid(), SIGHUP);
			exit(0);

	 case SYSERROR:
			Syserror("can't fork, try again");
			return SYSERROR;

	 default:	/*
			**	Parent copies user to remote
			**	and intercepts escape
			*/

			if ( !setjmp(to_jb) )
			{
				while( (n = read(local, c, sizeof c)) >= 1 )
				{
					if ( (c[0] & 0177) == quitc )
						break;
					else
						(void)write(remote, c, n);
				}
			}

			(void)write(local, "\r\n(QUIT)\r\n", 10);

			(void)kill(child, SIGKILL);

			if ( !setjmp(alrm_jb) )
			{
				(void)alarm(2);
				(void)wait(&child);
				(void)alarm(0);
			}
	}

#	if	V8 == 1
	(void)ioctl(remote, FIOPOPLD, 0);

	if ( r_ld != SYSERROR )
		(void)ioctl(remote, FIOPUSHLD, &r_ld);
#	endif	V8 == 1

	return 0;
#endif	SIGIO
}
#endif	TTYCONNECT



int
alrmcatch(sig)
	int	sig;
{
	(void)signal(sig, SIG_IGN);
	longjmp(alrm_jb, 1);
	return 0;
}



int
sigcatch(sig)
	int	sig;
{
	(void)signal(sig, SIG_IGN);
	longjmp(to_jb, 1);
	return 0;
}



#if	defined(SIGTSTP) && V8 == 0
/*
**	Come here when we get a suspend signal from the terminal
*/

int
onsusp ()
{
	/* ignore SIGTTOU so we don't get stopped if csh grabs the tty */
	signal(SIGTTOU, SIG_IGN);
	if (done_stty)
	{
#		if	SYSTEM < 3
		(void)stty(0, &orig_tty);
#		ifdef	TIOCGETC
		(void)ioctl(0, TIOCSETC, &orig_tchars);
#		endif	TIOCGETC
#		ifdef	TIOCGLTC
		(void)ioctl(0, TIOCSLTC, &orig_ltchars);
#		endif	TIOCGLTC
#		else	SYSTEM < 3
		(void)ioctl(0, TCSETA, &orig_tty);
#		endif	SYSTEM < 3
	}
	signal(SIGTTOU, SIG_DFL);
	/* Send the TSTP signal to suspend our process group */
	signal(SIGTSTP, SIG_DFL);
	sigsetmask(0);
	kill (0, SIGTSTP);
	/* Pause for station break */

	/* We're back */
	signal (SIGTSTP, onsusp);
	if (done_stty)
	{
#		if	SYSTEM < 3
		(void)stty(0, &new_tty);
#		ifdef	TIOCGETC
		(void)ioctl(0, TIOCSETC, &null_tchars);
#		endif	TIOCGETC
#		ifdef	TIOCGLTC
		(void)ioctl(0, TIOCSLTC, &null_ltchars);
#		endif	TIOCGLTC
#		else	SYSTEM < 3
		(void)ioctl(0, TCSETA, &new_tty);
#		endif	SYSTEM < 3
	}
}
#endif	defined(SIGTSTP) && V8 == 0



#ifndef	TTYCONNECT
#ifdef	SIGIO
int
oninput()
{
	int	nin;
	int	blk;
	char	buf[BUFSIZ];
	char	*p;

	while (1)
	{
		ioctl(localfd,FIONREAD,&nin);
		if (nin <= 0)
			break;
		blk = (nin > BUFSIZ) ? BUFSIZ : nin;
		nin = read(localfd, buf, blk);
		for (p = buf + nin -1; p >= buf; p--)
			if ((*p & 0177) == quitchar)
			{
				nin = p - buf; /* don't write beyond quit */
				write(remotefd, buf, nin);
				nin = 0;	/* don't rewrite below */
				/*
				** normal exit is triggered in remote reader
				** loop by the change to quitchar
				** after the write we have just done
				** has been echoed, but if the remote circuit
				** has died and/or is not echoing we will
				** hang on the read in that loop.
				** setting the FNDELAY flag will stop the
				** block on the read
				*/
				quitchar = -1;
				fcntl(remotefd,F_SETFL,FNDELAY);
			}
		if (nin > 0)
			write(remotefd, buf, nin);
	}
}
#endif	SIGIO
#endif	TTYCONNECT



void
finish(error)
	int	error;
{
	if ( remote != NULLSTR && remote[0] != '\0' )
		(void)chown(remote, ACSNETUID, ACSNETGID);	/* change back to daemon */
	if (done_stty)
	{
#		if	SYSTEM < 3
		(void)stty(0, &orig_tty);
#		ifdef	TIOCGETC
		(void)ioctl(0, TIOCSETC, &orig_tchars);
#		endif	TIOCGETC
#		ifdef	TIOCGLTC
		(void)ioctl(0, TIOCSLTC, &orig_ltchars);
#		endif	TIOCGLTC
#		else	SYSTEM < 3
		(void)ioctl(0, TCSETA, &orig_tty);
#		endif	SYSTEM < 3
	}
	exit(error);
}



/*
**	Validate that con is not being used with any
**	standard input or output redirection
**	- this includes asynchronous use.
**	The test checks that file descriptors 0, 1, and 2
**	represent the same tty.
*/

int
okuse()
{
	register int	i;
	struct stat	sbuf[3];

	for ( i = 0 ; i < 3 ; i++ )
		if
		(
			fstat(i, &sbuf[i]) == SYSERROR			/* stat failed ??? */
			||
			(sbuf[i].st_mode & S_IFMT) != S_IFCHR		/* not a tty */
			||
			i
			&&
			(
				sbuf[i].st_dev != sbuf[i-1].st_dev
				||
				sbuf[i].st_ino != sbuf[i-1].st_ino	/* some sort of redirection */
		        )
		)
			return 0;

	return 1;
}



/*
**	Execute connector program.
*/

void
execute(prog, link, target)
	char *	prog;
	char *	link;
	char *	target;
{
	VarArgs	va;

	FIRSTARG(&va) = prog;
	NEXTARG(&va) = newstr("-y");
	LASTARG(&va)[1] = quit;
	NEXTARG(&va) = concat("-l", link, NULLSTR);
	NEXTARG(&va) = target;
	NEXTARG(&va) = NULLSTR;

	(void)execve(ARG(&va, 0), &ARG(&va, 0), StripEnv());
	Syserror("Can't execve \"%s\"", ARG(&va, 0));
}
