/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)RdStCommands.c	1.3 85/05/03
*/

/*
**	Open commands file and read it.
*/

#define	FILE_CONTROL
#define	STDIO

#include	"global.h"


static char *	CommandsFile;

extern void	Rcommands();


void
RdStCommands(warn)
	bool		warn;
{
	register FILE *	fd;

	if ( CommandsFile == NULLSTR )
		CommandsFile = COMMANDSFILE;
	
	if ( (fd = fopen(CommandsFile, "r")) != NULL )
	{
		Rcommands(fd, warn);
		(void)fclose(fd);
	}
	else
	if ( warn )
		Warn("can't read \"%s\"", CommandsFile);
}



void
SetCommands(newfile)
	char *		newfile;
{
	register int	fd;

	if ( (fd = open(newfile, O_READ)) == SYSERROR )
	{
		Syserror("Can't read \"%s\"", newfile);
		return;
	}

	(void)close(fd);

	if ( CommandsFile != NULLSTR )
		free(CommandsFile);

	CommandsFile = newstr(newfile);
}
