/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)FindDomain.c	1.7 86/01/05
*/

/*
**	Given domain name, find link on shortest path.
**	If the domain is one of ours, then link will be our node index instead.
**
**	Uses binary search to find domain in routing tables.
**
**	If link found, return 'true' with details in "*nlp".
**
**	If a shortest path cannot be found,
**	return 'false' with an error reason in nlp->nl_name.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"


bool
FindDomain(domain, nlp)
	char *		domain;	/* Domain to be located */
	NodeLink *	nlp;	/* Where to put the info. */
{
	register char *	cp1;	/* String comparison temporary */
	register char *	cp2;	/* String comparison temporary */
	register char *	l;	/* First domain in table */
	register char *	u;	/* Last domain in table */
	register int	n;	/* Number of domains in table */
	register char *	i;	/* Approximate middle domain in table*/

	Trace2(1, "FindDomain \"%s\"", domain);

	if ( RouteBase == NULLSTR )
		if ( !ReadRoute() )
		{
			nlp->nl_name = "unknown (no routing table)";
			return false;
		}

	nlp->nl_index = LINK_N_A;
	nlp->nl_domind = LINK_N_A;

	n = DomainCount-1;
	l = DomainTable;
	u = &l[DOMAIN_ENTRY_SIZE * n];

	while ( u >= l )
	{
		i = &l[DOMAIN_ENTRY_SIZE * (n/2)];

#		if	DEBUG
		if ( Traceflag >= 2 )
		{
			int	index;
			char *	name;

			if ( (index = ((DomainEntry *)i)->de_shortest) == LINK_N_A )
			{
				index = -1;
				name = "(N/A)";
			}
			else
			{
				if ( index < LinkCount )
					index = RT_LINK(index)->le_index;
				name = RT_NODE(index)->ne_name;
			}

			Trace
			(
				2,
				"FindDomain => \"%s\", link index %d, node index %d, node name \"%s\"",
				((DomainEntry *)i)->de_name,
				((DomainEntry *)i)->de_shortest,
				index,
				name
			);
		}
#		endif	DEBUG

		for
		(
			cp1 = domain, cp2 = ((DomainEntry *)i)->de_name ;
			((*cp1)|040) == ((*cp2++)|040) ;
		)
		{
			if ( *cp1++ != '\0' )
				continue;

			if ( (n = ((DomainEntry *)i)->de_shortest) == LINK_N_A )
			{
				nlp->nl_name = "unreachable";
				return false;
			}

			nlp->nl_domind = (i-DomainTable)/DOMAIN_ENTRY_SIZE;

			if ( (nlp->nl_link = n) < LinkCount )
			{
				l = (char *)RT_LINK(n);
				nlp->nl_index = ((LinkEntry *)l)->le_index;
				nlp->nl_name = RT_NODE(nlp->nl_index)->ne_name;
				nlp->nl_flags = ((LinkEntry *)l)->le_flags;

				if ( n = ((LinkEntry *)l)->le_handlers[PT_MSG] )
					nlp->nl_spooler = &Strings[n];
				else
					nlp->nl_spooler = NULLSTR;

				if ( n = ((LinkEntry *)l)->le_handlers[PT_CON] )
					nlp->nl_connector = &Strings[n];
				else
					nlp->nl_connector = NULLSTR;

				if ( n = ((LinkEntry *)l)->le_caller )
					nlp->nl_caller = &Strings[n];
				else
					nlp->nl_caller = NULLSTR;

				if ( n = ((LinkEntry *)l)->le_filter )
					nlp->nl_filter = &Strings[n];
				else
					nlp->nl_filter = NULLSTR;
			}
			else
			{
				nlp->nl_index = n;
				nlp->nl_name = RT_NODE(n)->ne_name;
				nlp->nl_flags = 0;

				if ( n = ((DomainEntry *)i)->de_handler )
					nlp->nl_spooler = &Strings[n];
				else
					nlp->nl_spooler = NULLSTR;

				nlp->nl_connector = NULLSTR;
				nlp->nl_caller = NULLSTR;
				nlp->nl_filter = NULLSTR;
			}

			return true;
		}

		if ( (*cp1|040) < (*--cp2|040) )
			u = i-DOMAIN_ENTRY_SIZE;
		else
			l = i+DOMAIN_ENTRY_SIZE;

		n = (u-l)/DOMAIN_ENTRY_SIZE;
	}

	nlp->nl_name = "unknown";

	return false;
}
