/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)DomInHier.c	1.1 85/08/16
*/

/*
**	Given pointer to a domain index,
**	return name of domain that is inside given domain,
**	and update pointed to index to new domain
**
**	Return NULLSTR otherwise.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"


char *
DomInHier(indexp)
	int *		indexp;
{
	register int	domain;

	if ( (domain = *indexp) >= DomainCount )
		return NULLSTR;
	
	if ( (domain = RT_DOMAIN(domain)->de_hierarchy) >= DomainCount )
		return NULLSTR;

	if ( domain == 0 )
		return NULLSTR;

	if ( (domain = *RT_LEVEL(domain-1)) >= DomainCount )
		return NULLSTR;

	*indexp = domain;

	return RT_DOMAIN(domain)->de_name;
}
