/*
**	Header file for caller programs.
**
**	SCCSID @(#)caller.h	1.18 89/02/25
*/

/*
**	The pre-defined daemon names and identifiers
*/

#define	NOGOMSG		"daemon already active"
#define	START2MSG	"daemon 2 starts ..."
#define	STARTMSG	"daemon starts ..."
#define	TIMEOUT		"TIMEOUT"
#define EOFSTR		"-EOF-"
#define	LOCKED		"Device Locked"
#define	OPENFAIL	"Device Open Failed"
#define	OPENED		"OK - Device Open"

#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif
#ifndef	SHELLARGS
#define	SHELLARGS	"shellargs"
#endif

#define	CNSHELL		"CNshell"
#define	CNDAEMON	INSLIB(CNdaemon)
#define	CNSTARTS	START2MSG

#define	NNSTARTS	STARTMSG
#define	NNSHELL		"NNshell"

#define	PNSHELL		"PNshell"
#define	PNDAEMON	INSLIB(PNdaemon)
#define	PNSTARTS	"PNdaemon starts"

/*
**	Structure for the pattern/action pairs
*/

typedef struct patlist 
{
	char *	pattern;	/* "pattern" is compiled into "comp_pat" */
	int	(*func)();	/* Function called
				   if current input line matches "pattern" */
	char *	comp_pat;	/* Will hold compiled version of "pattern",
				   should be "free()"d and set to NULLSTR
				   if "pattern" is changed dynamically */
}
		PatList;

/*
**	"func" will be called with up to 12 arguments:
**		a pointer to where the match started,
**		a pointer to where the match ended,
**		and optional pointers returned by "regcmp()"
**		if any "(...)$n" expressions were used in "pattern".
*/

/*
**	The following global variables can also be accessed
*/

extern PatList *current;	/* Current "pattern" */
extern char *	delim;		/* Array of bytes that can delimit input lines
				   -- default:- ":\r\n" */
#define	LINESIZE	40	/* Maximum size of input line that can be matched */
extern char	input[];	/* Current input line */
extern int	inputlen;	/* Length of "input" */
extern int	Traceflag;	/* Outputs NNcall "trace" commands:-
				   if > 0: for "getinput" and "Command",
				   if > 2: for pattern matches */

/*
**	Function definitions
*/

extern void
		Command(),	/* Output a null terminated command to NNcall */
		flushinput(),	/* Flush all input queued to date */ 
		getinput(),	/* Read in new input line */
		init(),		/* User provided initialisation routine */
		out(),		/* Output a string to NNcall */
		outend(),	/* Output a null terminated string to NNcall */
		reset(),	/* Reset "current" to beginning of table, and call "getinput()" */
		state();	/* Change to new table of "patlist"s */

extern char	
		*expandstr(),
		*regcmp(),
		*regex(),
		*strcat();

extern bool	readargs();	/* Extract arguments from file, and pass back */
