/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)strccmp.c	1.1 85/02/17
*/

/*
**	Compare two strings in a case-independant way similar to "strcmp()".
*/

int
strccmp(s1, s2)
	register char *	s1;
	register char *	s2;
{
	register int	c1;
	register int	c2;

	while ( c1 = *s1++ )
	{
		if ( (c2 = *s2++) == 0 )
			return 1;

		if ( (c1 |= 040) != (c2 |= 040) )
			return (c1&0xff) - (c2&0xff);
	}

	return -((*s2)&0xff);
}
