/*
**  SYSEXITS.H -- Exit status codes for system programs.
**
**	This include file attempts to categorize possible error
**	exit statuses for system programs, notably delivermail
**	and the Berkeley network.
**
**	Error numbers begin at EX__BASE to reduce the possibility of
**	clashing with other exit statuses that random programs may
**	already return.
**
**	Maintained by Eric Allman (eric@berkeley, ucbvax!eric) --
**		please mail changes to me.
**
**			@(#)sysexits.h	4.2		7/31/83
*/

#define EX_OK		0	/* successful termination */

#define EX__BASE	64	/* base value for error messages */

#define EX_USAGE	(EX__BASE+0)	/* command line usage error */
#define EX_DATAERR	(EX__BASE+1)	/* data format error */
#define EX_NOINPUT	(EX__BASE+2)	/* cannot open input */
#define EX_NOUSER	(EX__BASE+3)	/* addressee unknown */
#define EX_NOHOST	(EX__BASE+4)	/* host name unknown */
#define EX_UNAVAILABLE	(EX__BASE+5)	/* service unavailable */
#define EX_SOFTWARE	(EX__BASE+6)	/* internal software error */
#define EX_OSERR	(EX__BASE+7)	/* system error (e.g., can't fork) */
#define EX_OSFILE	(EX__BASE+8)	/* critical OS file missing */
#define EX_CANTCREAT	(EX__BASE+9)	/* can't create (user) output file */
#define EX_IOERR	(EX__BASE+10)	/* input/output error */
#define EX_TEMPFAIL	(EX__BASE+11)	/* temp failure; user is invited to retry */
#define EX_PROTOCOL	(EX__BASE+12)	/* remote error in protocol */
#define EX_NOPERM	(EX__BASE+13)	/* permission denied */

#define	EX_NEWMESG	(EX__BASE+40)	/* message has been updated */
#define	EX_DROPMESG	(EX__BASE+41)	/* message should be dropped */
#define	EX_RETMESG	(EX__BASE+42)	/* message should be returned */
#define	EX_EXMESG	(EX__BASE+43)	/* message shouldn't be delivered locally */
