/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)WriteFtHead.c	1.2 85/12/19
*/

/*
**	Write out file transfer header at end of data.
**
**	Assumes that "FthFields" has been set up properly.
**
**	Result, if not SYSERROR, is the number of bytes in the header.
*/

#include	"global.h"

#include	"debug.h"
#include	"ftheader.h"



int
WriteFtHeader(fd, start, ack, datacrc)
	int			fd;
	long			start;
	bool			ack;
	bool			datacrc;
{
	register char **	fp;
	register int		n;
	register char *		cp;
	register int		r;
	register int		bytes;
	Crc_t			crc;
	char *			savetype = FthType;
	char			length[FTH_LENGTH_SIZE+1];
	static char		type[2];

	(void)lseek(fd, start, 0);

	FthType = type;
	type[0] = FTH_TYPE;
	if ( ack )
		type[0] |= FTH_ACK;
	if ( datacrc )
		type[0] |= FTH_DATACRC;
	type[1] = '\0';

	for
	(
		fp = FthFields.fth_start, crc = 0, bytes = 0 ;
		fp < &FthFields.fth_start[NFTHFIELDS] ;
		fp++
	)
	{
		if ( (cp = *fp) == NULLSTR )
		{
			cp = "";
			n = 1;
		}
		else
			n = strlen(cp)+1;	/* Add 1 for null */

		bytes += n;

		crc = acrc(crc, cp, n);

		while ( (r = write(fd, cp, n)) != n )
		{
			if ( r == SYSERROR )
				return SYSERROR;
			cp += r;
			n -= r;
		}
	}

	/*
	**	Assume that 2*CRC_SIZE <= FTH_LENGTH_SIZE
	*/

	DODEBUG(if(CRC_SIZE!=2||FTH_LENGTH_SIZE<(2*CRC_SIZE))Fatal("CRC_SIZE"));

	cp = length;

	*cp++ = LOCRC(DataCrc);
	*cp++ = HICRC(DataCrc);

	crc = acrc(crc, length, CRC_SIZE);

	*cp++ = LOCRC(crc);
	*cp = HICRC(crc);

	if ( write(fd, length, 2*CRC_SIZE) != 2*CRC_SIZE )
		return SYSERROR;

	bytes += 2 * CRC_SIZE;

	(void)strclr(length, sizeof length);
	(void)sprintf(length, "%d", bytes);

	if ( write(fd, length, FTH_LENGTH_SIZE) != FTH_LENGTH_SIZE )
		return SYSERROR;

	if ( savetype != NULLSTR )
		FthType = savetype;

	return FthLength = bytes + FTH_LENGTH_SIZE;
}
