#!/bin/sh

# run daily to make WHOISFILE for SunIII "whois" handler (peter)

: ${WHOISFILE=/usr/pub/whois}

(
awk -F: '
# ignore "system" users, junk accounts, and trash
$3 < 20		{ next }
$3 == 199	{ next }
$3 > 5000	{ next }

# and anyone whose name that we do not like
/^dday:/	{ next }
/^player:/	{ next }
/^soss:/	{ next }
/^test:/	{ next }
/^today:/	{ next }
/^tostude:/	{ next }
/^uucp:/	{ next }
/^visitor:/	{ next }
/^[0-9]/	{ next }
/^st[0-9]+:/	{ next }
/^it[0-9]+:/	{ next }

# ignore anything that has an unusual looking shell
$7 != "" && $7 !~ /sh$/	{ next }

# or anyone who has an impossible passwd
length($2)!=13	{ next }

# and finally, anyone whose full name is obviously stupid
# (some of these are inserted by our account generation program)
$5 ~ /^NAME/	{ next }
$5 ~ /kre-trash/ { next }

# when we have a passwd line to keep, convert "&" in fullname field & dump it
		{	name = $5
			while (i = index(name, "&"))
				name = substr(name, 1, i-1) $1 substr(name, i+1)
			printf "%s:%s\n", $1, name
		}

' /etc/passwd

echo "root:any of - kre pje ajm andrew"
echo "postmaster:kre"

) | tr A-Z a-z | sort -u > ${WHOISFILE}.new

cmp -s ${WHOISFILE}.new ${WHOISFILE} || mv ${WHOISFILE}.new ${WHOISFILE}
