/*
**	patterns and functions to call basser from munnari
**
**	SCCSID @(#)munnari.c	1.3 84/07/04
*/

#include	"global.h"
#include	"caller.h"
#include	"basser.q"

#ifndef	CSIRO_PASSWD
#define	CSIRO_PASSWD	""
#endif
#ifndef	BASSER_PASSWD
#define	BASSER_PASSWD	""
#endif
#ifndef	CALLARGS
#define	CALLARGS	"callargs"
#endif

extern	int	Traceflag;

extern struct patlist	*current;

char
	*daemon1 = NNDAEMON,		/* standard daemon */
	*daemon2 = NN2DAEMON,		/* alternate protocol */
	*host	 = "munnari",		/* connecting from munnari */
	*target  = "basser",		/* connecting to basser */
	*csirorq = CSIRO_PASSWD,
	*hostflg = "-CBF",		/* cooked protocol over csironet */
	*passwd  = BASSER_PASSWD,
	*device  = "/dev/net/dmtmelb2",
	*speed   = "1200",
	*retry	 = "30",		/* seconds between open attempts */
	*retries = "3",			/* times to attempt open */
	*delay	 = "15";		/* TIMEOUT every delay seconds */

int
	fcount	 = 0,	/* count of gross failures */
	tcount	 = 0,	/* count of timeouts */
	ccount	 = 0,	/* count of CSIRONET login attempts */
	mcount	 = 0,	/* count of stray CSIRONET messages */
	lcount	 = 0;	/* count of Unix login attempts */

char	*pump;		/* current string to prompt response from remote */

struct patlist *tostate;/* state to enter on timeout */

int
	atcsironet(),
	csirologin(),
	eof(),
	failure(),
	gotlogin(),
	gotpasswd(),
	netlogin(),
	slowhost(),
	started(),
	start2(),
	timeout(),
	tobasser(),
	tocsironet(),
	tounixnet();

struct patlist dmtlogin[] =
{
	{ "[Ll]ogin", netlogin },
	{ TIMEOUT, failure },
	{ ERRSTR, failure },
	{ EOFSTR, eof },
	{0, 0}
};

struct patlist unixnet[] =
{
	{ "dmtmelb.*->", tocsironet },
	{ "UNRECOGNISED FIRST RECORD", tocsironet },
	{ "TERMINAL IS UNASSIGNED", tocsironet },
	{ "INVALID LOGIN REQUEST", tocsironet },
	{ "DISCONNECT SEEN FROM", tocsironet },
	{ "[Ll]ine hung", failure },
	{ "[Nn]o free port", failure },		/* ?? is this right msg ?? */
	{ TIMEOUT, failure },
	{ ERRSTR, failure },
	{ EOFSTR, eof },
	{0, 0}
};

struct patlist	csironet[] =
{
	{ "TERMINAL IS UNASSIGNED", csirologin },
	{ "UNRECOGNISED FIRST RECORD", atcsironet },
	{ "INVALID LOGIN REQUEST", atcsironet },
	{ "DISCONNECT SEEN FROM", atcsironet },
	{ "[Ll]ine hung", failure },
	{ TIMEOUT, timeout },
	{ ERRSTR, failure },
	{ EOFSTR, eof },
	{ 0, 0}
};

struct patlist	csiroreq[] =
{
	{ "UNIX SERVICE", tobasser },
	{ "NOT COMMUNICATING", failure },
	{ "NO FREE PORTS", failure },
	{ "NO PORT AVAILABLE", failure },
	{ TIMEOUT, timeout },
	{ ERRSTR, failure },
	{ EOFSTR, eof },
	{ 0, 0}
};

struct patlist atbasser[] =
{
	{ "[Ll]ogin", gotlogin },
	{ "UNRECOGNISED FIRST RECORD", tocsironet },
	{ "TERMINAL IS UNASSIGNED", tocsironet },
	{ "INVALID LOGIN REQUEST", tocsironet },
	{ "DISCONNECT SEEN FROM", tocsironet },
	{ "NO RESPONSE FROM", tocsironet },
	{ TIMEOUT, timeout },
	{ ERRSTR, failure },
	{ EOFSTR, eof },
	{ 0, 0 }
};

struct patlist basserlogin[] =
{
	{ "[Pp]assword", gotpasswd },
	{ STARTMSG, started},	/* some moron might have deleted passwd */
	{ START2MSG, start2 },	/* alternate protocol */
	{ "[Ll]ogin *[Ii]ncorrect", tobasser },
	{ "UNRECOGNISED FIRST RECORD", tocsironet },
	{ "TERMINAL IS UNASSIGNED", tocsironet },
	{ "DISCONNECT SEEN FROM", tocsironet },
	{ "NO RESPONSE FROM", tocsironet },
	{ TIMEOUT, timeout },
	{ ERRSTR, failure },
	{ EOFSTR, eof },
	{ 0, 0 }
};

struct patlist daemonwait[] =
{
	{ STARTMSG, started},
	{ START2MSG, start2 },				/* alternate protocol */
	{ "[Ll]ogin *[Ii]ncorrect", tobasser },
	{ "[Ww]rong *[Pp]assword", tobasser },		/* cretins ! */
	{ "UNRECOGNISED FIRST RECORD", tocsironet },
	{ "TERMINAL IS UNASSIGNED", tocsironet },
	{ "DISCONNECT SEEN FROM", tocsironet },
	{ "NO RESPONSE FROM", tocsironet },
	{ TIMEOUT, slowhost },
	{ ERRSTR, failure },
	{ EOFSTR, eof },
	{ 0, 0 }
};



args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		if ( **++argv == '-' )
		{
			register int	c;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'd':
					device = ++*argv;
					goto break2;
				case 'l':
					host = ++*argv;
					goto break2;
				case '1':
					daemon1 = ++*argv;
					goto break2;
				case '2':
					daemon2 = ++*argv;
					goto break2;
				case 'T':
#ifdef TRACE
					Traceflag = atoi(++*argv);
#endif
					goto break2;
				default:
					out("fail unexpected flag \"-");
					out(*argv);
					out("\" in ");
					out(CALLARGS);
					exit(1);
				}
			}
break2:			;
		}
		else
		{
			out("fail unexpected argument ");
			out(*argv);
			out(" in ");
			out(CALLARGS);
			exit(1);
		}
	}
}



init(argc, argv)
	int	argc;
	char	*argv[];
{
	(void)readargs(concat(SPOOLDIR(/), target, "/", CALLARGS, NULLSTR),
	    args);
	srand((getpid() << 3) + (int)time((long *)0));
	out("mode "); outend(hostflg);
	out("timeout "); outend(delay);
	out("retry "); out(retry); out(" "); outend(retries);
	out("open "); outend(device);
	out("speed "); outend(speed);
	outend("read");
	tcount = 0;
	ccount = 0;
	fcount = 0;
	todmtmelb();
}



tocsironet()
{
	tcount = 0;
	if (++ccount >= 4) {
		outend("fail can't connect through CSIRONET");
		exit(1);
	}
	mcount = 0;
	pump = "T\4";
	tostate = csironet;
	outend("sleep 2");
	outend("write T\04");
	state(csironet);
	getinput();
}



atcsironet()
{
	tcount = 0;
	if (++mcount >= 7) {
		outend("fail CSIRONET down");
		exit(1);
	}
	outend("write T\04");
	getinput();
}


csirologin()
{
	mcount = 0;
	lcount = 0;
#ifdef	TRACE
	if (Traceflag)
		out("trace "), out(csirorq), outend("\n");		/**/
#endif	TRACE
	out("write "); out(csirorq); outend("\r");
	state(csiroreq);
	getinput();
}


tobasser()
{
	if (++lcount >= 4) {
		outend("fail unable to login at basser");
		exit(1);
	}
	outend("write \r");
	state(atbasser);
	getinput();
}

todmtmelb()
{
	tcount = 0;
	lcount = 0;
	outend("write @\r");
	state(dmtlogin);
	getinput();
}


netlogin()
{
	if (++lcount >= 3) {
		outend("fail unable to login at dmtmelb");
		exit(1);
	}
#ifdef	TRACE
	if (Traceflag)
		out("trace :"), out("csiro"), outend("\r");		/**/
#endif	TRACE
	out("write :"); out("csiro"); outend("\r");
	state(unixnet);
	getinput();
}


gotlogin()
{
#ifdef	TRACE
	if (Traceflag)
		out("trace "), out(host), outend("\r");			/**/
#endif	TRACE
	out("write "); out(host); outend("\r");
	pump = "\r";
	tostate = atbasser;
	state(basserlogin);
	getinput();
}


gotpasswd()
{
#ifdef	TRACE
	if (Traceflag)
		out("trace "), out("passwd"), outend("\r");		/**/
#endif	TRACE
	out("write "); out(passwd); outend("\r");
	state(daemonwait);
	getinput();
}


started()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon1);
	out("succeed "); outend(target);
	exit(0);
}


start2()
{
#ifdef	TRACE
	if (Traceflag)
		outend("trace call succeeded, daemon 2 starting");	/**/
#endif	TRACE
	out("daemon "); outend(daemon2);
	out("succeed "); out(hostflg); out(" "); outend(target);
	exit(0);
}


timeout()
{
	if (++tcount >= 3)
	{
		outend("fail timeout");
		exit(1);
	}
	out("write "); outend(pump);
	state(tostate);
	reset();
}


failure()
{
	ccount = 0;
	if (++fcount >= 4) {
		outend("fail repeated failures");
		exit(1);
	}
	outend("close");
	sleep(((rand() >> 3) % (4 * 60)) + (3 * 60));
	out("retry "); out(retry); out(" "); outend(retries);
	out("open "); outend(device);
	out("speed "); outend(speed);
	outend("read");
	todmtmelb();
}

eof()
{
	outend("fail lost line to dmtmelb");
	exit(1);
}

slowhost()
{
	if (++tcount >= 4) {
		outend("fail basser not responding");
		exit(1);
	}
	reset();
}
