/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)crc.c	1.8 85/08/16
*/

/*
**	Packet check bytes calculation
**
**	CRC16:  x**16 + x**15 + x**2 + 1
*/

#ifndef	AS
#include	"global.h"
#endif	AS


#ifdef	vax

#ifndef	AS

/*
**	Vax "crc" instruction look-up table for polynomial = 0120001
*/

long	crc16t[] =
{
	       0, 0146001, 0154001,  012000, 0170001,  036000,  024000, 0162001
	,0120001,  066000,  074000, 0132001,  050000, 0116001, 0104001,  042000
};

/*ARGSUSED*/
bool
crc(s, n)
	char *	s;
	int	n;
{
	asm("	crc	_crc16t,$0,8(ap),*4(ap)	");
	asm("	cmpw	r0,(r3)			");
	asm("	beqlu	OK			");
	asm("	movw	r0,(r3)			");
	asm("	movl	$1,r0			");
	asm("	ret				");
	asm("OK:movw	r0,(r3)			");
	return false;
}

/*ARGSUSED*/
Crc_t
acrc(c, s, n)
	Crc_t	c;
	char *	s;
	int	n;
{
	asm("	crc	_crc16t,4(ap),12(ap),*8(ap)	");
	asm("	ret					");
#	ifdef	lint
	return c;
#	endif
}

#else	AS

	.text
	.align	1
	.globl	null
null:	.word	0
	ret

#endif	AS

#endif	vax

#if	!defined(vax) && !defined(AS)

Crc_t	crc16t_[256] =
{
	       0, 0140301, 0140601,    0500, 0141401,   01700,   01200, 0141101
	,0143001,   03300,   03600, 0143501,   02400, 0142701, 0142201,   02100
	,0146001,   06300,   06600, 0146501,   07400, 0147701, 0147201,   07100
	,  05000, 0145301, 0145601,   05500, 0144401,   04700,   04200, 0144101
	,0154001,  014300,  014600, 0154501,  015400, 0155701, 0155201,  015100
	, 017000, 0157301, 0157601,  017500, 0156401,  016700,  016200, 0156101
	, 012000, 0152301, 0152601,  012500, 0153401,  013700,  013200, 0153101
	,0151001,  011300,  011600, 0151501,  010400, 0150701, 0150201,  010100
	,0170001,  030300,  030600, 0170501,  031400, 0171701, 0171201,  031100
	, 033000, 0173301, 0173601,  033500, 0172401,  032700,  032200, 0172101
	, 036000, 0176301, 0176601,  036500, 0177401,  037700,  037200, 0177101
	,0175001,  035300,  035600, 0175501,  034400, 0174701, 0174201,  034100
	, 024000, 0164301, 0164601,  024500, 0165401,  025700,  025200, 0165101
	,0167001,  027300,  027600, 0167501,  026400, 0166701, 0166201,  026100
	,0162001,  022300,  022600, 0162501,  023400, 0163701, 0163201,  023100
	, 021000, 0161301, 0161601,  021500, 0160401,  020700,  020200, 0160101
	,0120001,  060300,  060600, 0120501,  061400, 0121701, 0121201,  061100
	, 063000, 0123301, 0123601,  063500, 0122401,  062700,  062200, 0122101
	, 066000, 0126301, 0126601,  066500, 0127401,  067700,  067200, 0127101
	,0125001,  065300,  065600, 0125501,  064400, 0124701, 0124201,  064100
	, 074000, 0134301, 0134601,  074500, 0135401,  075700,  075200, 0135101
	,0137001,  077300,  077600, 0137501,  076400, 0136701, 0136201,  076100
	,0132001,  072300,  072600, 0132501,  073400, 0133701, 0133201,  073100
	, 071000, 0131301, 0131601,  071500, 0130401,  070700,  070200, 0130101
	, 050000, 0110301, 0110601,  050500, 0111401,  051700,  051200, 0111101
	,0113001,  053300,  053600, 0113501,  052400, 0112701, 0112201,  052100
	,0116001,  056300,  056600, 0116501,  057400, 0117701, 0117201,  057100
	, 055000, 0115301, 0115601,  055500, 0114401,  054700,  054200, 0114101
	,0104001,  044300,  044600, 0104501,  045400, 0105701, 0105201,  045100
	, 047000, 0107301, 0107601,  047500, 0106401,  046700,  046200, 0106101
	, 042000, 0102301, 0102601,  042500, 0103401,  043700,  043200, 0103101
	,0101001,  041300,  041600, 0101501,  040400, 0100701, 0100201,  040100
};
#endif	Table

#ifdef	pdp11

#ifdef	AS
/*
**	bool crc(string, length)
**	char *string;
*/
	.globl	_crc16t_
	.globl	_crc
_crc:
	len=r0
	crc=r1
	str=r2
	byt=r3

	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	6(sp),str
	mov	8.(sp),len
	clr	crc
1:
	movb	(str)+,byt
	xor	crc,byt
	bic	$177400,byt
	asl	byt
	mov	_crc16t_(byt),byt
	clrb	crc
	swab	crc
	xor	byt,crc
	sob	len,1b

	cmpb	crc,*str
	jeq	1f
	inc	len
1:
	movb	crc,(str)+
	swab	crc
	cmpb	crc,*str
	jeq	1f
	inc	len
1:
	movb	crc,(str)+
	mov	(sp)+,r3
	mov	(sp)+,r2
	rts	pc
/*
**	Crc_t acrc(crc, string, length)
**	Crc_t crc;
**	char *string;
*/
	.globl	_acrc
_acrc:
	crc=r0
	len=r1
	str=r2
	byt=r3

	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	6(sp),crc
	mov	8.(sp),str
	mov	10.(sp),len
1:
	movb	(str)+,byt
	xor	crc,byt
	bic	$177400,byt
	asl	byt
	mov	_crc16t_(byt),byt
	clrb	crc
	swab	crc
	xor	byt,crc
	sob	len,1b

	mov	(sp)+,r3
	mov	(sp)+,r2
	rts	pc
#endif	AS

#endif	pdp11

#ifdef	mc68000

#ifdef	AS
/*
**	bool crc(string, length)
**	char *string;
*/
#ifdef	BELL_68K
	text
	global	crc16t_
	global	crc
crc:
	link	%fp,&crcF
	movm.l	&crcM,crcS(%fp)
	mov.l	8(%fp),%a2
	mov.l	&0,%d2
	mov.w	12(%fp),%d4
	ble	crc%140
crc%170:
	mov.b	(%a2)+,%d0
	eor.b	%d2,%d0
	and.l	&255,%d0
	add.l	%d0,%d0
	mov.l	&crc16t_,%a1
	mov.w	0(%a1,%d0.l),%d0
	lsr.w	&8,%d2
	eor.w	%d0,%d2
	sub.w	&1,%d4
	bgt	crc%170
crc%140:
	cmp.b	%d2,(%a2)
	beq	crc%180
	add.w	&1,%d4
crc%180:
	mov.b	%d2,(%a2)+
	lsr.w	&8,%d2
	cmp.b	%d2,(%a2)
	beq	crc%190
	add.w	&1,%d4
crc%190:
	mov.b	%d2,(%a2)+
	mov.w	%d4,%d0
	movm.l	crcS(%fp),&crcM
	unlk	%fp
	rts
	set	crcS,-16
	set	crcF,-22
	set	crcM,02034
#else	BELL_68K

/*
#ifdef	SUN_68K
**
**	SUN Workstation assembler version
*/
	.text
	.globl	_crc16t_
/*
**	bool crc(string, length)
**	char *string;
*/
	.globl	_crc
_crc:
	link	a6,#-LF13
	moveml	#LS13,sp@
	movl	a6@(8),a5
	clrw	d7
#ifdef	INT16BIT
	movw	a6@(12),d6
#else	INT16BIT
	movl	a6@(12),d6
#endif	INT16BIT
	jle	L15
L18:
	movb	a5@+,d0
	eorw	d7,d0
	andl	#0xff,d0
	addl	d0,d0
	movl	#_crc16t_,a0
	movw	a0@(0,d0:L),d0
	lsrw	#8,d7
	eorw	d0,d7
	subqw	#1,d6
	jgt	L18
	clrl	d0
L15:
	cmpb	a5@,d7
	jeq	L19
	movl	#1,d0
L19:
	movb	d7,a5@+
	lsrw	#8,d7
	cmpb	a5@,d7
	jeq	L20
	movl	#1,d0
L20:
	movb	d7,a5@+
	moveml	a6@(-LF13),#LS13
	unlk	a6
	rts

	LF13 = 12
	LS13 = 0x20c0
	LP13 =	8
/*
**	Crc_t acrc(crc, string, length)
**	Crc_t crc;
**	char *string;
*/
	.globl	_acrc
_acrc:
	link	a6,#-LF22
	moveml	#LS22,sp@
	movw	a6@(10),d7
	movl	a6@(12),a5
#ifdef	INT16BIT
	movw	a6@(16),d6
#else	INT16BIT
	movl	a6@(16),d6
#endif	INT16BIT
	jle	L24
L27:
	movb	a5@+,d0
	eorw	d7,d0
	andl	#0xff,d0
	addl	d0,d0
	movl	#_crc16t_,a0
	movw	a0@(0,d0:L),d0
	lsrw	#8,d7
	eorw	d0,d7
	subqw	#1,d6
	jgt	L27
L24:
	movw	d7,d0
	moveml	a6@(-LF22),#LS22
	unlk	a6
	rts

	LF22 = 12
	LS22 = 0x20c0
	LP22 =	8
#endif	BELL_68K
#endif	AS

#endif	mc68000

#ifdef	ns16000

#ifdef  AS
/*
**	bool crc(string,length)
**	char	*string;
*/
	.import		_crc16t_
.program
	.exportp	_crc
	.exportp	_acrc

str:	.EQU		r7
byt:	.EQU		r6
crc:	.EQU		r1
len:	.EQU		r0

_crc::
	enter	[r7,r6,r1],0
	movzwd	12(fp), str
	movzwd	16(fp), len
	cmpqd	0,	len
	beq	L2
	movqd	0,	crc
L1:
	movb	0(str),	byt
	addqd	1, str
	xorw	crc, byt
	bicd	h'ffffff00, byt
	movzwd	_crc16t_[byt:w], byt
	bicb	h'0ff, crc
	rotw	8, crc
	xorw	byt, crc
	acbw	-1, len, L1
L2:
	cmpb	crc, 0(str)
	beq	L3
	movqd	1, len
L3:
	movb	crc, 0(str)
	rotw	8, crc
	cmpb	crc, 1(str)
	beq	L4
	movqd	1, len
L4:
	movb	crc, 1(str)
	exit	[r7,r6,r1]
	rxp	0

/*
**	Crc_t acrc(crc, string, length)
**	Crc_t crc;
**	char *string;
*/

astr:	.EQU		r7
abyt:	.EQU		r6
alen:	.EQU		r1
acrc:	.EQU		r0
_acrc::
	enter	[r7,r6,r1],0
	movzwd	12(fp), acrc
	movzwd	16(fp), astr
	movzwd	20(fp), alen
L5:
	movb	0(str), abyt
	addqw	1, astr
	xorw	acrc, abyt
	bicd	h'ffffff00,abyt
	movzwd	_crc16t_[abyt:w], abyt
	bicb	h'ff, acrc
	rotw	8, acrc
	xorw	abyt, acrc
	acbw	-1, alen, L5
	exit	[r7,r6,r1]
	rxp	0
.endseg
#endif AS
#endif ns16000

#if	!defined(vax) && !defined(pdp11) && !defined(mc68000) && !defined(ns16000) && !defined(AS)

bool
crc(buffer, nbytes)
	register char *	buffer;
	int		nbytes;
{
	register Crc_t	tcrc = 0;
	register int	i;

	if ( (i = nbytes) > 0 )
	do
		tcrc = crc16t_[(tcrc^(*buffer++))&0xff] ^ ((tcrc>>8)&0xff);
	while
		( --i > 0 );

	i = (int)false;

	if ( LOCRC(tcrc) != BYTE(*buffer) )
		i = (int)true;
	*buffer++ = LOCRC(tcrc);

	if ( HICRC(tcrc) != BYTE(*buffer) )
		i = (int)true;
	*buffer++ = HICRC(tcrc);

	return (bool)i;
}


Crc_t
acrc(tcrc, buffer, nbytes)
	register Crc_t	tcrc;
	register char *	buffer;
	int		nbytes;
{
	register int	i;

	if ( (i = nbytes) > 0 )
	do
		tcrc = crc16t_[(tcrc^(*buffer++))&0xff] ^ ((tcrc>>8)&0xff);
	while
		( --i > 0 );

	return tcrc;
}

#endif	C-version
