/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID %W% %E%
*/

/*
**	Create a file for error output (use "KeepErrFile" if set),
**	unless "stderr" is already assigned to a tty.
*/

#define	FILE_CONTROL

#include	"global.h"

#include	"debug.h"

char *		KeepErrFile;

extern Time_t	Time;



void
MakeErrFile(fdp)
	int *	fdp;
{
	if ( !ErrorTty(fdp) )
	{
		register int	fd;
		register char *	errfile;

		if ( (errfile = KeepErrFile) == NULLSTR )
			errfile = UniqueName(newstr(TMPDIR(error.file....)), (long)0, Time);

#		if	defined(O_CREAT)
		while ( (fd = open(errfile, O_RDWR|O_CREAT, 0600)) == SYSERROR )
#		else	defined(O_CREAT)
		while
		(
			(fd = creat(errfile, 0600)) == SYSERROR
			||
			close(fd) == SYSERROR
			||
			(fd = open(errfile, O_RDWR)) == SYSERROR
		)
#		endif	defined(O_CREAT)
			Syserror("Can't creat \"%s\"", errfile);

		if ( KeepErrFile == NULLSTR )
		{
			(void)unlink(errfile);
			free(errfile);
		}

		*fdp = fd;
	}
}
