/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SetFthFiles.c	1.2 84/06/29
*/

/*
**	Concatenate info from FthFiles list into FthFdesc field.
*/

#include	"global.h"
#include	"ftheader.h"

char		FthFdRestricted[]	= { FTH_FSEP, FTH_FDSEP, '\0' };

extern void	QuoteChars();



void
SetFthFiles()
{
	register int		n;
	register char *		cp;
	register FthFD_p	flp;

	for ( flp = FthFiles, n = 0 ; flp != (FthFD_p)0 ; flp = flp->f_next )
		n += strlen(flp->f_name) + LENGTH_SIZE + TIME_SIZE+1 + MODE_SIZE + 4;

	if ( n > 0 )
	{
		FthFdescs = cp = Malloc(n);

		for ( flp = FthFiles ; ; )
		{
			register char *	ocp = cp;
			char		length[LENGTH_SIZE];

			cp = strcpyend(cp, flp->f_name);
			QuoteChars(ocp, FthFdRestricted);
			*cp++ = FTH_FDSEP;

			(void)sprintf(length, "%lu", flp->f_length);
			cp = strcpyend(cp, length);
			*cp++ = FTH_FDSEP;

			(void)sprintf(length, "%lu", flp->f_time);
			cp = strcpyend(cp, length);
			*cp++ = FTH_FDSEP;

			(void)sprintf(length, "%3o", flp->f_mode);
			cp = strcpyend(cp, length);

			if ( (flp = flp->f_next) != (FthFD_p)0 )
				*cp++ = FTH_FSEP;
			else
				break;
		}
	}
	else
		FthFdescs = NULLSTR;
}
