/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ReadHeader.c	1.2 84/06/22
*/

/*
**	Read in a message header from file.
**
**	Returns "hr_ok" if successful, otherwise a failure reason.
*/

#include	"global.h"
#include	"header.h"



HdrReason
ReadHeader(fd)
	int			fd;
{
	register char **	fp;
	register char *		cp;
	register int		len;
	register long		l;
	char			length[HDR_LENGTH_SIZE+1];

	if
	(
		(DataLength = lseek(fd, (long)-HDR_LENGTH_SIZE, 2)) == SYSERROR
		||
		read(fd, length, HDR_LENGTH_SIZE) != HDR_LENGTH_SIZE
	)
		return hr_badread;

	length[HDR_LENGTH_SIZE] = '\0';

	if ( (l = atol(length)) > DataLength || l < MIN_HDR_LEN )
		return hr_badlen;

	len = l;
	HdrLength = len + HDR_LENGTH_SIZE;

	if ( Header != NULLSTR )
		free(Header);

	Header = Malloc(len);

	if
	(
		(DataLength = lseek(fd, (long)-HdrLength, 2)) == SYSERROR
		||
		read(fd, Header, len) != len
	)
		return hr_badread;

	len -= CRC_SIZE;

	if ( crc(Header, len) )
		return hr_badcrc;

	if ( Header[0] != HDR_TYP1[0] )
		return ht_type;

	for
	(
		fp = HdrFields.hf_start, cp = Header ;
		fp < &HdrFields.hf_start[NHDRFIELDS] ;
		fp++
	)
	{
		*fp = cp;

		while ( len-- && *cp++ != '\0' )
			;

		if ( len < 0 )
		{
			/*
			**	Backward compatibility with pre-release version.
			*/

			register HdrReason	hr;

			if ( (hr = (HdrReason)(fp - HdrFields.hf_start)) == ht_subpt )
			{
				HdrSubpt = "";
				hr = hr_ok;
			}

			return hr;
		}
	}

	return hr_ok;
}
