.\" tbl domains.mm | troff -mm
.nr Hy 0
.ds HF 3 3 2 2 2 2 2
.TL
Domain Addressing in SUN\ III
.AF "Sydney University"
.AU "Bob Kummerfeld"
.AU "Piers Lauder"
.AS
A form of hierarchical addressing
employing the concept of \fIdomain\fP has been introduced in \s-1SUN\ III\s0.
Domains can be equivalent to geographical addresses,
and allow a uniform presentation of addresses that are universally valid.
.AE
.OF "''\\\\*(DT''"
.EF "''\\\\*(DT''"
.MT 4
.SA 1
.H 1 INTRODUCTION
Computer message addresses are changing. 
As computer networks are interconnecting to form a world-wide net,
there is a need for computer message addresses
as universally valid and as easy to use as postal addreses
or telephone numbers.
.P
Until now, those of us using the
Sydney Unix\*F
.FS
UNIX is a trademark of AT&T Bell Laboratories.
.FE
Network\*F
.FS
The latest is version III and will be referred to as SUN\ III.
.FE
have been living in a simple community,
as though everyone lived in the same street and it was only necessary to know
people's names and house numbers to identify them uniquely.
Now a city has grown up around us,
with links to other cities and countries,
and street addresses are no longer unique.
.P
The concept of a \fIdomain\fP has been introduced\*F
.FS
ARPA RFC 882
.FE
to describe the arrangement of addresses within computer networks.
A domain is a grouping of computers to support a common purpose,
such as all those computers running a particular type of network software,
or all the computers in a university campus,
or all the computers in a particular country.
Domains enable us to generate a computer network address
that can not only be used to deliver a message to a local destination,
but will also deliver a message to the same destination
from anywhere in the world.
.P
For example,
the following table shows a traditional postal address with the components
distinguished by separate lines,
together with the equivalent components from a network address:
.DS
.TS
center box ;
l l .
Piers Lauder	piers
Computer Science	cs
Sydney University	su
Australia	oz
.TE
.DE
.P
When presented to the network,
the address would appear as
.DS C
.S +2
piers.cs.su.oz
.S
.DE
(the line separators have been replaced by periods.)
.P
.ne 4
Previously,
the network address for this destination would have been
.DS C
.S +2
piers:basser
.S
.DE
which has only two components and
is probably easier to remember,
but is only valid in Australia on \s-1SUN\s0 sites.
.P
The \fB:basser\fP is a node identifier\c
\(emthe name of a particular computer\(em\c
and it is not something
everyone should be required to remember.
.P
There are potentially thousands of network nodes in Australia alone,
and for this address form to work,
there must be some data-base
that knows how to deliver a message to every one of them.
.P
By contrast,
for the domain addresses to work anywhere in the world,
a local data-base need only retain knowledge of the routes
to those major domains outside,
and to each of the domains contained within,
its own domain.
An analogy is telephone switching,
where each exchange need only remember its own local numbers,
and know how to switch calls out to other area codes.
.P
We have sacrificed some ``user friendliness''
to reduce a computing task,
but consider the problem of communicating with other continents.
Here is the address that must be used to reach
a colleague in California at UC San Diego Computer Science
from anywhere in Australia:
.DS C
.S +2
decvax!ucbvax!sdcsvax!sdamos!john:mulga
.S
.DE
Here is a more arcane example:
.DS C
.S +2
decvax!ucbvax!@\s-1SU-SCORE.ARPA\s0:john%unc.csnet@csnet-relay:mulga
.S
.DE
This routes first via \s-1SUN\s0 to \fBmulga\fP,
then to \fBdecvax\fP and \fBucbvax\fP by \s-1UUCP\s0,
then by \s-1CSNET\s0 to \fBcsnet-relay\fP,
then to \fBunc.csnet\fP using \s-1CSNET\s0,
which then sends to \s-1SU-SCORE\s0 via \s-1ARPANET\s0
for delivery to user \fBjohn\fP. \fICaveat sender.\fP
.P
The domain version of this would be
.DS C
.S +2
john.\s-1SU-SCORE.ARPA.CSNET.UUCP\s0
.S
.DE
but this just reproduces the problems of explicit routing,
using domains instead of nodes.
What would be best of all is the domain version of the postal address:-
.DS C
.S +2
john.cs.stanford.usa
.S
.DE
.P
Although addresses have become slightly more complex
for communicating within Australia,
they will become much less complex for the general case.
And of course there are abbreviated forms
for addresses within a local domain.
In the same way that a letter addressed
to someone in Sydney from someone in Melbourne
need never specify ``Australia'',
a message from Melbourne to Sydney need not specify ``.oz''.
So, for example,
here are the addresses needed to reach the author from various places:
.DS
.TS
center box ;
c c
l l .
Message source	Address
_
Computer Science, Sydney University	piers
Psychology Department, Sydney University	piers.cs
Computer Science, Melbourne University	piers.cs.su
Bell Laboratories, NJ, USA	piers.cs.su.oz
.TE
.DE
.P
The domains taking part in this form of addressing are known as 
\fIhierarchical\fP
domains.
That is, each domain is fully contained within another,
and can be considered as a geographical mapping.
At any one level,
there is a domain to describe every area in the world.
There are also non-hierarchical domains.
For instance,
all those sites taking part in the Australian Computer Science Network
belong to the domain ``acsnet'',
and this domain crosses geographical boundaries.
One use of non-hierarchical domains
is to consider them as special interest groups,
and one may, for instance, address messages to everyone within them.
Thus the address
.DS C
.S +2
netgurus.*.acsnet
.S
.DE
will deliver a message to the identity ``netgurus''
at every site belonging to the domain ``acsnet''.
.H 1 "DOMAIN ROUTING MECHANISM"
The underlying transport mechanism of \s-1SUN\ III\s0
knows how to deliver messages to
.I handlers
at 
.I nodes .
Nodes are linked to neighbouring nodes to form a network.
.I Nodes
correspond to computers,
and
.I handlers
embody protocols that can address users.
.P
\s-1SUN\ III\s0 implements domains by attaching 
a list of accessible domains to each node.
The route to a domain is therefore the same as the route to the nearest node
(in the network routing sense)
in that domain.
Nodes are the lowest level in the domain hierarchy,
and can be considered as domains with one member.
.H 2 "Primary and Secondary Domains"
While a node may belong to many domains,
it is considered to have one 
.I primary
domain which specifies
the set of nodes from which this node will be directly addressable.
Any other domains are
.I secondary
and specify all other domains whose members
will be directly addressable from this node.
.P
Some of the domains will be fully contained within others,
as a Computer Science Department
is contained within a University,
which is contained within a country.
These domains,
one of which must be the \fIprimary\fP,
are considered to belong to a local hierarchy.
All other domains to which the node belongs
are considered to be non-hierarchical.
The hierarchy nominates which domains are sub-domains,
each domain in the hierarchical list
being completely contained within its successor.
.P
The hierarchy is used to detect sub-domains
in domain lists presented from other nodes,
and to reject different domains with the same name.
An obvious example of this problem arises
where there are two local domains called ``cs'',
but one is Computer Science at Melbourne University,
and the other is Computer Science at Sydney University.
.H 2 "Source Address Construction"
As messages proceed through the network,
they may cross domain boundaries.
At each boundary,
it is necessary to augment the source address so that the message
(or a reply)
may be correctly returned to its source.
.P
The routing mechanism at each node notices when a new destination
does not belong to the same primary domain as the source
(or most recent node in the route),
and appends an appropriate part
of the local domain hierarchy
to the source address.
Every time a message arrives at a node,
the source address is scanned from the right hand end,
and each domain to which the local node belongs is removed.
In this manner,
at any one node in the route,
the source address always contains the minimum set of domains
to identify the source uniquely.
.P
An example is given by the progress of a message
addressed to a node ``snb'' in the domain ``btl'' inside ``usa''
from the node ``psych23'' inside the domains ``psych'', ``su'' and ``oz'':
.DS
.TS
center box ;
c | c s | c s
c | l l | l l
l | l l | l l .
\^	Domains	Addresses
Node	Primary	Hierarchy	Source	Destination
_
psych23	psych	psych.su.oz	psych23	snb.btl.usa
psych44	su	psych.su.oz	psych23.psych	snb.btl.usa
basser40	su	cs.su.oz	psych23.psych	snb.btl.usa
basser	oz	cs.su.oz	psych23.psych.su.oz	snb.btl.usa
research	usa	btl.usa	psych23.psych.su.oz	snb
snb	btl	btl.usa	psych23.psych.su.oz	\ 
.TE
.DE
The source address is built up at ``psych44'' from where the message
crosses out of the domain ``psych'' into the domain ``su'',
and at ``basser'' from where the message
crosses out of the domains ``su'' and ``oz'' into the domains
``usa'' and ``btl''. 
Notice that as each destination domain is reached,
it is removed from the destination address.
.H 1 "INTER-NETWORK GATEWAYS USING DOMAINS"
Most of the problems with current addressing mechanisms for computer messages
stem from the interfaces required at gateways between different networks.
The \s-1SUN\ III\s0 domain mechanism allows gateway handlers to be attached
to the name of a domain at a node.
Then instead of being delivered locally,
a message addressed to such a domain will be passed to its handler.
The handler may massage the message and its address
to conform to the new network,
and pass it on.
.P
Thus the domain ``\s-1UUCP\s0'' is considered to include
all the nodes that communicate via the \s-1UUCP\s0 network.
Those nodes with interfaces to the \s-1UUCP\s0 network
from the \s-1SUN\s0 network will attach a gateway handler to the domain
``\s-1UUCP\s0'',
and pass messages from \s-1SUN\s0 to \s-1UUCP\s0 via the handler.
.P
.ne 6
From \s-1SUN\s0,
the gateways to \s-1UUCP\s0
are identified by their declared membership of the domain ``\s-1UUCP\s0'',
and messages may be routed to the nearest node supporting the gateway.\*F
.FS
Of course,
the gateway handlers must be fairly intelligent about
manipulating the \s-1UUCP\s0 addresses
to correspond to the alternate points of entry to an explicitly routed network,
but that's another story.
.FE
A simple example of an address that would make use of a domain gateway is
.DS C
.S +2
john.decvax.\s-1UUCP\s0
.S
.DE
Such an address form is an expediency,
pending the introducton of geographic domain addressing on the other network.
.H 1 "ROUTING EFFICIENCIES"
In practice,
the introduction of domains has reduced the number of nodes
visible at the highest level by a factor of two.
With O(\fIn\fP\u\s-3\&2\s0\d) routing algorithms,
this is a great saving.
Better still,
for nodes at lower levels,
the amount of routing information has been cut by up to a factor of ten,
making network membership a much more affordable option.
.P
There is another benefit in the area of network topology maintenance.
A broadcast address is defined
as one that delivers its message to every node
in the primary domain of the sender
(unless overridden by explicitly naming a domain for the broadcast).
This mechanism considerably reduces network routing traffic,
which uses broadcast addressing to distribute topology changes,
as messages that previously were sent to every node
may now be confined within the relevant domain.
.\".TC
.CS
