#!/bin/sh
#
#	SCCSID	@(#)netsend.sh	2.2 83/05/02
#

# OBSOLETE print/file interface to "ACSnet"

HOSTUSER="username[:hostname]";		# you can switch this to fix all msgs

USAGE="${HOSTUSER} [file ...]"

SENDFILE=/bin/sendfile

#
# HOSTNAME should be assigned the name of your host. Use a command
# that provides this information if one exists (like "uname -n", "hostname",
# or even "uuname -l") otherwise, just build the name in here.
#
HOSTNAME='`uname -n`'

#
# LNAME must be set to the login id of the current user. There are
# many ways on various systems to achieve this, on some it will be
# set already (by getty or login), on others there is a USER variable
# or perhaps LOGID that contains this information. If none of
# these exist, perhaps you have a 'whoami' command that just prints
# a user name. Failing that, "who am I" can usually be edited into
# the right form.
#

if [ $# -lt 1 ]
then
	echo "Usage: $0 $USAGE"
	exit 1
fi

CPIO=n TAR=n flag=-e

case "$0"
in
	*netprint|*netpr*|*netlpr)
		QFLAG=-aprinter
		eval flag=-e-i$LNAME:$HOSTNAME
		;;
	*netcpio)
		if [ $# != 2 -o ! -d "$2" ]
		then
			echo Usage: "$0" "${HOSTUSER} directory"
			exit 1;
		fi
		CPIO=y
		QFLAG=
		;;
	*nettar)
		if [ $# != 2 -o ! -d "$2" ]
		then
			echo Usage: "$0" "${HOSTUSER} directory"
			exit 1;
		fi
		TAR=y
		QFLAG=
		;;
	*netsend|*netsend.sh)
		QFLAG=
		;;
	*)
		echo "Usage: $0 $USAGE"
		exit 1
		;;
esac

#
# nb:	to reverse user:host to host:user, just switch NAME & HOST
#	on next two lines	(and alter the HOSTUSER equate at the top)
#
HOST=`expr "$1" : '.*:\([^:]*\)'`
NAME=`expr "$1:" : '\([^:]*\):.*'`

if [ ${NAME}x = x -a ${QFLAG}x = -aprinterx -a ${LNAME}x != x ]
then
	NAME=$LNAME
fi
if [ ${HOST}x = x ]
then
	eval HOST=$HOSTNAME
fi

if [ ${NAME}x = x -o ${HOST}x = x ]
then
	echo "Usage: $0 $USAGE"
	exit 1
fi

if [ $CPIO = y ]
then
	cd "$2"
	DIR="`pwd`"
	BASE="`basename $DIR`"
	cd ..
	find "$BASE" -print | cpio -o | \
		$SENDFILE "-u$NAME" "-d$HOST" "-n${BASE}.cpio"
elif [ $TAR = y ]
then
	cd "$2"
	DIR=`pwd`
	BASE=`basename $DIR`
	cd ..
	tar cf - "$BASE" | $SENDFILE "-u$NAME" "-d$HOST" "-n${BASE}.tar"
else
	shift
	mflag=-
	for arg
	do
		case "$arg"
		in
			-A)		mflag=${mflag}A ;;
			-C)		mflag=${mflag}C ;;
			-AC|-CA)	mflag=-AC ;;
			#
			# unknown flags (except -i!) are passed to the far end
			# via the '-e' sendfile option.
			# (mostly used for netprint to select printer ...)
			#
			-i*)	;;
			-*)	flag="$flag $arg" ;;
			#
			# flags stop at the first file name
			#
			*)	break ;;
		esac
		shift
	done

	if [ $mflag = - ]
	then
		mflag=-e
	fi

	$SENDFILE $QFLAG "-u$NAME" "-d$HOST" "$mflag" "$flag" $*
	exit $?
fi
