/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)AdjustSource.c	1.11 84/10/19
*/

/*
**	If `to' and `from' don't share the same primary domain,
**	remove all local domains from "source",
**	and concatenate `from's primary domain with the source address.
**
**	If `from's primary domain is in the local hierarchy,
**	also concatenate any higher domains in hierarchy to which
**	`to' doesn't belong.
*/

#include	"global.h"
#include	"address.h"
#include	"debug.h"
#include	"header.h"
#include	"state.h"

#include	"route.h"



char *
AdjustSource(source, from, to)
	char *			source;
	int			from;
	int			to;
{
	register int		i;
	register int		j;
	register char *		cp;
	register char **	cpp;
	register int		prim;
	register Address *	ap;
	char *			newsource;
	NodeLink		nl;

	Trace4
	(
		1,
		"AdjustSource \"%s\" for message from \"%s\" to \"%s\"",
		source,
		RT_NODE(from)->ne_name,
		RT_NODE(to)->ne_name
	);

	if
	(
		from == (NodeCount-1)
		||
		(prim = RT_NODE(from)->ne_primary) == LINK_N_A
		||
		(i = RT_NODE(to)->ne_primary) == LINK_N_A
		||
		i == prim
	)
		return NULLSTR;
	
	ap = SplitAddress(source);

	if ( (i = ap->ad_domains) > 0 )
		for ( cpp = &ap->ad_strings[i] ; i > 0 ; i-- )
		{
			if
			(
				!FindDomain(*cpp--, &nl)
				||
				nl.nl_link != (NodeCount-1)
			)
				break;

			if ( nl.nl_domind == prim )
			{
				i--;
				break;
			}
		}

	if ( i == 0 && strcmp(ap->ad_node, HomeNode) == STREQUAL )
	{
		FreeAddress(ap);
		return NULLSTR;
	}

	newsource = cp = Malloc((NODE_NAME_SIZE+1)*(LevelCount+1) + strlen(source) + 1);

	for ( cpp = ap->ad_strings ; ; )
	{
		cp = strcpyend(cp, *cpp++);

		if ( i-- > 0 )
			*cp++ = DOMAIN_SEP;
		else
			break;
	}

	*cp++ = DOMAIN_SEP;
	cp = strcpyend(cp, RT_DOMAIN(prim)->de_name);

	if ( (i = RT_DOMAIN(prim)->de_hierarchy) != LINK_N_A )
		for ( to *= DomainCount ; ++i < LevelCount ; )
		{
			prim = *RT_LEVEL(i);
			j = to + prim;

			if ( MemberTable[j/8] & (1<<(j%8)) )
				break;

			*cp++ = DOMAIN_SEP;
			cp = strcpyend(cp, RT_DOMAIN(prim)->de_name);
		}

	FreeAddress(ap);

	Trace2(2, "AdjustSource returns \"%s\"", newsource);

	return newsource;
}
