/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SetDmnActive.c	1.6 84/10/30
*/

/*
**	Set the process id in a daemon's status file.
**	The inactivity of the daemon should already
**	have been established by a call to "DaemonActive()".
*/

#define	FILE_CONTROL

#include	"global.h"
#include	"debug.h"

#include	"command.h"
#include	"spool.h"
#include	"Stream.h"



bool
SetDaemonActive(path, pid)
	char *		path;
	int		pid;
{
	register int	fd;
	register bool	result;
	register char *	statusfile;
	NN_state	nnstate;

	if ( path[0] != '/' )
		statusfile = concat(SPOOLDIR(), path, "/", STATUSFILE, NULLSTR);
	else
		statusfile = concat(path, "/", STATUSFILE, NULLSTR);

	Trace4(1, "SetDaemonActive(%s, %d) -> \"%s\"", path, pid, statusfile);

	if ( (fd = open(statusfile, O_RDWR)) != SYSERROR )
	{
		if ( read(fd, (char *)&nnstate, sizeof nnstate) == sizeof nnstate )
		{
			nnstate.procid = pid;
			nnstate.procstate = PROC_OPENING;
			nnstate.linkstate = LINK_DOWN;
			nnstate.lasttime = nnstate.starttime = time(&nnstate.thistime)-1;
			nnstate.activetime = 0;
			nnstate.allbytes = 0;
			nnstate.allmessages = 0;
			nnstate.inpkts = 0;
			nnstate.outpkts = 0;

			(void)lseek(fd, (long)0, 0);

			result = (bool)(write(fd, (char *)&nnstate, sizeof nnstate) == sizeof nnstate);
		}
		else
			result = false;

		(void)close(fd);
	}
	else
		result = false;

	free(statusfile);

	Trace2(1, "SetDaemonActive returns %d", result);

	return result;
}
