/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)GetFthTo.c	1.1 84/06/12
*/

/*
**	Extract any users claimed to be at this node from 'FthTo' list.
**
**	Returns number of users found.
*/

#include	"global.h"
#include	"ftheader.h"


extern char	FthToRestricted[];
extern void	UnQuoteChars();



int
GetFthTo()
{
	register char *	s = FthTo;
	register char *	u;
	register FthUlist *up;
	register char *	a;
	register char *	d;

	for ( ;; )
	{
		if ( (a = strchr(s, FTH_UDSEP)) != NULLSTR )
			*a = '\0';
		
		if ( (d = strchr(s, FTH_UDEST)) != NULLSTR )
		{
			*d = '\0';
			if ( !AtHome(d+1) )
				goto cont;
		}

		/*
		**	Extract users at this host.
		*/

		for ( ;; )
		{
			if ( (u = strchr(s, FTH_USEP)) != NULLSTR )
				*u = '\0';
			
			NFthUsers++;
			up = Talloc(FthUlist);
			up->u_next = FthUsers;
			up->u_dest = NULLSTR;
			FthUsers = up;
			up->u_name = newstr(s);
			UnQuoteChars(up->u_name, FthToRestricted);

			if ( (s = u) != NULLSTR )
				*s++ = FTH_USEP;
			else
				break;
		}
cont:
		if ( d != NULLSTR )
			*d = FTH_UDEST;
		
		if ( (s = a) != NULLSTR )
			*s++ = FTH_UDSEP;
		else
			break;
	}

	return NFthUsers;
}
