$1 == "Times"	{
			if ($2 < First || First == 0)
				First = $2;
			if ($3 > Last)
				Last = $3;
			next;
		}

$1 == "Messages"	{
			Messages[$2] += $3;
			Bytes[$2] += $4;
			next;
		}

$1 == "Handler"	{
			HadM = 1;
			Handler[$2] += $3;
			HandlerBytes[$2] += $4;
			next;
		}

$1 == "Source"	{
			MsgFrom[$2] += $3;
			BytesFrom[$2] += $4;
			Delays[$2] += $5;
			DelayPeriod[$2] += $6;
			next;
		}

$1 == "Destination" {
			MsgTo[$2] += $3;
			BytesTo[$2] += $4;
			next;
		}

$1 == "RetHndlr" {
			HadR = 1;
			RetHndlr[$2] += $3;
			RetHndlB[$2] += $4;
			next;
		}

$1 == "RetFrom"	{
			RetFrom[$2] += $3;
			RetBytesFrom[$2] += $4;
			next;
		}

$1 == "RetTo"	{
			RetTo[$2] += $3;
			RetBytesTo[$2] += $4;
			next;
		}

		{
			if ($2 < First || First == 0)
				First = $2;
			if ($2 > Last)
				Last = $2;
			Bytes[$1] += $3;
			Messages[$1]++;
		}

$1 == "M"	{
			HadM = 1;
			MsgFrom[$5]++;
			BytesFrom[$5] += $3;
			if ($8 != "") {
				DelayPeriod[$5] += $8;
				Delays[$5]++;
			}
			i = split($4, dest, ",");
			for (j = 1; j <= i; j++) {
				if (dest[j] == "")
					continue;
				MsgTo[dest[j]]++;
				BytesTo[dest[j]] += $3;
			}
			HandlerBytes[$7] += $3;
			Handler[$7]++;
		}

$1 == "R"	{
			HadR = 1;
			RetTo[$4]++;
			RetBytesTo[$4] += $3;
			RetFrom[$5]++;
			RetBytesFrom[$5] += $3;
			RetHndlr[$7]++;
			RetHndlB[$7] += $3;
		}

END		{
			if (Messages["M"] != 0)
				printf "Normal messages:   %6d, %8d bytes, average %5.2f bytes/message\n\n", Messages["M"], Bytes["M"], Bytes["M"]/Messages["M"];

			if (HadM) {
				printf "%-16s%10s%12s%12s\n", "Handler", "messages", "bytes", "avg size";
				for (h in Handler)
					printf "%-16s%10d%12d%12.2f\n", h, Handler[h], HandlerBytes[h], HandlerBytes[h]/Handler[h];

				printf "\n";

				printf "%-16s%10s%12s%12s%12s\n", "Source", "messages", "bytes", "avg size", "avg delay";
				for (h in MsgFrom) {
					printf "%-16s%10d%12d%12.2f", h, MsgFrom[h], BytesFrom[h], BytesFrom[h]/MsgFrom[h];
					if (Delays[h] != 0)
						printf "%12.2f", DelayPeriod[h]/Delays[h];
					printf "\n";
				}
				printf "\n";
				printf "%-16s%10s%12s%12s\n", "Destination", "messages", "bytes", "avg size";
				for (h in MsgTo)
					printf "%-16s%10d%12d%12.2f\n", h, MsgTo[h], BytesTo[h], BytesTo[h]/MsgTo[h];

				printf "\n";
			}

			if (Messages["R"] != 0)
				printf "Returned messages: %6d, %8d bytes, average %5.2f bytes/message\n\n", Messages["R"], Bytes["R"], Bytes["R"]/Messages["R"];


			if (HadR) {
				printf "%-16s%10s%12s%12s\n", "Handler", "messages", "bytes", "avg size";
				for (h in RetHndlr)
					printf "%-16s%10d%12d%12.2f\n", h, RetHndlr[h], RetHndlB[h], RetHndlB[h]/RetHndlr[h];

				printf "\n";

				printf "%-16s%10s%12s%12s\n", "Source", "messages", "bytes", "avg size";
				for (h in RetFrom)
					printf "%-16s%10d%12d%12.2f\n", h, RetFrom[h], RetBytesFrom[h], RetBytesFrom[h]/RetFrom[h];

				printf "\n";

				printf "%-16s%10s%12s%12s\n", "Destination", "messages", "bytes", "avg size";
				for (h in RetTo)
					printf "%-16s%10d%12d%12.2f\n", h, RetTo[h], RetBytesTo[h], RetBytesTo[h]/RetTo[h];
				printf "\n";
			}

			if (Last != 0) {
				Time = Last - First;
				printf "%d bytes in %d messages over period of %d+%02d:%02d:%02d\n\n", Bytes["M"]+Bytes["R"], Messages["M"]+Messages["R"], Time/(60*60*24), (Time/(60*60))%24, (Time/60)%60, Time%60;
			}
		}
