/*
 *	ACSnet UDP/IP call setup
 */

#define	STDIO

#include "global.h"

#if	BSD4 < 2

main()
{
	fprintf(stderr, "Replace this tacky system with a real one\n");
	fprintf(stderr, "and try again...\n");
}

#else	BSD4 < 2

#define	STD_PORT	950		/* random, < IPPORT_RESERVED */
#define	RETRY_LIMIT	10		/* max attempts to connect */
#define	WAIT_PERIOD	5		/* period bewteen attempts */
#define	DEAD_HOST	60		/* period between retry to dead host */
#define	NND_EXIT	30		/* time to wait after NNdaemon exits */

#include <sys/types.h>
#include <sys/socket.h>

#include <errno.h>
#include <netdb.h>
#include <setjmp.h>
#include <signal.h>

#include <netinet/in.h>

#include <arpa/inet.h>			/* just for debug really */

struct sockaddr_in addr;
struct sockaddr_in myaddr;
int addlen;

jmp_buf	timeout;

char NNdaemon[] = "/usr/spool/ACSnet/_lib/ENdaemon";
char ReqMsg[] = "ACSnet connection request";

char buf[512];
int  Dpid = 0;

int dingdong(), termin();

main(argc, argv)
	char **argv;
{
	register sfd;
	register struct hostent *hp;
	register struct servent *sp;
	register i, n;
	register lport;

	if (argc < 2) {
		fprintf(stderr, "Usage: udpcall host\n");
		exit(1);
	}

	hp = gethostbyname(argv[1]);
	if (hp == (struct hostent *)0) {
		fprintf(stderr, "%s: host not in database\n", argv[1]);
		exit(1);
	}

	sp = getservbyname("ACSnet", "udp");
	if (sp == (struct servent *)0) {
		fprintf(stderr, "ACSnet/udp: no such service\n");
		exit(1);
	}

	sfd = socket(AF_INET, SOCK_DGRAM, 0, 0);
	if (sfd < 0) {
		perror("socket");
		exit(1);
	}

	myaddr.sin_family = AF_INET;
	/*
	 * only accept datagrams from the host we're trying to
	 * talk to.  I wonder if that's what this really means
	 */
	/*
	bcopy(hp->h_addr, (caddr_t)&myaddr.sin_addr, hp->h_length);
	*/

	for (i = 0, lport = STD_PORT; i < 30; i++, lport++) {
		myaddr.sin_port = htons(lport);
		if (bind(sfd, &myaddr, sizeof myaddr, 0) < 0) {
			extern int errno;

			if (errno == EADDRINUSE)
				continue;

			perror("bind");
			exit(1);
		} else
			break;
	}

	if (i >= 30) {
		fprintf(stderr, "Damn bad show, eh what!\n");
		exit(1);
	}

	addr.sin_port = sp->s_port;
	addr.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr, (caddr_t)&addr.sin_addr, hp->h_length);

	alarm(0);
	signal(SIGTERM, termin);

	for (;;) {
		signal(SIGALRM, dingdong);
		for (i = 0; i < RETRY_LIMIT; i++) {
			extern int errno;

			if (setjmp(timeout))
				continue;
			alarm(WAIT_PERIOD);

			if (sendto(sfd, ReqMsg, strlen(ReqMsg), 0,
			    &addr, sizeof addr) < 0) {
				register e = errno;

				alarm(0);
				errno = e;
				perror("sendto");
				exit(1);
			}

			addlen = sizeof addr;
			if ((n=recvfrom(sfd,buf,sizeof buf,0,&addr,&addlen))>=0)
				break;

			pause();		/* wait for alarm */
		}

		alarm(0);

		if (i >= RETRY_LIMIT) {
			fseek(stderr, 0L, 2);
			fprintf(stderr, "Host %s not responding\n", argv[1]);
			sleep(DEAD_HOST);
			continue;
		}

#ifdef	DEBUG
		printf("cudp: connection made to %d/%s\n", ntohs(addr.sin_port),
			inet_ntoa(addr.sin_addr));
		printf("Data <<%.*s>> (%d)\n", n, buf, n);
#endif

		if (connect(sfd, &addr, addlen) < 0) {
			fseek(stderr, 0L, 2);
			perror("cudp: connect");
			exit(1);
		}

		if ((Dpid = fork()) == -1) {
			Dpid = 0;
			sleep(5);
			continue;
		}

		if (Dpid != 0) {
			int stat;

			while ((n = wait(&stat)) != -1 && n != Dpid)
				continue;

			Dpid = 0;

			if (n == -1 || stat != 0) {
				sleep(NND_EXIT);
				continue;
			}

			exit(0);	/* NNdaemon finished normally */
		}

		/*
		 * now we have establisted a "connection" to the remote
		 * end, we can start NNdaemon ...
		 */

		dup2(sfd, 1);

		close(0);
		for (i = getdtablesize(); i >= 2; i--)
			close(i);

		/*
		 * -F -> don't fork
		 * -d -> use file descriptor 1
		 */
		execle(NNdaemon,
		    "ENdaemon+UDP", "-Fd", argv[1], (char *)0, (char **)0);
		exit(1);
	}
}

dingdong()
{
	longjmp(timeout, 1);
}

termin()
{
	if (Dpid != 0)
		kill(Dpid, SIGTERM);
	exit(0);
}

/*
 * without this, we get the one in ../Lib which brings in with
 * it all kinds of other trash.
 *
 * Why must people redefine standard library funcs ?????
 */
sleep(n)
{
	if (setjmp(timeout)) {
		alarm(0);
		signal(SIGALRM, SIG_IGN);
		return;
	}
	signal(SIGALRM, dingdong);
	alarm(n);
	for (;;)
		pause();
}

#endif	BSD4 < 2
