/*
 *	watergate	- the filter
 *
 *	ACSnet filter to sit on a link and record information on messages
 *	passing through link. The information recorded is -
 *
 *	message handler, inwards(I)/outwards(O) bound message, message origin,
 *	machine origin, message destination, machine destination,
 *	size (in bytes), time stamp, message environment.
 *
 *	Burn Alting	Sometime 1986
 *	If you modify this code I would be appreciated if you would send
 *	said mods back to me. Perhaps one day I'll have time to get back
 *	to this. (OH to be a programmer again!!!!!)
 *	burn@metro.ucc.su.oz
 */

#define	FILE_CONTROL
#define	STDIO
#define	LOCKING

#include	"global.h"
#include	"ftheader.h"
#include	"header.h"
#include	"handlers.h"
#include	"sub_proto.h"
#include	"sysexits.h"

#include	<time.h>

/*
 *	Parameters set from arguments
 */
char	* Name;			/* what is my name - watergate */
char	* rpt_handler;		/* what handler is message going to */
char	* rpt_from;		/* from whom did the message come from */
char	* rpt_to;		/* to whom is the message going to */
char	* rpt_link;		/* upon what link am I running */
char	* rpt_source;		/* where did I come from - NO Lies */
char	* rpt_destination;	/* where am I going to - NO Lies */
char	* rpt_env;		/* message environment */
char	  rpt_direction;	/* is message inwards/outwards bound */
long	  rpt_size;		/* size in bytes of message */
long	  rpt_dsize;		/* data size in bytes of message */

/*
 *	Misc junk
 */

#define	ACCT_ERR	-1		/* I had to call it something " */
#define	RPT_SEP		'|'
#define	ESC_CH		'\\'
#define	MSG_OVERHEAD	8		/* no. of bytes added to message after
					   filter has checked message
					   This probably exits somewhere in the
					   include files but I don't have time
					   to find it.
					 */

FILE		* acct_fd;
Handler 	* handler;
FthReason	fthr;
char		* esc_char();
char		* strcpy();
char		* malloc();
int		strlen();
void		finish();

main(ac, av)
register int	ac;
register char	* av[];
{
	extern int	getopt();
	extern int	optind;
	extern char	* optarg;
	bool		read_header();
	char		* acct_file;
	char		* acct_on;
	long		t_stamp;
	struct tm	* stamp;
#if	AUTO_LOCKING != 1
	int		open_count;
#endif	AUTO_LOCKING
	int		fd;
	register int	c;

	while ((c = getopt(ac, av, "IOa:b:c:d:e:h:l:s:")) != EOF)
		switch(c)
		{
		case 'I' :
		case 'O' :
			rpt_direction = c;
			break;
		case 'b' :
			rpt_handler = newstr(optarg);
			break;
		case 'l' :
			rpt_link = newstr(optarg);
			break;
		case 's' :
			rpt_source = newstr(optarg);
			break;
		case 'a' :
			rpt_destination = newstr(optarg);
			break;
		case 'e' :
		case 'c' :
		case 'h' :
			break;
		case 'd' :
			rpt_dsize = atoi(optarg);
			break;
		case '?' :
			Error("Internal ACSnet Error !!!! bad arguements");
			return ACCT_ERR;
		}

	acct_file = concat(SPOOLDIR(_accts/), rpt_link, NULLSTR);
	acct_on = concat(SPOOLDIR(_accts/), "ON.", rpt_link, NULLSTR);

	/*
	 *	If the acct "on" file doesn't exist don't do any accounting
	 */
	if (access(acct_on, 00) != 0)
		return EX_OK;

	if ((acct_fd = fopen(acct_file, "a")) == NULL)
	{
		Error("cannot open accounts file for link - \"%s\"", rpt_link);
		return ACCT_ERR;
	}

	if (read_header(av[optind]) == false)
	{
		(void)fclose(acct_fd);
		return ACCT_ERR;
	}
	(void)time(&t_stamp);
	stamp = localtime(&t_stamp);

	fd = fileno(acct_fd);
#if	AUTO_LOCKING != 1
	open_count = 0;

	while (Lock(acct_file, fd, for_writing) == SYSERROR)
	{
		if (open_count++ < 10)
			sleep(5);
		else
		{
			Error("cannot lock accounts file for link - \"%s\"",
				rpt_link);
			return ACCT_ERR;
		}
	}
#endif	AUTO_LOCKING
	(void)fprintf(acct_fd,
		"%s%c%c%c%s%c%s%c%s%c%s%c%ld%c%ld%c%2.2d%2.2d%2.2d%2.2d%2.2d%c%s\n",
			rpt_handler, RPT_SEP, rpt_direction, RPT_SEP,
			rpt_from, RPT_SEP, rpt_source, RPT_SEP,
			rpt_to, RPT_SEP, rpt_destination, RPT_SEP,
			rpt_size,  RPT_SEP, rpt_dsize, RPT_SEP,
			stamp->tm_year, stamp->tm_mon + 1, stamp->tm_mday,
			stamp->tm_hour, stamp->tm_min, RPT_SEP,
			rpt_env);
	UnLock(fd);
	(void)fclose(acct_fd);
	return EX_OK;

}

bool
read_header(fn)
char	* fn;
{
	bool		read_ftp();
	register int	fd;
	HdrReason	hr;
	bool		val = false;

	if ((fd = open(fn, O_READ)) == SYSERROR)
	{
		Error("couldn't open data file - \"%s\"", fn);
		return false;
	}

	if ((hr = ReadHeader(fd)) != hr_ok)
	{
		Error("ReadHeader failed - \"%s\".\n", HeaderReason(hr));
		(void)close(fd);
		return false;
	}

	if ( HdrSubpt[0] == FTP)
		val = read_ftp(fd);

	if (val == false)
	{
		rpt_from = HdrSource;
		rpt_to = HdrDest;
	}

	rpt_size = HdrLength + DataLength + MSG_OVERHEAD;

	if (HdrEnv[0] != '\0')
	{
		char	* tmp;

		tmp = concat(ExpandString(HdrEnv, strlen(HdrEnv)), NULLSTR);
		rpt_env = esc_char(tmp, RPT_SEP, ESC_CH);
		free(tmp);
	}
	else
		rpt_env = "";

	return true;
}

bool
read_ftp(fd)
int	fd;
{
	register char	* s;

	if ((fthr = ReadFtHeader(fd, DataLength, false)) != fth_ok)
	{
		Error("Bad ReadFTHeader - \"%s\".\n", FTHREASON(fthr));
		(void)close(fd);
		return false;
	}
	(void)close(fd);
	rpt_from = concat(FthFrom, "@", HdrSource, NULLSTR);
	rpt_to = concat(FthTo, "@", HdrDest, NULLSTR);
	return true;
}

char	*
esc_char(s, ch, esc_ch)
register char	* s;
char		ch;
char		esc_ch;
{
	register char	* ptr;
	register char	c;
	static char	buf[512];

	ptr = buf;
	while ((c = *s++))
	{
		if (c == ch)
			*ptr++ = esc_ch;
		*ptr++ = c;
	}
	*ptr = '\0';

	return buf;
}

void
finish(error)
int	error;
{
	(void)exit(error);
}
