BEGIN	{
	FS = "|"
	byte_sum = 0
	msg_sum = 0
	}
{
	handler		= $1
	direction	= $2
	from		= $3
	mach_from	= $4
	to		= $5
	mach_to		= $6
	size		= $7
	time_stamp	= $8
	env		= $9

	#
	#	See if we can reduce the address fields by looking at
	#	host names of the "from" and "to" fields.
	#

	n = split(from, tmp, "@")
	if (tmp[n - 1] == tmp[n])
	{
		tmp_str = tmp[1]
		for (i = 2; i < n; i++)
			tmp_str = tmp_str "@" tmp[i]
		from = tmp_str
	}
	n = split(to, tmp, "@")
	if (tmp[n - 1] == tmp[n])
	{
		tmp_str = tmp[1]
		for (i = 2; i < n; i++)
			tmp_str = tmp_str "@" tmp[i]
		to = tmp_str
	}

	#
	#	Split the size field if this record has already been summarised
	#

	orig = split(size, tmp, "@")

	#
	#	Is there a message change ?????
	#

	if (old_handler != handler || old_direction != direction || old_from != from || old_to != to)
	{
		if (old_handler != "")
		printf "%s:%s:%s:%s:%s:%s:%ld@%ld:\n", old_handler, old_direction, old_from, old_mach_from, old_to, old_mach_to, byte_sum, msg_sum
		old_handler = handler
		old_direction = direction
		old_from = from
		old_mach_from = mach_from
		old_to = to
		old_mach_to = mach_to
		if (orig == 1)		# then original message
		{
			byte_sum = size
			msg_sum = 1
		}
		else			# else message previously accumulated
		{
			byte_sum = tmp[1]
			msg_sum = tmp[2]
		}
	}
	else
	{
		if (orig == 1)		# then original message
		{
			byte_sum = byte_sum + size
			msg_sum++
		}
		else			# else message previously accumulated
		{
			byte_sum = byte_sum + tmp[1]
			msg_sum = msg_sum + tmp[2]
		}
	}
}	END {
	if (byte_sum != 0)
		printf "%s:%s:%s:%s:%s:%s:%ld@%ld:\n", old_handler, old_direction, old_from, old_mach_from, old_to, old_mach_to, byte_sum, msg_sum
	}
