/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)ReadFtHead.c	1.1 84/06/12
*/

/*
**	Read in a file transfer header from file.
**
**	Returns "fth_ok" if successful, otherwise a failure reason.
*/

#define	STDIO

#include	"global.h"
#include	"ftheader.h"



FthReason
ReadFtHeader(fd, end, check)
	int			fd;
	long			end;
	bool			check;
{
	register char **	fp;
	register char *		cp;
	register int		len;
	register long		l;
	char			length[FTH_LENGTH_SIZE+1];

	if
	(
		lseek(fd, end-FTH_LENGTH_SIZE, 0) == SYSERROR
		||
		read(fd, length, FTH_LENGTH_SIZE) != FTH_LENGTH_SIZE
	)
		return fth_badread;

	length[FTH_LENGTH_SIZE] = '\0';

	if ( (l = atol(length)) > end || l < MIN_FTH_LENGTH )
		return fth_badlen;

	FthLength = l;

	if ( FtHeader != NULLSTR )
		free(FtHeader);

	FtHeader = Malloc(FthLength);

	if
	(
		(FtDataLength = lseek(fd, end-(l+FTH_LENGTH_SIZE), 0)) == SYSERROR
		||
		read(fd, FtHeader, FthLength) != FthLength
	)
		return fth_badread;

	if ( crc(FtHeader, FthLength-CRC_SIZE) )
		return fth_badcrc;

	if ( TYPOF_FTH(BYTE(FtHeader[0])) != FTH_TYP1 )
		return fth_type;

	for
	(
		fp = FthFields.fth_start, cp = FtHeader, len = FthLength-CRC_SIZE ;
		fp < &FthFields.fth_start[NFTHFIELDS] ;
		fp++
	)
	{
		*fp = cp;

		while ( len-- && *cp++ != '\0' )
			;

		if ( len < 0 )
			return (FthReason)(fp - FthFields.fth_start);
	}

	if ( check && (FthType[0] & FTH_DATACRC) )
	{
		register int	i;
		register Crc_t	crc;
		char		buf[BUFSIZ];

		(void)lseek(fd, (long)0, 0);

		for ( l = FtDataLength, crc = 0 ; l > 0 ; l -= i )
		{
			if ( l > sizeof buf )
				len = sizeof buf;
			else
				len = l;

			if ( (i = read(fd, buf, len)) > 0 )
				crc = acrc(crc, buf, i);
			else
			if ( i == SYSERROR )
				return fth_badread;
		}

		DataCrc = crc;
		cp = &FtHeader[FthLength-(2*CRC_SIZE)];

		if
		(
			BYTE(*cp++) != LOCRC(DataCrc)
			||
			BYTE(*cp) != HICRC(DataCrc)
		)
			return fth_baddatacrc;
	}

	return fth_ok;
}
