/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)daemon.h	1.4 84/11/05
*/

/*
**	Global parameters for daemon functions
*/

#define		DOWNTIME	(5*60)	/* Wait this long before marking link down */

Extern bool	BatchMode;		/* Transfer all queued messages and stop */
Extern bool	ContinuousUpdate;	/* Update status frequently */
Extern bool	Cook;			/* Cooked mode for 7-bit circuits */
Extern char *	HomeNode;		/* Our node name */
Extern char *	LinkDir;		/* The remote node's name */
Extern char *	MultiPath;		/* Set if multi-path mode */
Extern char *	Name;			/* The process name */
Extern bool	NoAdjust;		/* Don't adjust protocol parameters */
Extern int	Pid;			/* The Process ID */
Extern int	RemoteFd;		/* Unix file descriptor for link */
Extern int	(*Write)();		/* Function to do output */

extern char *	MessageHandler;		/* Name of message handler process */
extern char *	NewstateHandler;	/* Name of state change process */
extern char *	BadHandler;		/* Name of bad message handler process */

extern char *	FinishReason;		/* Reason to be printed on termination */

/*
**	Protocol parameters
*/

extern int	DevSpeed;		/* Device magic number for speed of link */
extern int	Fstream;		/* Number of first stream in use */
extern int	IntraPktDelay;		/* Maximum intra-packet delay */
extern int	MinSpeed;		/* Minimum speed prepared to accept */
extern int	Nbufs;			/* Number of buffers in use */
extern int	Nstreams;		/* Number of streams in use */
extern int	PktZ;			/* Packet size on link */
extern int	Speed;			/* Notional bytes/sec. for link */
extern bool	UseCrc;			/* True if CRC in use on link */

/*
**	Directory and file names
*/

extern char *	Baddir;			/* Directory in Spooldir for bad messages */
extern char *	Daemondir;		/* Directory in Spooldir for daemon command files */
extern char *	Slash;			/* "/" */
extern char *	Spooldir;		/* Name of spool directory where network directories are kept */
extern char *	Statusfile;		/* File name for state info. */
extern char	Template[];		/* Last component of node-node command file name */
extern char *	Workdir;		/* Directory in Spooldir for temporary files */

/*
**	State file update commands
*/

typedef enum
{
	up_date, up_force, up_finish, up_error, up_opening
}
		StCom;

/*
**	Magic signals for changing trace level
*/

#define	SIGTRCON	SIGEMT
#define	SIGTRCOFF	SIGFPE

/*
**	Daemon functions
*/

int		RCwrite(),
		write();

bool		open_remote();

void		close_remote(),
		closeall(),
		finish();
